/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.eventbasedrevenuerecognitionintegration.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link EventBasedRevenueRecognitionIntegrationServiceBatchChangeSet} interface, enabling you to
 * combine multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.EventBasedRevenueRecognitionIntegrationService
 * EventBasedRevenueRecognitionIntegrationService}.
 *
 */
public class DefaultEventBasedRevenueRecognitionIntegrationServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<EventBasedRevenueRecognitionIntegrationServiceBatch, EventBasedRevenueRecognitionIntegrationServiceBatchChangeSet>
    implements
    EventBasedRevenueRecognitionIntegrationServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.EventBasedRevenueRecognitionIntegrationService service;

    @SuppressWarnings( "deprecation" )
    DefaultEventBasedRevenueRecognitionIntegrationServiceBatchChangeSet(
        @Nonnull final DefaultEventBasedRevenueRecognitionIntegrationServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.EventBasedRevenueRecognitionIntegrationService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultEventBasedRevenueRecognitionIntegrationServiceBatchChangeSet getThis()
    {
        return this;
    }

}
