/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.eventbasedrevenuerecognitionintegration.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.eventbasedrevenuerecognitionintegration.Et_ActionResult;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.eventbasedrevenuerecognitionintegration.selectable.Et_ActionResultSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.eventbasedrevenuerecognitionintegration.Et_ActionResult
 * Et_ActionResult} to other entities. Instances of this object are used in query modifier methods of the entity fluent
 * helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class Et_ActionResultLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<Et_ActionResultLink<ObjectT>, Et_ActionResult, ObjectT>
    implements
    Et_ActionResultSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public Et_ActionResultLink( final String fieldName )
    {
        super(fieldName);
    }

    private Et_ActionResultLink( final EntityLink<Et_ActionResultLink<ObjectT>, Et_ActionResult, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected Et_ActionResultLink<ObjectT> translateLinkType(
        final EntityLink<Et_ActionResultLink<ObjectT>, Et_ActionResult, ObjectT> link )
    {
        return new Et_ActionResultLink<ObjectT>(link);
    }

}
