/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.field.PlannedIndepRqmtField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.link.PlannedIndepRqmtLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.selectable.PlannedIndepRqmtSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Planned Independent Requirement
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PlannedIndepRqmtType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PlannedIndepRqmt extends VdmEntity<PlannedIndepRqmt>
{

    /**
     * Selector for all available fields of PlannedIndepRqmt.
     *
     */
    public final static PlannedIndepRqmtSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtField<Boolean> UPDATE_MC = new PlannedIndepRqmtField<Boolean>("Update_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_PlndIndepRqmtItem_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_PlndIndepRqmtItem_oc" )
    @JsonProperty( "to_PlndIndepRqmtItem_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_PlndIndepRqmtItem_oc" )
    private Boolean plndIndepRqmtItem_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_PlndIndepRqmtItem_oc</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtField<Boolean> PLND_INDEP_RQMT_ITEM_OC =
        new PlannedIndepRqmtField<Boolean>("to_PlndIndepRqmtItem_oc");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtField<String> PRODUCT = new PlannedIndepRqmtField<String>("Product");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtField<String> PLANT = new PlannedIndepRqmtField<String>("Plant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     *
     * @return MRP Area
     */
    @Key
    @SerializedName( "MRPArea" )
    @JsonProperty( "MRPArea" )
    @Nullable
    @ODataField( odataName = "MRPArea" )
    private String mRPArea;
    /**
     * Use with available fluent helpers to apply the <b>MRPArea</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtField<String> MRP_AREA = new PlannedIndepRqmtField<String>("MRPArea");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PlndIndepRqmtType</b>
     * </p>
     *
     * @return Requirements type
     */
    @Key
    @SerializedName( "PlndIndepRqmtType" )
    @JsonProperty( "PlndIndepRqmtType" )
    @Nullable
    @ODataField( odataName = "PlndIndepRqmtType" )
    private String plndIndepRqmtType;
    /**
     * Use with available fluent helpers to apply the <b>PlndIndepRqmtType</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtField<String> PLND_INDEP_RQMT_TYPE =
        new PlannedIndepRqmtField<String>("PlndIndepRqmtType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PlndIndepRqmtVersion</b>
     * </p>
     *
     * @return Version Number for Independent Requirements
     */
    @Key
    @SerializedName( "PlndIndepRqmtVersion" )
    @JsonProperty( "PlndIndepRqmtVersion" )
    @Nullable
    @ODataField( odataName = "PlndIndepRqmtVersion" )
    private String plndIndepRqmtVersion;
    /**
     * Use with available fluent helpers to apply the <b>PlndIndepRqmtVersion</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtField<String> PLND_INDEP_RQMT_VERSION =
        new PlannedIndepRqmtField<String>("PlndIndepRqmtVersion");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RequirementPlan</b>
     * </p>
     *
     * @return Requirements Plan
     */
    @Key
    @SerializedName( "RequirementPlan" )
    @JsonProperty( "RequirementPlan" )
    @Nullable
    @ODataField( odataName = "RequirementPlan" )
    private String requirementPlan;
    /**
     * Use with available fluent helpers to apply the <b>RequirementPlan</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtField<String> REQUIREMENT_PLAN =
        new PlannedIndepRqmtField<String>("RequirementPlan");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RequirementSegment</b>
     * </p>
     *
     * @return Requirement Segment
     */
    @Key
    @SerializedName( "RequirementSegment" )
    @JsonProperty( "RequirementSegment" )
    @Nullable
    @ODataField( odataName = "RequirementSegment" )
    private String requirementSegment;
    /**
     * Use with available fluent helpers to apply the <b>RequirementSegment</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtField<String> REQUIREMENT_SEGMENT =
        new PlannedIndepRqmtField<String>("RequirementSegment");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RequirementPlanIsExternal</b>
     * </p>
     *
     * @return Indicates that the Requirement Plan is external
     */
    @SerializedName( "RequirementPlanIsExternal" )
    @JsonProperty( "RequirementPlanIsExternal" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "RequirementPlanIsExternal" )
    private Boolean requirementPlanIsExternal;
    /**
     * Use with available fluent helpers to apply the <b>RequirementPlanIsExternal</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtField<Boolean> REQUIREMENT_PLAN_IS_EXTERNAL =
        new PlannedIndepRqmtField<Boolean>("RequirementPlanIsExternal");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PlndIndepRqmtInternalID</b>
     * </p>
     *
     * @return Independent Requirements Pointer
     */
    @SerializedName( "PlndIndepRqmtInternalID" )
    @JsonProperty( "PlndIndepRqmtInternalID" )
    @Nullable
    @ODataField( odataName = "PlndIndepRqmtInternalID" )
    private String plndIndepRqmtInternalID;
    /**
     * Use with available fluent helpers to apply the <b>PlndIndepRqmtInternalID</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtField<String> PLND_INDEP_RQMT_INTERNAL_ID =
        new PlannedIndepRqmtField<String>("PlndIndepRqmtInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PlndIndepRqmtIsActive</b>
     * </p>
     *
     * @return Indicator: Version Active
     */
    @SerializedName( "PlndIndepRqmtIsActive" )
    @JsonProperty( "PlndIndepRqmtIsActive" )
    @Nullable
    @ODataField( odataName = "PlndIndepRqmtIsActive" )
    private String plndIndepRqmtIsActive;
    /**
     * Use with available fluent helpers to apply the <b>PlndIndepRqmtIsActive</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtField<String> PLND_INDEP_RQMT_IS_ACTIVE =
        new PlannedIndepRqmtField<String>("PlndIndepRqmtIsActive");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @return WBS Element
     */
    @SerializedName( "WBSElement" )
    @JsonProperty( "WBSElement" )
    @Nullable
    @ODataField( odataName = "WBSElement" )
    private String wBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElement</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtField<String> WBS_ELEMENT = new PlannedIndepRqmtField<String>("WBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PlndIndepRqmtAcctAssgmtCat</b>
     * </p>
     *
     * @return Account Assignment Category
     */
    @SerializedName( "PlndIndepRqmtAcctAssgmtCat" )
    @JsonProperty( "PlndIndepRqmtAcctAssgmtCat" )
    @Nullable
    @ODataField( odataName = "PlndIndepRqmtAcctAssgmtCat" )
    private String plndIndepRqmtAcctAssgmtCat;
    /**
     * Use with available fluent helpers to apply the <b>PlndIndepRqmtAcctAssgmtCat</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtField<String> PLND_INDEP_RQMT_ACCT_ASSGMT_CAT =
        new PlannedIndepRqmtField<String>("PlndIndepRqmtAcctAssgmtCat");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>PlndIndepRqmtLastChgdDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "PlndIndepRqmtLastChgdDateTime" )
    @JsonProperty( "PlndIndepRqmtLastChgdDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "PlndIndepRqmtLastChgdDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime plndIndepRqmtLastChgdDateTime;
    /**
     * Use with available fluent helpers to apply the <b>PlndIndepRqmtLastChgdDateTime</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtField<ZonedDateTime> PLND_INDEP_RQMT_LAST_CHGD_DATE_TIME =
        new PlannedIndepRqmtField<ZonedDateTime>("PlndIndepRqmtLastChgdDateTime");
    /**
     * Navigation property <b>to_PlndIndepRqmtItem</b> for <b>PlannedIndepRqmt</b> to multiple
     * <b>PlannedIndepRqmtItem</b>.
     *
     */
    @SerializedName( "to_PlndIndepRqmtItem" )
    @JsonProperty( "to_PlndIndepRqmtItem" )
    @ODataField( odataName = "to_PlndIndepRqmtItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PlannedIndepRqmtItem> toPlndIndepRqmtItem;
    /**
     * Use with available fluent helpers to apply the <b>to_PlndIndepRqmtItem</b> navigation property to query
     * operations.
     *
     */
    public final static PlannedIndepRqmtLink<PlannedIndepRqmtItem> TO_PLND_INDEP_RQMT_ITEM =
        new PlannedIndepRqmtLink<PlannedIndepRqmtItem>("to_PlndIndepRqmtItem");

    @Nonnull
    @Override
    public Class<PlannedIndepRqmt> getType()
    {
        return PlannedIndepRqmt.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_PlndIndepRqmtItem_oc</b>
     * </p>
     *
     * @param plndIndepRqmtItem_oc
     *            Dynamic CbA-Control
     */
    public void setPlndIndepRqmtItem_oc( @Nullable final Boolean plndIndepRqmtItem_oc )
    {
        rememberChangedField("to_PlndIndepRqmtItem_oc", this.plndIndepRqmtItem_oc);
        this.plndIndepRqmtItem_oc = plndIndepRqmtItem_oc;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Material Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     *
     * @param mRPArea
     *            MRP Area
     */
    public void setMRPArea( @Nullable final String mRPArea )
    {
        rememberChangedField("MRPArea", this.mRPArea);
        this.mRPArea = mRPArea;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PlndIndepRqmtType</b>
     * </p>
     *
     * @param plndIndepRqmtType
     *            Requirements type
     */
    public void setPlndIndepRqmtType( @Nullable final String plndIndepRqmtType )
    {
        rememberChangedField("PlndIndepRqmtType", this.plndIndepRqmtType);
        this.plndIndepRqmtType = plndIndepRqmtType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PlndIndepRqmtVersion</b>
     * </p>
     *
     * @param plndIndepRqmtVersion
     *            Version Number for Independent Requirements
     */
    public void setPlndIndepRqmtVersion( @Nullable final String plndIndepRqmtVersion )
    {
        rememberChangedField("PlndIndepRqmtVersion", this.plndIndepRqmtVersion);
        this.plndIndepRqmtVersion = plndIndepRqmtVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RequirementPlan</b>
     * </p>
     *
     * @param requirementPlan
     *            Requirements Plan
     */
    public void setRequirementPlan( @Nullable final String requirementPlan )
    {
        rememberChangedField("RequirementPlan", this.requirementPlan);
        this.requirementPlan = requirementPlan;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RequirementSegment</b>
     * </p>
     *
     * @param requirementSegment
     *            Requirement Segment
     */
    public void setRequirementSegment( @Nullable final String requirementSegment )
    {
        rememberChangedField("RequirementSegment", this.requirementSegment);
        this.requirementSegment = requirementSegment;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RequirementPlanIsExternal</b>
     * </p>
     *
     * @param requirementPlanIsExternal
     *            Indicates that the Requirement Plan is external
     */
    public void setRequirementPlanIsExternal( @Nullable final Boolean requirementPlanIsExternal )
    {
        rememberChangedField("RequirementPlanIsExternal", this.requirementPlanIsExternal);
        this.requirementPlanIsExternal = requirementPlanIsExternal;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PlndIndepRqmtInternalID</b>
     * </p>
     *
     * @param plndIndepRqmtInternalID
     *            Independent Requirements Pointer
     */
    public void setPlndIndepRqmtInternalID( @Nullable final String plndIndepRqmtInternalID )
    {
        rememberChangedField("PlndIndepRqmtInternalID", this.plndIndepRqmtInternalID);
        this.plndIndepRqmtInternalID = plndIndepRqmtInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PlndIndepRqmtIsActive</b>
     * </p>
     *
     * @param plndIndepRqmtIsActive
     *            Indicator: Version Active
     */
    public void setPlndIndepRqmtIsActive( @Nullable final String plndIndepRqmtIsActive )
    {
        rememberChangedField("PlndIndepRqmtIsActive", this.plndIndepRqmtIsActive);
        this.plndIndepRqmtIsActive = plndIndepRqmtIsActive;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @param wBSElement
     *            WBS Element
     */
    public void setWBSElement( @Nullable final String wBSElement )
    {
        rememberChangedField("WBSElement", this.wBSElement);
        this.wBSElement = wBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PlndIndepRqmtAcctAssgmtCat</b>
     * </p>
     *
     * @param plndIndepRqmtAcctAssgmtCat
     *            Account Assignment Category
     */
    public void setPlndIndepRqmtAcctAssgmtCat( @Nullable final String plndIndepRqmtAcctAssgmtCat )
    {
        rememberChangedField("PlndIndepRqmtAcctAssgmtCat", this.plndIndepRqmtAcctAssgmtCat);
        this.plndIndepRqmtAcctAssgmtCat = plndIndepRqmtAcctAssgmtCat;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>PlndIndepRqmtLastChgdDateTime</b>
     * </p>
     *
     * @param plndIndepRqmtLastChgdDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setPlndIndepRqmtLastChgdDateTime( @Nullable final ZonedDateTime plndIndepRqmtLastChgdDateTime )
    {
        rememberChangedField("PlndIndepRqmtLastChgdDateTime", this.plndIndepRqmtLastChgdDateTime);
        this.plndIndepRqmtLastChgdDateTime = plndIndepRqmtLastChgdDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PlannedIndepRqmt";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Product", getProduct());
        result.put("Plant", getPlant());
        result.put("MRPArea", getMRPArea());
        result.put("PlndIndepRqmtType", getPlndIndepRqmtType());
        result.put("PlndIndepRqmtVersion", getPlndIndepRqmtVersion());
        result.put("RequirementPlan", getRequirementPlan());
        result.put("RequirementSegment", getRequirementSegment());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Update_mc", getUpdate_mc());
        values.put("to_PlndIndepRqmtItem_oc", getPlndIndepRqmtItem_oc());
        values.put("Product", getProduct());
        values.put("Plant", getPlant());
        values.put("MRPArea", getMRPArea());
        values.put("PlndIndepRqmtType", getPlndIndepRqmtType());
        values.put("PlndIndepRqmtVersion", getPlndIndepRqmtVersion());
        values.put("RequirementPlan", getRequirementPlan());
        values.put("RequirementSegment", getRequirementSegment());
        values.put("RequirementPlanIsExternal", getRequirementPlanIsExternal());
        values.put("PlndIndepRqmtInternalID", getPlndIndepRqmtInternalID());
        values.put("PlndIndepRqmtIsActive", getPlndIndepRqmtIsActive());
        values.put("WBSElement", getWBSElement());
        values.put("PlndIndepRqmtAcctAssgmtCat", getPlndIndepRqmtAcctAssgmtCat());
        values.put("PlndIndepRqmtLastChgdDateTime", getPlndIndepRqmtLastChgdDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("to_PlndIndepRqmtItem_oc") ) {
                final Object value = values.remove("to_PlndIndepRqmtItem_oc");
                if( (value == null) || (!value.equals(getPlndIndepRqmtItem_oc())) ) {
                    setPlndIndepRqmtItem_oc(((Boolean) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("MRPArea") ) {
                final Object value = values.remove("MRPArea");
                if( (value == null) || (!value.equals(getMRPArea())) ) {
                    setMRPArea(((String) value));
                }
            }
            if( values.containsKey("PlndIndepRqmtType") ) {
                final Object value = values.remove("PlndIndepRqmtType");
                if( (value == null) || (!value.equals(getPlndIndepRqmtType())) ) {
                    setPlndIndepRqmtType(((String) value));
                }
            }
            if( values.containsKey("PlndIndepRqmtVersion") ) {
                final Object value = values.remove("PlndIndepRqmtVersion");
                if( (value == null) || (!value.equals(getPlndIndepRqmtVersion())) ) {
                    setPlndIndepRqmtVersion(((String) value));
                }
            }
            if( values.containsKey("RequirementPlan") ) {
                final Object value = values.remove("RequirementPlan");
                if( (value == null) || (!value.equals(getRequirementPlan())) ) {
                    setRequirementPlan(((String) value));
                }
            }
            if( values.containsKey("RequirementSegment") ) {
                final Object value = values.remove("RequirementSegment");
                if( (value == null) || (!value.equals(getRequirementSegment())) ) {
                    setRequirementSegment(((String) value));
                }
            }
            if( values.containsKey("RequirementPlanIsExternal") ) {
                final Object value = values.remove("RequirementPlanIsExternal");
                if( (value == null) || (!value.equals(getRequirementPlanIsExternal())) ) {
                    setRequirementPlanIsExternal(((Boolean) value));
                }
            }
            if( values.containsKey("PlndIndepRqmtInternalID") ) {
                final Object value = values.remove("PlndIndepRqmtInternalID");
                if( (value == null) || (!value.equals(getPlndIndepRqmtInternalID())) ) {
                    setPlndIndepRqmtInternalID(((String) value));
                }
            }
            if( values.containsKey("PlndIndepRqmtIsActive") ) {
                final Object value = values.remove("PlndIndepRqmtIsActive");
                if( (value == null) || (!value.equals(getPlndIndepRqmtIsActive())) ) {
                    setPlndIndepRqmtIsActive(((String) value));
                }
            }
            if( values.containsKey("WBSElement") ) {
                final Object value = values.remove("WBSElement");
                if( (value == null) || (!value.equals(getWBSElement())) ) {
                    setWBSElement(((String) value));
                }
            }
            if( values.containsKey("PlndIndepRqmtAcctAssgmtCat") ) {
                final Object value = values.remove("PlndIndepRqmtAcctAssgmtCat");
                if( (value == null) || (!value.equals(getPlndIndepRqmtAcctAssgmtCat())) ) {
                    setPlndIndepRqmtAcctAssgmtCat(((String) value));
                }
            }
            if( values.containsKey("PlndIndepRqmtLastChgdDateTime") ) {
                final Object value = values.remove("PlndIndepRqmtLastChgdDateTime");
                if( (value == null) || (!value.equals(getPlndIndepRqmtLastChgdDateTime())) ) {
                    setPlndIndepRqmtLastChgdDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PlndIndepRqmtItem") ) {
                final Object value = (values).remove("to_PlndIndepRqmtItem");
                if( value instanceof Iterable ) {
                    if( toPlndIndepRqmtItem == null ) {
                        toPlndIndepRqmtItem = Lists.newArrayList();
                    } else {
                        toPlndIndepRqmtItem = Lists.newArrayList(toPlndIndepRqmtItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PlannedIndepRqmtItem entity;
                        if( toPlndIndepRqmtItem.size() > i ) {
                            entity = toPlndIndepRqmtItem.get(i);
                        } else {
                            entity = new PlannedIndepRqmtItem();
                            toPlndIndepRqmtItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PlannedIndepRqmtField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PlannedIndepRqmtField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PlannedIndepRqmtField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PlannedIndepRqmtField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ExtendedPlannedIndependentRequirementService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPlndIndepRqmtItem != null ) {
            (values).put("to_PlndIndepRqmtItem", toPlndIndepRqmtItem);
        }
        return values;
    }

    /**
     * Fetches the <b>PlannedIndepRqmtItem</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_PlndIndepRqmtItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PlannedIndepRqmtItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PlannedIndepRqmtItem> fetchPlndIndepRqmtItem()
    {
        return fetchFieldAsList("to_PlndIndepRqmtItem", PlannedIndepRqmtItem.class);
    }

    /**
     * Retrieval of associated <b>PlannedIndepRqmtItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PlndIndepRqmtItem</b>.
     * <p>
     * If the navigation property <b>to_PlndIndepRqmtItem</b> of a queried <b>PlannedIndepRqmt</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PlannedIndepRqmtItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PlannedIndepRqmtItem> getPlndIndepRqmtItemOrFetch()
    {
        if( toPlndIndepRqmtItem == null ) {
            toPlndIndepRqmtItem = fetchPlndIndepRqmtItem();
        }
        return toPlndIndepRqmtItem;
    }

    /**
     * Retrieval of associated <b>PlannedIndepRqmtItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PlndIndepRqmtItem</b>.
     * <p>
     * If the navigation property for an entity <b>PlannedIndepRqmt</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PlndIndepRqmtItem</b> is already loaded, the result will
     *         contain the <b>PlannedIndepRqmtItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PlannedIndepRqmtItem>> getPlndIndepRqmtItemIfPresent()
    {
        return Option.of(toPlndIndepRqmtItem);
    }

    /**
     * Overwrites the list of associated <b>PlannedIndepRqmtItem</b> entities for the loaded navigation property
     * <b>to_PlndIndepRqmtItem</b>.
     * <p>
     * If the navigation property <b>to_PlndIndepRqmtItem</b> of a queried <b>PlannedIndepRqmt</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PlannedIndepRqmtItem</b> entities.
     */
    public void setPlndIndepRqmtItem( @Nonnull final List<PlannedIndepRqmtItem> value )
    {
        if( toPlndIndepRqmtItem == null ) {
            toPlndIndepRqmtItem = Lists.newArrayList();
        }
        toPlndIndepRqmtItem.clear();
        toPlndIndepRqmtItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PlannedIndepRqmtItem</b> entities. This corresponds to the OData
     * navigation property <b>to_PlndIndepRqmtItem</b>.
     * <p>
     * If the navigation property <b>to_PlndIndepRqmtItem</b> of a queried <b>PlannedIndepRqmt</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PlannedIndepRqmtItem</b> entities.
     */
    public void addPlndIndepRqmtItem( PlannedIndepRqmtItem... entity )
    {
        if( toPlndIndepRqmtItem == null ) {
            toPlndIndepRqmtItem = Lists.newArrayList();
        }
        toPlndIndepRqmtItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of PlannedIndepRqmt instances.
     *
     */
    public final static class PlannedIndepRqmtBuilder
    {

        private List<PlannedIndepRqmtItem> toPlndIndepRqmtItem = Lists.newArrayList();

        private PlannedIndepRqmt.PlannedIndepRqmtBuilder toPlndIndepRqmtItem( final List<PlannedIndepRqmtItem> value )
        {
            toPlndIndepRqmtItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PlndIndepRqmtItem</b> for <b>PlannedIndepRqmt</b> to multiple
         * <b>PlannedIndepRqmtItem</b>.
         *
         * @param value
         *            The PlannedIndepRqmtItems to build this PlannedIndepRqmt with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PlannedIndepRqmt.PlannedIndepRqmtBuilder plndIndepRqmtItem( PlannedIndepRqmtItem... value )
        {
            return toPlndIndepRqmtItem(Lists.newArrayList(value));
        }

    }

}
