/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.selectable.PlannedIndepRqmtSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt
 * PlannedIndepRqmt} entity using key fields. This fluent helper allows methods which modify the underlying query to be
 * called before executing the query itself.
 *
 */
public class PlannedIndepRqmtByKeyFluentHelper
    extends
    FluentHelperByKey<PlannedIndepRqmtByKeyFluentHelper, PlannedIndepRqmt, PlannedIndepRqmtSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt
     * PlannedIndepRqmt} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param plndIndepRqmtVersion
     *            Version Number for Independent Requirements
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PlannedIndepRqmt}
     * @param product
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param mRPArea
     *            MRP Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param requirementSegment
     *            Requirement Segment
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code PlannedIndepRqmt}
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param plndIndepRqmtType
     *            Requirements type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param requirementPlan
     *            Requirements Plan
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public PlannedIndepRqmtByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String product,
        final String plant,
        final String mRPArea,
        final String plndIndepRqmtType,
        final String plndIndepRqmtVersion,
        final String requirementPlan,
        final String requirementSegment )
    {
        super(servicePath, entityCollection);
        this.key.put("Product", product);
        this.key.put("Plant", plant);
        this.key.put("MRPArea", mRPArea);
        this.key.put("PlndIndepRqmtType", plndIndepRqmtType);
        this.key.put("PlndIndepRqmtVersion", plndIndepRqmtVersion);
        this.key.put("RequirementPlan", requirementPlan);
        this.key.put("RequirementSegment", requirementSegment);
    }

    @Override
    @Nonnull
    protected Class<PlannedIndepRqmt> getEntityClass()
    {
        return PlannedIndepRqmt.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
