/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.field.PlannedIndepRqmtItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.link.PlannedIndepRqmtItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.selectable.PlannedIndepRqmtItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Planned Independent Requirement Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PlannedIndepRqmtItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PlannedIndepRqmtItem extends VdmEntity<PlannedIndepRqmtItem>
{

    /**
     * Selector for all available fields of PlannedIndepRqmtItem.
     *
     */
    public final static PlannedIndepRqmtItemSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtItemField<Boolean> UPDATE_MC =
        new PlannedIndepRqmtItemField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtItemField<String> PRODUCT = new PlannedIndepRqmtItemField<String>("Product");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtItemField<String> PLANT = new PlannedIndepRqmtItemField<String>("Plant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     *
     * @return MRP Area
     */
    @Key
    @SerializedName( "MRPArea" )
    @JsonProperty( "MRPArea" )
    @Nullable
    @ODataField( odataName = "MRPArea" )
    private String mRPArea;
    /**
     * Use with available fluent helpers to apply the <b>MRPArea</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtItemField<String> MRP_AREA = new PlannedIndepRqmtItemField<String>("MRPArea");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PlndIndepRqmtType</b>
     * </p>
     *
     * @return Requirements type
     */
    @Key
    @SerializedName( "PlndIndepRqmtType" )
    @JsonProperty( "PlndIndepRqmtType" )
    @Nullable
    @ODataField( odataName = "PlndIndepRqmtType" )
    private String plndIndepRqmtType;
    /**
     * Use with available fluent helpers to apply the <b>PlndIndepRqmtType</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtItemField<String> PLND_INDEP_RQMT_TYPE =
        new PlannedIndepRqmtItemField<String>("PlndIndepRqmtType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PlndIndepRqmtVersion</b>
     * </p>
     *
     * @return Version Number for Independent Requirements
     */
    @Key
    @SerializedName( "PlndIndepRqmtVersion" )
    @JsonProperty( "PlndIndepRqmtVersion" )
    @Nullable
    @ODataField( odataName = "PlndIndepRqmtVersion" )
    private String plndIndepRqmtVersion;
    /**
     * Use with available fluent helpers to apply the <b>PlndIndepRqmtVersion</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtItemField<String> PLND_INDEP_RQMT_VERSION =
        new PlannedIndepRqmtItemField<String>("PlndIndepRqmtVersion");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RequirementPlan</b>
     * </p>
     *
     * @return Requirements Plan
     */
    @Key
    @SerializedName( "RequirementPlan" )
    @JsonProperty( "RequirementPlan" )
    @Nullable
    @ODataField( odataName = "RequirementPlan" )
    private String requirementPlan;
    /**
     * Use with available fluent helpers to apply the <b>RequirementPlan</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtItemField<String> REQUIREMENT_PLAN =
        new PlannedIndepRqmtItemField<String>("RequirementPlan");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RequirementSegment</b>
     * </p>
     *
     * @return Requirement Segment
     */
    @Key
    @SerializedName( "RequirementSegment" )
    @JsonProperty( "RequirementSegment" )
    @Nullable
    @ODataField( odataName = "RequirementSegment" )
    private String requirementSegment;
    /**
     * Use with available fluent helpers to apply the <b>RequirementSegment</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtItemField<String> REQUIREMENT_SEGMENT =
        new PlannedIndepRqmtItemField<String>("RequirementSegment");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PlndIndepRqmtPeriod</b>
     * </p>
     *
     * @return Period Text
     */
    @Key
    @SerializedName( "PlndIndepRqmtPeriod" )
    @JsonProperty( "PlndIndepRqmtPeriod" )
    @Nullable
    @ODataField( odataName = "PlndIndepRqmtPeriod" )
    private String plndIndepRqmtPeriod;
    /**
     * Use with available fluent helpers to apply the <b>PlndIndepRqmtPeriod</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtItemField<String> PLND_INDEP_RQMT_PERIOD =
        new PlannedIndepRqmtItemField<String>("PlndIndepRqmtPeriod");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PeriodType</b>
     * </p>
     *
     * @return Type of a Period
     */
    @Key
    @SerializedName( "PeriodType" )
    @JsonProperty( "PeriodType" )
    @Nullable
    @ODataField( odataName = "PeriodType" )
    private String periodType;
    /**
     * Use with available fluent helpers to apply the <b>PeriodType</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtItemField<String> PERIOD_TYPE =
        new PlannedIndepRqmtItemField<String>("PeriodType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlndIndepRqmtPeriodStartDate</b>
     * </p>
     *
     * @return Date of a Working Day
     */
    @SerializedName( "PlndIndepRqmtPeriodStartDate" )
    @JsonProperty( "PlndIndepRqmtPeriodStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PlndIndepRqmtPeriodStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime plndIndepRqmtPeriodStartDate;
    /**
     * Use with available fluent helpers to apply the <b>PlndIndepRqmtPeriodStartDate</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtItemField<LocalDateTime> PLND_INDEP_RQMT_PERIOD_START_DATE =
        new PlannedIndepRqmtItemField<LocalDateTime>("PlndIndepRqmtPeriodStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PlndIndepRqmtInternalID</b>
     * </p>
     *
     * @return Independent Requirements Pointer
     */
    @SerializedName( "PlndIndepRqmtInternalID" )
    @JsonProperty( "PlndIndepRqmtInternalID" )
    @Nullable
    @ODataField( odataName = "PlndIndepRqmtInternalID" )
    private String plndIndepRqmtInternalID;
    /**
     * Use with available fluent helpers to apply the <b>PlndIndepRqmtInternalID</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtItemField<String> PLND_INDEP_RQMT_INTERNAL_ID =
        new PlannedIndepRqmtItemField<String>("PlndIndepRqmtInternalID");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>WorkingDayDate</b>
     * </p>
     *
     * @return Date of a Working Day
     */
    @SerializedName( "WorkingDayDate" )
    @JsonProperty( "WorkingDayDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "WorkingDayDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime workingDayDate;
    /**
     * Use with available fluent helpers to apply the <b>WorkingDayDate</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtItemField<LocalDateTime> WORKING_DAY_DATE =
        new PlannedIndepRqmtItemField<LocalDateTime>("WorkingDayDate");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedQuantity</b>
     * </p>
     *
     * @return Planned quantity
     */
    @SerializedName( "PlannedQuantity" )
    @JsonProperty( "PlannedQuantity" )
    @Nullable
    @ODataField( odataName = "PlannedQuantity" )
    private BigDecimal plannedQuantity;
    /**
     * Use with available fluent helpers to apply the <b>PlannedQuantity</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtItemField<BigDecimal> PLANNED_QUANTITY =
        new PlannedIndepRqmtItemField<BigDecimal>("PlannedQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WithdrawalQuantity</b>
     * </p>
     *
     * @return Withdrawal Quantity
     */
    @SerializedName( "WithdrawalQuantity" )
    @JsonProperty( "WithdrawalQuantity" )
    @Nullable
    @ODataField( odataName = "WithdrawalQuantity" )
    private BigDecimal withdrawalQuantity;
    /**
     * Use with available fluent helpers to apply the <b>WithdrawalQuantity</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtItemField<BigDecimal> WITHDRAWAL_QUANTITY =
        new PlannedIndepRqmtItemField<BigDecimal>("WithdrawalQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "UnitOfMeasure" )
    @JsonProperty( "UnitOfMeasure" )
    @Nullable
    @ODataField( odataName = "UnitOfMeasure" )
    private String unitOfMeasure;
    /**
     * Use with available fluent helpers to apply the <b>UnitOfMeasure</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtItemField<String> UNIT_OF_MEASURE =
        new PlannedIndepRqmtItemField<String>("UnitOfMeasure");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Name of Person Who Changed Object
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtItemField<String> LAST_CHANGED_BY_USER =
        new PlannedIndepRqmtItemField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Date of Last Change
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtItemField<LocalDateTime> LAST_CHANGE_DATE =
        new PlannedIndepRqmtItemField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>PlndIndepRqmtLastChgdDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "PlndIndepRqmtLastChgdDateTime" )
    @JsonProperty( "PlndIndepRqmtLastChgdDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "PlndIndepRqmtLastChgdDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime plndIndepRqmtLastChgdDateTime;
    /**
     * Use with available fluent helpers to apply the <b>PlndIndepRqmtLastChgdDateTime</b> field to query operations.
     *
     */
    public final static PlannedIndepRqmtItemField<ZonedDateTime> PLND_INDEP_RQMT_LAST_CHGD_DATE_TIME =
        new PlannedIndepRqmtItemField<ZonedDateTime>("PlndIndepRqmtLastChgdDateTime");
    /**
     * Navigation property <b>to_PlndIndepRqmt</b> for <b>PlannedIndepRqmtItem</b> to single <b>PlannedIndepRqmt</b>.
     *
     */
    @SerializedName( "to_PlndIndepRqmt" )
    @JsonProperty( "to_PlndIndepRqmt" )
    @ODataField( odataName = "to_PlndIndepRqmt" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PlannedIndepRqmt toPlndIndepRqmt;
    /**
     * Use with available fluent helpers to apply the <b>to_PlndIndepRqmt</b> navigation property to query operations.
     *
     */
    public final static PlannedIndepRqmtItemOneToOneLink<PlannedIndepRqmt> TO_PLND_INDEP_RQMT =
        new PlannedIndepRqmtItemOneToOneLink<PlannedIndepRqmt>("to_PlndIndepRqmt");

    @Nonnull
    @Override
    public Class<PlannedIndepRqmtItem> getType()
    {
        return PlannedIndepRqmtItem.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Material Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     *
     * @param mRPArea
     *            MRP Area
     */
    public void setMRPArea( @Nullable final String mRPArea )
    {
        rememberChangedField("MRPArea", this.mRPArea);
        this.mRPArea = mRPArea;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PlndIndepRqmtType</b>
     * </p>
     *
     * @param plndIndepRqmtType
     *            Requirements type
     */
    public void setPlndIndepRqmtType( @Nullable final String plndIndepRqmtType )
    {
        rememberChangedField("PlndIndepRqmtType", this.plndIndepRqmtType);
        this.plndIndepRqmtType = plndIndepRqmtType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PlndIndepRqmtVersion</b>
     * </p>
     *
     * @param plndIndepRqmtVersion
     *            Version Number for Independent Requirements
     */
    public void setPlndIndepRqmtVersion( @Nullable final String plndIndepRqmtVersion )
    {
        rememberChangedField("PlndIndepRqmtVersion", this.plndIndepRqmtVersion);
        this.plndIndepRqmtVersion = plndIndepRqmtVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RequirementPlan</b>
     * </p>
     *
     * @param requirementPlan
     *            Requirements Plan
     */
    public void setRequirementPlan( @Nullable final String requirementPlan )
    {
        rememberChangedField("RequirementPlan", this.requirementPlan);
        this.requirementPlan = requirementPlan;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RequirementSegment</b>
     * </p>
     *
     * @param requirementSegment
     *            Requirement Segment
     */
    public void setRequirementSegment( @Nullable final String requirementSegment )
    {
        rememberChangedField("RequirementSegment", this.requirementSegment);
        this.requirementSegment = requirementSegment;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PlndIndepRqmtPeriod</b>
     * </p>
     *
     * @param plndIndepRqmtPeriod
     *            Period Text
     */
    public void setPlndIndepRqmtPeriod( @Nullable final String plndIndepRqmtPeriod )
    {
        rememberChangedField("PlndIndepRqmtPeriod", this.plndIndepRqmtPeriod);
        this.plndIndepRqmtPeriod = plndIndepRqmtPeriod;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PeriodType</b>
     * </p>
     *
     * @param periodType
     *            Type of a Period
     */
    public void setPeriodType( @Nullable final String periodType )
    {
        rememberChangedField("PeriodType", this.periodType);
        this.periodType = periodType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlndIndepRqmtPeriodStartDate</b>
     * </p>
     *
     * @param plndIndepRqmtPeriodStartDate
     *            Date of a Working Day
     */
    public void setPlndIndepRqmtPeriodStartDate( @Nullable final LocalDateTime plndIndepRqmtPeriodStartDate )
    {
        rememberChangedField("PlndIndepRqmtPeriodStartDate", this.plndIndepRqmtPeriodStartDate);
        this.plndIndepRqmtPeriodStartDate = plndIndepRqmtPeriodStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PlndIndepRqmtInternalID</b>
     * </p>
     *
     * @param plndIndepRqmtInternalID
     *            Independent Requirements Pointer
     */
    public void setPlndIndepRqmtInternalID( @Nullable final String plndIndepRqmtInternalID )
    {
        rememberChangedField("PlndIndepRqmtInternalID", this.plndIndepRqmtInternalID);
        this.plndIndepRqmtInternalID = plndIndepRqmtInternalID;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>WorkingDayDate</b>
     * </p>
     *
     * @param workingDayDate
     *            Date of a Working Day
     */
    public void setWorkingDayDate( @Nullable final LocalDateTime workingDayDate )
    {
        rememberChangedField("WorkingDayDate", this.workingDayDate);
        this.workingDayDate = workingDayDate;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedQuantity</b>
     * </p>
     *
     * @param plannedQuantity
     *            Planned quantity
     */
    public void setPlannedQuantity( @Nullable final BigDecimal plannedQuantity )
    {
        rememberChangedField("PlannedQuantity", this.plannedQuantity);
        this.plannedQuantity = plannedQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WithdrawalQuantity</b>
     * </p>
     *
     * @param withdrawalQuantity
     *            Withdrawal Quantity
     */
    public void setWithdrawalQuantity( @Nullable final BigDecimal withdrawalQuantity )
    {
        rememberChangedField("WithdrawalQuantity", this.withdrawalQuantity);
        this.withdrawalQuantity = withdrawalQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure</b>
     * </p>
     *
     * @param unitOfMeasure
     *            Base Unit of Measure
     */
    public void setUnitOfMeasure( @Nullable final String unitOfMeasure )
    {
        rememberChangedField("UnitOfMeasure", this.unitOfMeasure);
        this.unitOfMeasure = unitOfMeasure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Name of Person Who Changed Object
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Date of Last Change
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>PlndIndepRqmtLastChgdDateTime</b>
     * </p>
     *
     * @param plndIndepRqmtLastChgdDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setPlndIndepRqmtLastChgdDateTime( @Nullable final ZonedDateTime plndIndepRqmtLastChgdDateTime )
    {
        rememberChangedField("PlndIndepRqmtLastChgdDateTime", this.plndIndepRqmtLastChgdDateTime);
        this.plndIndepRqmtLastChgdDateTime = plndIndepRqmtLastChgdDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PlannedIndepRqmtItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Product", getProduct());
        result.put("Plant", getPlant());
        result.put("MRPArea", getMRPArea());
        result.put("PlndIndepRqmtType", getPlndIndepRqmtType());
        result.put("PlndIndepRqmtVersion", getPlndIndepRqmtVersion());
        result.put("RequirementPlan", getRequirementPlan());
        result.put("RequirementSegment", getRequirementSegment());
        result.put("PlndIndepRqmtPeriod", getPlndIndepRqmtPeriod());
        result.put("PeriodType", getPeriodType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Update_mc", getUpdate_mc());
        values.put("Product", getProduct());
        values.put("Plant", getPlant());
        values.put("MRPArea", getMRPArea());
        values.put("PlndIndepRqmtType", getPlndIndepRqmtType());
        values.put("PlndIndepRqmtVersion", getPlndIndepRqmtVersion());
        values.put("RequirementPlan", getRequirementPlan());
        values.put("RequirementSegment", getRequirementSegment());
        values.put("PlndIndepRqmtPeriod", getPlndIndepRqmtPeriod());
        values.put("PeriodType", getPeriodType());
        values.put("PlndIndepRqmtPeriodStartDate", getPlndIndepRqmtPeriodStartDate());
        values.put("PlndIndepRqmtInternalID", getPlndIndepRqmtInternalID());
        values.put("WorkingDayDate", getWorkingDayDate());
        values.put("PlannedQuantity", getPlannedQuantity());
        values.put("WithdrawalQuantity", getWithdrawalQuantity());
        values.put("UnitOfMeasure", getUnitOfMeasure());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("PlndIndepRqmtLastChgdDateTime", getPlndIndepRqmtLastChgdDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("MRPArea") ) {
                final Object value = values.remove("MRPArea");
                if( (value == null) || (!value.equals(getMRPArea())) ) {
                    setMRPArea(((String) value));
                }
            }
            if( values.containsKey("PlndIndepRqmtType") ) {
                final Object value = values.remove("PlndIndepRqmtType");
                if( (value == null) || (!value.equals(getPlndIndepRqmtType())) ) {
                    setPlndIndepRqmtType(((String) value));
                }
            }
            if( values.containsKey("PlndIndepRqmtVersion") ) {
                final Object value = values.remove("PlndIndepRqmtVersion");
                if( (value == null) || (!value.equals(getPlndIndepRqmtVersion())) ) {
                    setPlndIndepRqmtVersion(((String) value));
                }
            }
            if( values.containsKey("RequirementPlan") ) {
                final Object value = values.remove("RequirementPlan");
                if( (value == null) || (!value.equals(getRequirementPlan())) ) {
                    setRequirementPlan(((String) value));
                }
            }
            if( values.containsKey("RequirementSegment") ) {
                final Object value = values.remove("RequirementSegment");
                if( (value == null) || (!value.equals(getRequirementSegment())) ) {
                    setRequirementSegment(((String) value));
                }
            }
            if( values.containsKey("PlndIndepRqmtPeriod") ) {
                final Object value = values.remove("PlndIndepRqmtPeriod");
                if( (value == null) || (!value.equals(getPlndIndepRqmtPeriod())) ) {
                    setPlndIndepRqmtPeriod(((String) value));
                }
            }
            if( values.containsKey("PeriodType") ) {
                final Object value = values.remove("PeriodType");
                if( (value == null) || (!value.equals(getPeriodType())) ) {
                    setPeriodType(((String) value));
                }
            }
            if( values.containsKey("PlndIndepRqmtPeriodStartDate") ) {
                final Object value = values.remove("PlndIndepRqmtPeriodStartDate");
                if( (value == null) || (!value.equals(getPlndIndepRqmtPeriodStartDate())) ) {
                    setPlndIndepRqmtPeriodStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PlndIndepRqmtInternalID") ) {
                final Object value = values.remove("PlndIndepRqmtInternalID");
                if( (value == null) || (!value.equals(getPlndIndepRqmtInternalID())) ) {
                    setPlndIndepRqmtInternalID(((String) value));
                }
            }
            if( values.containsKey("WorkingDayDate") ) {
                final Object value = values.remove("WorkingDayDate");
                if( (value == null) || (!value.equals(getWorkingDayDate())) ) {
                    setWorkingDayDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PlannedQuantity") ) {
                final Object value = values.remove("PlannedQuantity");
                if( (value == null) || (!value.equals(getPlannedQuantity())) ) {
                    setPlannedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("WithdrawalQuantity") ) {
                final Object value = values.remove("WithdrawalQuantity");
                if( (value == null) || (!value.equals(getWithdrawalQuantity())) ) {
                    setWithdrawalQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("UnitOfMeasure") ) {
                final Object value = values.remove("UnitOfMeasure");
                if( (value == null) || (!value.equals(getUnitOfMeasure())) ) {
                    setUnitOfMeasure(((String) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PlndIndepRqmtLastChgdDateTime") ) {
                final Object value = values.remove("PlndIndepRqmtLastChgdDateTime");
                if( (value == null) || (!value.equals(getPlndIndepRqmtLastChgdDateTime())) ) {
                    setPlndIndepRqmtLastChgdDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PlndIndepRqmt") ) {
                final Object value = (values).remove("to_PlndIndepRqmt");
                if( value instanceof Map ) {
                    if( toPlndIndepRqmt == null ) {
                        toPlndIndepRqmt = new PlannedIndepRqmt();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPlndIndepRqmt.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PlannedIndepRqmtItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PlannedIndepRqmtItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PlannedIndepRqmtItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PlannedIndepRqmtItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ExtendedPlannedIndependentRequirementService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPlndIndepRqmt != null ) {
            (values).put("to_PlndIndepRqmt", toPlndIndepRqmt);
        }
        return values;
    }

    /**
     * Fetches the <b>PlannedIndepRqmt</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_PlndIndepRqmt</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PlannedIndepRqmt</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PlannedIndepRqmt fetchPlndIndepRqmt()
    {
        return fetchFieldAsSingle("to_PlndIndepRqmt", PlannedIndepRqmt.class);
    }

    /**
     * Retrieval of associated <b>PlannedIndepRqmt</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_PlndIndepRqmt</b>.
     * <p>
     * If the navigation property <b>to_PlndIndepRqmt</b> of a queried <b>PlannedIndepRqmtItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PlannedIndepRqmt</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PlannedIndepRqmt getPlndIndepRqmtOrFetch()
    {
        if( toPlndIndepRqmt == null ) {
            toPlndIndepRqmt = fetchPlndIndepRqmt();
        }
        return toPlndIndepRqmt;
    }

    /**
     * Retrieval of associated <b>PlannedIndepRqmt</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_PlndIndepRqmt</b>.
     * <p>
     * If the navigation property for an entity <b>PlannedIndepRqmtItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PlndIndepRqmt</b> is already loaded, the result will
     *         contain the <b>PlannedIndepRqmt</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PlannedIndepRqmt> getPlndIndepRqmtIfPresent()
    {
        return Option.of(toPlndIndepRqmt);
    }

    /**
     * Overwrites the associated <b>PlannedIndepRqmt</b> entity for the loaded navigation property
     * <b>to_PlndIndepRqmt</b>.
     *
     * @param value
     *            New <b>PlannedIndepRqmt</b> entity.
     */
    public void setPlndIndepRqmt( final PlannedIndepRqmt value )
    {
        toPlndIndepRqmt = value;
    }

    /**
     * Helper class to allow for fluent creation of PlannedIndepRqmtItem instances.
     *
     */
    public final static class PlannedIndepRqmtItemBuilder
    {

        private PlannedIndepRqmt toPlndIndepRqmt;

        private PlannedIndepRqmtItem.PlannedIndepRqmtItemBuilder toPlndIndepRqmt( final PlannedIndepRqmt value )
        {
            toPlndIndepRqmt = value;
            return this;
        }

        /**
         * Navigation property <b>to_PlndIndepRqmt</b> for <b>PlannedIndepRqmtItem</b> to single
         * <b>PlannedIndepRqmt</b>.
         *
         * @param value
         *            The PlannedIndepRqmt to build this PlannedIndepRqmtItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PlannedIndepRqmtItem.PlannedIndepRqmtItemBuilder plndIndepRqmt( final PlannedIndepRqmt value )
        {
            return toPlndIndepRqmt(value);
        }

    }

}
