/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link ExtendedPlannedIndependentRequirementServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ExtendedPlannedIndependentRequirementService
 * ExtendedPlannedIndependentRequirementService}, allowing you to create multiple changesets and finally execute the
 * batch request.
 *
 */
public class DefaultExtendedPlannedIndependentRequirementServiceBatch
    extends
    BatchFluentHelperBasic<ExtendedPlannedIndependentRequirementServiceBatch, ExtendedPlannedIndependentRequirementServiceBatchChangeSet>
    implements
    ExtendedPlannedIndependentRequirementServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ExtendedPlannedIndependentRequirementService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultExtendedPlannedIndependentRequirementServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultExtendedPlannedIndependentRequirementServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ExtendedPlannedIndependentRequirementService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.ExtendedPlannedIndependentRequirementService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultExtendedPlannedIndependentRequirementServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultExtendedPlannedIndependentRequirementServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ExtendedPlannedIndependentRequirementService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultExtendedPlannedIndependentRequirementServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ExtendedPlannedIndependentRequirementServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultExtendedPlannedIndependentRequirementServiceBatchChangeSet(this, service);
    }

}
