/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem;

/**
 * Implementation of the {@link ExtendedPlannedIndependentRequirementServiceBatchChangeSet} interface, enabling you to
 * combine multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ExtendedPlannedIndependentRequirementService
 * ExtendedPlannedIndependentRequirementService}.
 *
 */
public class DefaultExtendedPlannedIndependentRequirementServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ExtendedPlannedIndependentRequirementServiceBatch, ExtendedPlannedIndependentRequirementServiceBatchChangeSet>
    implements
    ExtendedPlannedIndependentRequirementServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ExtendedPlannedIndependentRequirementService service;

    @SuppressWarnings( "deprecation" )
    DefaultExtendedPlannedIndependentRequirementServiceBatchChangeSet(
        @Nonnull final DefaultExtendedPlannedIndependentRequirementServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ExtendedPlannedIndependentRequirementService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultExtendedPlannedIndependentRequirementServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ExtendedPlannedIndependentRequirementServiceBatchChangeSet createPlannedIndepRqmt(
        @Nonnull final PlannedIndepRqmt plannedIndepRqmt )
    {
        return addRequestCreate(service::createPlannedIndepRqmt, plannedIndepRqmt);
    }

    @Nonnull
    @Override
    public ExtendedPlannedIndependentRequirementServiceBatchChangeSet updatePlannedIndepRqmt(
        @Nonnull final PlannedIndepRqmt plannedIndepRqmt )
    {
        return addRequestUpdate(service::updatePlannedIndepRqmt, plannedIndepRqmt);
    }

    @Nonnull
    @Override
    public ExtendedPlannedIndependentRequirementServiceBatchChangeSet createPlannedIndepRqmtItem(
        @Nonnull final PlannedIndepRqmtItem plannedIndepRqmtItem )
    {
        return addRequestCreate(service::createPlannedIndepRqmtItem, plannedIndepRqmtItem);
    }

    @Nonnull
    @Override
    public ExtendedPlannedIndependentRequirementServiceBatchChangeSet updatePlannedIndepRqmtItem(
        @Nonnull final PlannedIndepRqmtItem plannedIndepRqmtItem )
    {
        return addRequestUpdate(service::updatePlannedIndepRqmtItem, plannedIndepRqmtItem);
    }

}
