/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ExtendedPlannedIndependentRequirementService
 * ExtendedPlannedIndependentRequirementService}.
 *
 */
public interface ExtendedPlannedIndependentRequirementServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<ExtendedPlannedIndependentRequirementServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<ExtendedPlannedIndependentRequirementServiceBatch>
{

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt
     * PlannedIndepRqmt} entity and save it to the S/4HANA system.
     *
     * @param plannedIndepRqmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt
     *            PlannedIndepRqmt} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ExtendedPlannedIndependentRequirementServiceBatchChangeSet
        createPlannedIndepRqmt( @Nonnull final PlannedIndepRqmt plannedIndepRqmt );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt
     * PlannedIndepRqmt} entity and save it to the S/4HANA system.
     *
     * @param plannedIndepRqmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt
     *            PlannedIndepRqmt} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ExtendedPlannedIndependentRequirementServiceBatchChangeSet
        updatePlannedIndepRqmt( @Nonnull final PlannedIndepRqmt plannedIndepRqmt );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem
     * PlannedIndepRqmtItem} entity and save it to the S/4HANA system.
     *
     * @param plannedIndepRqmtItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem
     *            PlannedIndepRqmtItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ExtendedPlannedIndependentRequirementServiceBatchChangeSet
        createPlannedIndepRqmtItem( @Nonnull final PlannedIndepRqmtItem plannedIndepRqmtItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem
     * PlannedIndepRqmtItem} entity and save it to the S/4HANA system.
     *
     * @param plannedIndepRqmtItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem
     *            PlannedIndepRqmtItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ExtendedPlannedIndependentRequirementServiceBatchChangeSet
        updatePlannedIndepRqmtItem( @Nonnull final PlannedIndepRqmtItem plannedIndepRqmtItem );

}
