/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem
 * PlannedIndepRqmtItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.field.PlannedIndepRqmtItemField
 * PlannedIndepRqmtItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.link.PlannedIndepRqmtItemLink
 * PlannedIndepRqmtItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem#MRP_AREA
 * MRP_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem#PLND_INDEP_RQMT_TYPE
 * PLND_INDEP_RQMT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem#PLND_INDEP_RQMT_VERSION
 * PLND_INDEP_RQMT_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem#REQUIREMENT_PLAN
 * REQUIREMENT_PLAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem#REQUIREMENT_SEGMENT
 * REQUIREMENT_SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem#PLND_INDEP_RQMT_PERIOD
 * PLND_INDEP_RQMT_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem#PERIOD_TYPE
 * PERIOD_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem#PLND_INDEP_RQMT_PERIOD_START_DATE
 * PLND_INDEP_RQMT_PERIOD_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem#PLND_INDEP_RQMT_INTERNAL_ID
 * PLND_INDEP_RQMT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem#WORKING_DAY_DATE
 * WORKING_DAY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem#PLANNED_QUANTITY
 * PLANNED_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem#WITHDRAWAL_QUANTITY
 * WITHDRAWAL_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem#UNIT_OF_MEASURE
 * UNIT_OF_MEASURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem#PLND_INDEP_RQMT_LAST_CHGD_DATE_TIME
 * PLND_INDEP_RQMT_LAST_CHGD_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmtItem#TO_PLND_INDEP_RQMT
 * TO_PLND_INDEP_RQMT}</li>
 * </ul>
 *
 */
public interface PlannedIndepRqmtItemSelectable extends EntitySelectable<PlannedIndepRqmtItem>
{

}
