/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt
 * PlannedIndepRqmt}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.field.PlannedIndepRqmtField
 * PlannedIndepRqmtField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.link.PlannedIndepRqmtLink
 * PlannedIndepRqmtLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt#PLND_INDEP_RQMT_ITEM_OC
 * PLND_INDEP_RQMT_ITEM_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt#MRP_AREA
 * MRP_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt#PLND_INDEP_RQMT_TYPE
 * PLND_INDEP_RQMT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt#PLND_INDEP_RQMT_VERSION
 * PLND_INDEP_RQMT_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt#REQUIREMENT_PLAN
 * REQUIREMENT_PLAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt#REQUIREMENT_SEGMENT
 * REQUIREMENT_SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt#REQUIREMENT_PLAN_IS_EXTERNAL
 * REQUIREMENT_PLAN_IS_EXTERNAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt#PLND_INDEP_RQMT_INTERNAL_ID
 * PLND_INDEP_RQMT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt#PLND_INDEP_RQMT_IS_ACTIVE
 * PLND_INDEP_RQMT_IS_ACTIVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt#WBS_ELEMENT
 * WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt#PLND_INDEP_RQMT_ACCT_ASSGMT_CAT
 * PLND_INDEP_RQMT_ACCT_ASSGMT_CAT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt#PLND_INDEP_RQMT_LAST_CHGD_DATE_TIME
 * PLND_INDEP_RQMT_LAST_CHGD_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.extendedplannedindependentrequirement.PlannedIndepRqmt#TO_PLND_INDEP_RQMT_ITEM
 * TO_PLND_INDEP_RQMT_ITEM}</li>
 * </ul>
 *
 */
public interface PlannedIndepRqmtSelectable extends EntitySelectable<PlannedIndepRqmt>
{

}
