/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.field.JobScheduleStatusField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.selectable.JobScheduleStatusSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>JobScheduleStatus</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class JobScheduleStatus extends VdmEntity<JobScheduleStatus>
{

    /**
     * Selector for all available fields of JobScheduleStatus.
     *
     */
    public final static JobScheduleStatusSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>JobName</b>
     * </p>
     *
     * @return The jobName contained in this entity.
     */
    @Key
    @SerializedName( "JobName" )
    @JsonProperty( "JobName" )
    @Nullable
    @ODataField( odataName = "JobName" )
    private String jobName;
    /**
     * Use with available fluent helpers to apply the <b>JobName</b> field to query operations.
     *
     */
    public final static JobScheduleStatusField<String> JOB_NAME = new JobScheduleStatusField<String>("JobName");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>JobRunCount</b>
     * </p>
     *
     * @return The jobRunCount contained in this entity.
     */
    @Key
    @SerializedName( "JobRunCount" )
    @JsonProperty( "JobRunCount" )
    @Nullable
    @ODataField( odataName = "JobRunCount" )
    private String jobRunCount;
    /**
     * Use with available fluent helpers to apply the <b>JobRunCount</b> field to query operations.
     *
     */
    public final static JobScheduleStatusField<String> JOB_RUN_COUNT =
        new JobScheduleStatusField<String>("JobRunCount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>JobStatus</b>
     * </p>
     *
     * @return The jobStatus contained in this entity.
     */
    @SerializedName( "JobStatus" )
    @JsonProperty( "JobStatus" )
    @Nullable
    @ODataField( odataName = "JobStatus" )
    private String jobStatus;
    /**
     * Use with available fluent helpers to apply the <b>JobStatus</b> field to query operations.
     *
     */
    public final static JobScheduleStatusField<String> JOB_STATUS = new JobScheduleStatusField<String>("JobStatus");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReturnCode</b>
     * </p>
     *
     * @return Signed INT2 / Edm.int16
     */
    @SerializedName( "ReturnCode" )
    @JsonProperty( "ReturnCode" )
    @Nullable
    @ODataField( odataName = "ReturnCode" )
    private Short returnCode;
    /**
     * Use with available fluent helpers to apply the <b>ReturnCode</b> field to query operations.
     *
     */
    public final static JobScheduleStatusField<Short> RETURN_CODE = new JobScheduleStatusField<Short>("ReturnCode");

    @Nonnull
    @Override
    public Class<JobScheduleStatus> getType()
    {
        return JobScheduleStatus.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>JobName</b>
     * </p>
     *
     * @param jobName
     *            The jobName to set.
     */
    public void setJobName( @Nullable final String jobName )
    {
        rememberChangedField("JobName", this.jobName);
        this.jobName = jobName;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>JobRunCount</b>
     * </p>
     *
     * @param jobRunCount
     *            The jobRunCount to set.
     */
    public void setJobRunCount( @Nullable final String jobRunCount )
    {
        rememberChangedField("JobRunCount", this.jobRunCount);
        this.jobRunCount = jobRunCount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>JobStatus</b>
     * </p>
     *
     * @param jobStatus
     *            The jobStatus to set.
     */
    public void setJobStatus( @Nullable final String jobStatus )
    {
        rememberChangedField("JobStatus", this.jobStatus);
        this.jobStatus = jobStatus;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReturnCode</b>
     * </p>
     *
     * @param returnCode
     *            Signed INT2 / Edm.int16
     */
    public void setReturnCode( @Nullable final Short returnCode )
    {
        rememberChangedField("ReturnCode", this.returnCode);
        this.returnCode = returnCode;
    }

    @Override
    protected String getEntityCollection()
    {
        return "JobScheduleStatusCollection";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("JobName", getJobName());
        result.put("JobRunCount", getJobRunCount());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("JobName", getJobName());
        values.put("JobRunCount", getJobRunCount());
        values.put("JobStatus", getJobStatus());
        values.put("ReturnCode", getReturnCode());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("JobName") ) {
                final Object value = values.remove("JobName");
                if( (value == null) || (!value.equals(getJobName())) ) {
                    setJobName(((String) value));
                }
            }
            if( values.containsKey("JobRunCount") ) {
                final Object value = values.remove("JobRunCount");
                if( (value == null) || (!value.equals(getJobRunCount())) ) {
                    setJobRunCount(((String) value));
                }
            }
            if( values.containsKey("JobStatus") ) {
                final Object value = values.remove("JobStatus");
                if( (value == null) || (!value.equals(getJobStatus())) ) {
                    setJobStatus(((String) value));
                }
            }
            if( values.containsKey("ReturnCode") ) {
                final Object value = values.remove("ReturnCode");
                if( (value == null) || (!value.equals(getReturnCode())) ) {
                    setReturnCode(((Short) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> JobScheduleStatusField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new JobScheduleStatusField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> JobScheduleStatusField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new JobScheduleStatusField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ExternalJobSchedulerIntegrationService.DEFAULT_SERVICE_PATH);
    }

}
