/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.field.JobTemplateField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.selectable.JobTemplateSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>JobTemplate</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class JobTemplate extends VdmEntity<JobTemplate>
{

    /**
     * Selector for all available fields of JobTemplate.
     *
     */
    public final static JobTemplateSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>JobTemplateName</b>
     * </p>
     *
     * @return The jobTemplateName contained in this entity.
     */
    @Key
    @SerializedName( "JobTemplateName" )
    @JsonProperty( "JobTemplateName" )
    @Nullable
    @ODataField( odataName = "JobTemplateName" )
    private String jobTemplateName;
    /**
     * Use with available fluent helpers to apply the <b>JobTemplateName</b> field to query operations.
     *
     */
    public final static JobTemplateField<String> JOB_TEMPLATE_NAME = new JobTemplateField<String>("JobTemplateName");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>JobTemplateVersion</b>
     * </p>
     *
     * @return The jobTemplateVersion contained in this entity.
     */
    @Key
    @SerializedName( "JobTemplateVersion" )
    @JsonProperty( "JobTemplateVersion" )
    @Nullable
    @ODataField( odataName = "JobTemplateVersion" )
    private String jobTemplateVersion;
    /**
     * Use with available fluent helpers to apply the <b>JobTemplateVersion</b> field to query operations.
     *
     */
    public final static JobTemplateField<String> JOB_TEMPLATE_VERSION =
        new JobTemplateField<String>("JobTemplateVersion");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>JobTemplateStepCount</b>
     * </p>
     *
     * @return The jobTemplateStepCount contained in this entity.
     */
    @SerializedName( "JobTemplateStepCount" )
    @JsonProperty( "JobTemplateStepCount" )
    @Nullable
    @ODataField( odataName = "JobTemplateStepCount" )
    private Integer jobTemplateStepCount;
    /**
     * Use with available fluent helpers to apply the <b>JobTemplateStepCount</b> field to query operations.
     *
     */
    public final static JobTemplateField<Integer> JOB_TEMPLATE_STEP_COUNT =
        new JobTemplateField<Integer>("JobTemplateStepCount");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>JobPeriodicGranularity</b>
     * </p>
     *
     * @return The jobPeriodicGranularity contained in this entity.
     */
    @SerializedName( "JobPeriodicGranularity" )
    @JsonProperty( "JobPeriodicGranularity" )
    @Nullable
    @ODataField( odataName = "JobPeriodicGranularity" )
    private String jobPeriodicGranularity;
    /**
     * Use with available fluent helpers to apply the <b>JobPeriodicGranularity</b> field to query operations.
     *
     */
    public final static JobTemplateField<String> JOB_PERIODIC_GRANULARITY =
        new JobTemplateField<String>("JobPeriodicGranularity");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>JobReportName</b>
     * </p>
     *
     * @return The jobReportName contained in this entity.
     */
    @SerializedName( "JobReportName" )
    @JsonProperty( "JobReportName" )
    @Nullable
    @ODataField( odataName = "JobReportName" )
    private String jobReportName;
    /**
     * Use with available fluent helpers to apply the <b>JobReportName</b> field to query operations.
     *
     */
    public final static JobTemplateField<String> JOB_REPORT_NAME = new JobTemplateField<String>("JobReportName");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>JobUserName</b>
     * </p>
     *
     * @return The jobUserName contained in this entity.
     */
    @SerializedName( "JobUserName" )
    @JsonProperty( "JobUserName" )
    @Nullable
    @ODataField( odataName = "JobUserName" )
    private String jobUserName;
    /**
     * Use with available fluent helpers to apply the <b>JobUserName</b> field to query operations.
     *
     */
    public final static JobTemplateField<String> JOB_USER_NAME = new JobTemplateField<String>("JobUserName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JobPeriodicValue</b>
     * </p>
     *
     * @return The jobPeriodicValue contained in this entity.
     */
    @SerializedName( "JobPeriodicValue" )
    @JsonProperty( "JobPeriodicValue" )
    @Nullable
    @ODataField( odataName = "JobPeriodicValue" )
    private String jobPeriodicValue;
    /**
     * Use with available fluent helpers to apply the <b>JobPeriodicValue</b> field to query operations.
     *
     */
    public final static JobTemplateField<String> JOB_PERIODIC_VALUE = new JobTemplateField<String>("JobPeriodicValue");
    /**
     * Constraints: Not nullable, Maximum length: 120
     * <p>
     * Original property name from the Odata EDM: <b>JobTemplateText</b>
     * </p>
     *
     * @return The jobTemplateText contained in this entity.
     */
    @SerializedName( "JobTemplateText" )
    @JsonProperty( "JobTemplateText" )
    @Nullable
    @ODataField( odataName = "JobTemplateText" )
    private String jobTemplateText;
    /**
     * Use with available fluent helpers to apply the <b>JobTemplateText</b> field to query operations.
     *
     */
    public final static JobTemplateField<String> JOB_TEMPLATE_TEXT = new JobTemplateField<String>("JobTemplateText");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     * <p>
     * In order to convert local time into a UTC time stamp, which makes it easier to compare times, the local time must
     * be converted according to your time zone. The ABAP command convert is available for this purpose. Even if the
     * time zone that the conversion is based on can be redetermined from Customizing or master data, we still recommend
     * that you save the time zone. The internal structure of the high-resolution UTC time stamp is logically organized
     * in date and time sections in a packed decimal format (YYYYMMDDhhmmssmmmuuun), which depicts the year, month, day,
     * hour,second, millisecond, microsecond and the first decimal of the nanoseconds. Please note that the hardware
     * that is normally used does not fully support a resolution of 100 nanoseconds, which is available in the
     * structure. See also GET TIME STAMP A UTC time stamp in short form is also available.
     * </p>
     *
     * @return The UTC timestamp displays date and time according to UTC (Universal Coordinated Time).
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static JobTemplateField<LocalDateTime> CREATION_DATE_TIME =
        new JobTemplateField<LocalDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreationUserName</b>
     * </p>
     *
     * @return The creationUserName contained in this entity.
     */
    @SerializedName( "CreationUserName" )
    @JsonProperty( "CreationUserName" )
    @Nullable
    @ODataField( odataName = "CreationUserName" )
    private String creationUserName;
    /**
     * Use with available fluent helpers to apply the <b>CreationUserName</b> field to query operations.
     *
     */
    public final static JobTemplateField<String> CREATION_USER_NAME = new JobTemplateField<String>("CreationUserName");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     * <p>
     * In order to convert local time into a UTC time stamp, which makes it easier to compare times, the local time must
     * be converted according to your time zone. The ABAP command convert is available for this purpose. Even if the
     * time zone that the conversion is based on can be redetermined from Customizing or master data, we still recommend
     * that you save the time zone. The internal structure of the high-resolution UTC time stamp is logically organized
     * in date and time sections in a packed decimal format (YYYYMMDDhhmmssmmmuuun), which depicts the year, month, day,
     * hour,second, millisecond, microsecond and the first decimal of the nanoseconds. Please note that the hardware
     * that is normally used does not fully support a resolution of 100 nanoseconds, which is available in the
     * structure. See also GET TIME STAMP A UTC time stamp in short form is also available.
     * </p>
     *
     * @return The UTC timestamp displays date and time according to UTC (Universal Coordinated Time).
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static JobTemplateField<LocalDateTime> LAST_CHANGE_DATE_TIME =
        new JobTemplateField<LocalDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeUserName</b>
     * </p>
     *
     * @return The lastChangeUserName contained in this entity.
     */
    @SerializedName( "LastChangeUserName" )
    @JsonProperty( "LastChangeUserName" )
    @Nullable
    @ODataField( odataName = "LastChangeUserName" )
    private String lastChangeUserName;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeUserName</b> field to query operations.
     *
     */
    public final static JobTemplateField<String> LAST_CHANGE_USER_NAME =
        new JobTemplateField<String>("LastChangeUserName");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SupportsTestModeInd</b>
     * </p>
     *
     * @return General Flag
     */
    @SerializedName( "SupportsTestModeInd" )
    @JsonProperty( "SupportsTestModeInd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SupportsTestModeInd" )
    private Boolean supportsTestModeInd;
    /**
     * Use with available fluent helpers to apply the <b>SupportsTestModeInd</b> field to query operations.
     *
     */
    public final static JobTemplateField<Boolean> SUPPORTS_TEST_MODE_IND =
        new JobTemplateField<Boolean>("SupportsTestModeInd");

    @Nonnull
    @Override
    public Class<JobTemplate> getType()
    {
        return JobTemplate.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>JobTemplateName</b>
     * </p>
     *
     * @param jobTemplateName
     *            The jobTemplateName to set.
     */
    public void setJobTemplateName( @Nullable final String jobTemplateName )
    {
        rememberChangedField("JobTemplateName", this.jobTemplateName);
        this.jobTemplateName = jobTemplateName;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>JobTemplateVersion</b>
     * </p>
     *
     * @param jobTemplateVersion
     *            The jobTemplateVersion to set.
     */
    public void setJobTemplateVersion( @Nullable final String jobTemplateVersion )
    {
        rememberChangedField("JobTemplateVersion", this.jobTemplateVersion);
        this.jobTemplateVersion = jobTemplateVersion;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>JobTemplateStepCount</b>
     * </p>
     *
     * @param jobTemplateStepCount
     *            The jobTemplateStepCount to set.
     */
    public void setJobTemplateStepCount( @Nullable final Integer jobTemplateStepCount )
    {
        rememberChangedField("JobTemplateStepCount", this.jobTemplateStepCount);
        this.jobTemplateStepCount = jobTemplateStepCount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>JobPeriodicGranularity</b>
     * </p>
     *
     * @param jobPeriodicGranularity
     *            The jobPeriodicGranularity to set.
     */
    public void setJobPeriodicGranularity( @Nullable final String jobPeriodicGranularity )
    {
        rememberChangedField("JobPeriodicGranularity", this.jobPeriodicGranularity);
        this.jobPeriodicGranularity = jobPeriodicGranularity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>JobReportName</b>
     * </p>
     *
     * @param jobReportName
     *            The jobReportName to set.
     */
    public void setJobReportName( @Nullable final String jobReportName )
    {
        rememberChangedField("JobReportName", this.jobReportName);
        this.jobReportName = jobReportName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>JobUserName</b>
     * </p>
     *
     * @param jobUserName
     *            The jobUserName to set.
     */
    public void setJobUserName( @Nullable final String jobUserName )
    {
        rememberChangedField("JobUserName", this.jobUserName);
        this.jobUserName = jobUserName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JobPeriodicValue</b>
     * </p>
     *
     * @param jobPeriodicValue
     *            The jobPeriodicValue to set.
     */
    public void setJobPeriodicValue( @Nullable final String jobPeriodicValue )
    {
        rememberChangedField("JobPeriodicValue", this.jobPeriodicValue);
        this.jobPeriodicValue = jobPeriodicValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 120
     * <p>
     * Original property name from the Odata EDM: <b>JobTemplateText</b>
     * </p>
     *
     * @param jobTemplateText
     *            The jobTemplateText to set.
     */
    public void setJobTemplateText( @Nullable final String jobTemplateText )
    {
        rememberChangedField("JobTemplateText", this.jobTemplateText);
        this.jobTemplateText = jobTemplateText;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     * <p>
     * In order to convert local time into a UTC time stamp, which makes it easier to compare times, the local time must
     * be converted according to your time zone. The ABAP command convert is available for this purpose. Even if the
     * time zone that the conversion is based on can be redetermined from Customizing or master data, we still recommend
     * that you save the time zone. The internal structure of the high-resolution UTC time stamp is logically organized
     * in date and time sections in a packed decimal format (YYYYMMDDhhmmssmmmuuun), which depicts the year, month, day,
     * hour,second, millisecond, microsecond and the first decimal of the nanoseconds. Please note that the hardware
     * that is normally used does not fully support a resolution of 100 nanoseconds, which is available in the
     * structure. See also GET TIME STAMP A UTC time stamp in short form is also available.
     * </p>
     *
     * @param creationDateTime
     *            The UTC timestamp displays date and time according to UTC (Universal Coordinated Time).
     */
    public void setCreationDateTime( @Nullable final LocalDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreationUserName</b>
     * </p>
     *
     * @param creationUserName
     *            The creationUserName to set.
     */
    public void setCreationUserName( @Nullable final String creationUserName )
    {
        rememberChangedField("CreationUserName", this.creationUserName);
        this.creationUserName = creationUserName;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     * <p>
     * In order to convert local time into a UTC time stamp, which makes it easier to compare times, the local time must
     * be converted according to your time zone. The ABAP command convert is available for this purpose. Even if the
     * time zone that the conversion is based on can be redetermined from Customizing or master data, we still recommend
     * that you save the time zone. The internal structure of the high-resolution UTC time stamp is logically organized
     * in date and time sections in a packed decimal format (YYYYMMDDhhmmssmmmuuun), which depicts the year, month, day,
     * hour,second, millisecond, microsecond and the first decimal of the nanoseconds. Please note that the hardware
     * that is normally used does not fully support a resolution of 100 nanoseconds, which is available in the
     * structure. See also GET TIME STAMP A UTC time stamp in short form is also available.
     * </p>
     *
     * @param lastChangeDateTime
     *            The UTC timestamp displays date and time according to UTC (Universal Coordinated Time).
     */
    public void setLastChangeDateTime( @Nullable final LocalDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeUserName</b>
     * </p>
     *
     * @param lastChangeUserName
     *            The lastChangeUserName to set.
     */
    public void setLastChangeUserName( @Nullable final String lastChangeUserName )
    {
        rememberChangedField("LastChangeUserName", this.lastChangeUserName);
        this.lastChangeUserName = lastChangeUserName;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SupportsTestModeInd</b>
     * </p>
     *
     * @param supportsTestModeInd
     *            General Flag
     */
    public void setSupportsTestModeInd( @Nullable final Boolean supportsTestModeInd )
    {
        rememberChangedField("SupportsTestModeInd", this.supportsTestModeInd);
        this.supportsTestModeInd = supportsTestModeInd;
    }

    @Override
    protected String getEntityCollection()
    {
        return "JobTemplateSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("JobTemplateName", getJobTemplateName());
        result.put("JobTemplateVersion", getJobTemplateVersion());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("JobTemplateName", getJobTemplateName());
        values.put("JobTemplateVersion", getJobTemplateVersion());
        values.put("JobTemplateStepCount", getJobTemplateStepCount());
        values.put("JobPeriodicGranularity", getJobPeriodicGranularity());
        values.put("JobReportName", getJobReportName());
        values.put("JobUserName", getJobUserName());
        values.put("JobPeriodicValue", getJobPeriodicValue());
        values.put("JobTemplateText", getJobTemplateText());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("CreationUserName", getCreationUserName());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("LastChangeUserName", getLastChangeUserName());
        values.put("SupportsTestModeInd", getSupportsTestModeInd());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("JobTemplateName") ) {
                final Object value = values.remove("JobTemplateName");
                if( (value == null) || (!value.equals(getJobTemplateName())) ) {
                    setJobTemplateName(((String) value));
                }
            }
            if( values.containsKey("JobTemplateVersion") ) {
                final Object value = values.remove("JobTemplateVersion");
                if( (value == null) || (!value.equals(getJobTemplateVersion())) ) {
                    setJobTemplateVersion(((String) value));
                }
            }
            if( values.containsKey("JobTemplateStepCount") ) {
                final Object value = values.remove("JobTemplateStepCount");
                if( (value == null) || (!value.equals(getJobTemplateStepCount())) ) {
                    setJobTemplateStepCount(((Integer) value));
                }
            }
            if( values.containsKey("JobPeriodicGranularity") ) {
                final Object value = values.remove("JobPeriodicGranularity");
                if( (value == null) || (!value.equals(getJobPeriodicGranularity())) ) {
                    setJobPeriodicGranularity(((String) value));
                }
            }
            if( values.containsKey("JobReportName") ) {
                final Object value = values.remove("JobReportName");
                if( (value == null) || (!value.equals(getJobReportName())) ) {
                    setJobReportName(((String) value));
                }
            }
            if( values.containsKey("JobUserName") ) {
                final Object value = values.remove("JobUserName");
                if( (value == null) || (!value.equals(getJobUserName())) ) {
                    setJobUserName(((String) value));
                }
            }
            if( values.containsKey("JobPeriodicValue") ) {
                final Object value = values.remove("JobPeriodicValue");
                if( (value == null) || (!value.equals(getJobPeriodicValue())) ) {
                    setJobPeriodicValue(((String) value));
                }
            }
            if( values.containsKey("JobTemplateText") ) {
                final Object value = values.remove("JobTemplateText");
                if( (value == null) || (!value.equals(getJobTemplateText())) ) {
                    setJobTemplateText(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationUserName") ) {
                final Object value = values.remove("CreationUserName");
                if( (value == null) || (!value.equals(getCreationUserName())) ) {
                    setCreationUserName(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangeUserName") ) {
                final Object value = values.remove("LastChangeUserName");
                if( (value == null) || (!value.equals(getLastChangeUserName())) ) {
                    setLastChangeUserName(((String) value));
                }
            }
            if( values.containsKey("SupportsTestModeInd") ) {
                final Object value = values.remove("SupportsTestModeInd");
                if( (value == null) || (!value.equals(getSupportsTestModeInd())) ) {
                    setSupportsTestModeInd(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> JobTemplateField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new JobTemplateField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> JobTemplateField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new JobTemplateField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ExternalJobSchedulerIntegrationService.DEFAULT_SERVICE_PATH);
    }

}
