/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.selectable.JobTemplateSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobTemplate JobTemplate}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class JobTemplateByKeyFluentHelper
    extends
    FluentHelperByKey<JobTemplateByKeyFluentHelper, JobTemplate, JobTemplateSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobTemplate
     * JobTemplate} entity with the provided key field values. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code JobTemplate}
     * @param servicePath
     *            Service path to be used to fetch a single {@code JobTemplate}
     * @param jobTemplateName
     *
     * @param jobTemplateVersion
     *
     */
    public JobTemplateByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String jobTemplateName,
        final String jobTemplateVersion )
    {
        super(servicePath, entityCollection);
        this.key.put("JobTemplateName", jobTemplateName);
        this.key.put("JobTemplateVersion", jobTemplateVersion);
    }

    @Override
    @Nonnull
    protected Class<JobTemplate> getEntityClass()
    {
        return JobTemplate.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
