/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link ExternalJobSchedulerIntegrationServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ExternalJobSchedulerIntegrationService
 * ExternalJobSchedulerIntegrationService}, allowing you to create multiple changesets and finally execute the batch
 * request.
 *
 */
public class DefaultExternalJobSchedulerIntegrationServiceBatch
    extends
    BatchFluentHelperBasic<ExternalJobSchedulerIntegrationServiceBatch, ExternalJobSchedulerIntegrationServiceBatchChangeSet>
    implements
    ExternalJobSchedulerIntegrationServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ExternalJobSchedulerIntegrationService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultExternalJobSchedulerIntegrationServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultExternalJobSchedulerIntegrationServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ExternalJobSchedulerIntegrationService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.ExternalJobSchedulerIntegrationService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultExternalJobSchedulerIntegrationServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultExternalJobSchedulerIntegrationServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ExternalJobSchedulerIntegrationService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultExternalJobSchedulerIntegrationServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ExternalJobSchedulerIntegrationServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultExternalJobSchedulerIntegrationServiceBatchChangeSet(this, service);
    }

}
