/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link ExternalJobSchedulerIntegrationServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ExternalJobSchedulerIntegrationService
 * ExternalJobSchedulerIntegrationService}.
 *
 */
public class DefaultExternalJobSchedulerIntegrationServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ExternalJobSchedulerIntegrationServiceBatch, ExternalJobSchedulerIntegrationServiceBatchChangeSet>
    implements
    ExternalJobSchedulerIntegrationServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ExternalJobSchedulerIntegrationService service;

    @SuppressWarnings( "deprecation" )
    DefaultExternalJobSchedulerIntegrationServiceBatchChangeSet(
        @Nonnull final DefaultExternalJobSchedulerIntegrationServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ExternalJobSchedulerIntegrationService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultExternalJobSchedulerIntegrationServiceBatchChangeSet getThis()
    {
        return this;
    }

}
