/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.FuncImpReturn;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.FuncImpReturn
 * FuncImpReturn}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.field.FuncImpReturnField
 * FuncImpReturnField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.link.FuncImpReturnLink
 * FuncImpReturnLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.FuncImpReturn#RETURN_CODE
 * RETURN_CODE}</li>
 * </ul>
 *
 */
public interface FuncImpReturnSelectable extends EntitySelectable<FuncImpReturn>
{

}
