/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobScheduleStatus;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobScheduleStatus
 * JobScheduleStatus}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.field.JobScheduleStatusField
 * JobScheduleStatusField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.link.JobScheduleStatusLink
 * JobScheduleStatusLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobScheduleStatus#JOB_NAME
 * JOB_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobScheduleStatus#JOB_RUN_COUNT
 * JOB_RUN_COUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobScheduleStatus#JOB_STATUS
 * JOB_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobScheduleStatus#RETURN_CODE
 * RETURN_CODE}</li>
 * </ul>
 *
 */
public interface JobScheduleStatusSelectable extends EntitySelectable<JobScheduleStatus>
{

}
