/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobTemplate;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobTemplate JobTemplate}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.field.JobTemplateField
 * JobTemplateField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.link.JobTemplateLink
 * JobTemplateLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobTemplate#JOB_TEMPLATE_NAME
 * JOB_TEMPLATE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobTemplate#JOB_TEMPLATE_VERSION
 * JOB_TEMPLATE_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobTemplate#JOB_TEMPLATE_STEP_COUNT
 * JOB_TEMPLATE_STEP_COUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobTemplate#JOB_PERIODIC_GRANULARITY
 * JOB_PERIODIC_GRANULARITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobTemplate#JOB_REPORT_NAME
 * JOB_REPORT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobTemplate#JOB_USER_NAME
 * JOB_USER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobTemplate#JOB_PERIODIC_VALUE
 * JOB_PERIODIC_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobTemplate#JOB_TEMPLATE_TEXT
 * JOB_TEMPLATE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobTemplate#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobTemplate#CREATION_USER_NAME
 * CREATION_USER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobTemplate#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobTemplate#LAST_CHANGE_USER_NAME
 * LAST_CHANGE_USER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.externaljobschedulerintegration.JobTemplate#SUPPORTS_TEST_MODE_IND
 * SUPPORTS_TEST_MODE_IND}</li>
 * </ul>
 *
 */
public interface JobTemplateSelectable extends EntitySelectable<JobTemplate>
{

}
