/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.field.FinPlanningEntryItemTPField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.selectable.FinPlanningEntryItemTPSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Financial Planning Entry Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_FinPlanningEntryItemTPType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FinPlanningEntryItemTP extends VdmEntity<FinPlanningEntryItemTP>
{

    /**
     * Selector for all available fields of FinPlanningEntryItemTP.
     *
     */
    public final static FinPlanningEntryItemTPSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ID</b>
     * </p>
     *
     * @return The iD contained in this entity.
     */
    @Key
    @SerializedName( "ID" )
    @JsonProperty( "ID" )
    @Nullable
    @ODataField( odataName = "ID" )
    private String iD;
    /**
     * Use with available fluent helpers to apply the <b>ID</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> ID = new FinPlanningEntryItemTPField<String>("ID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Ledger</b>
     * </p>
     *
     * @return Ledger
     */
    @SerializedName( "Ledger" )
    @JsonProperty( "Ledger" )
    @Nullable
    @ODataField( odataName = "Ledger" )
    private String ledger;
    /**
     * Use with available fluent helpers to apply the <b>Ledger</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> LEDGER = new FinPlanningEntryItemTPField<String>("Ledger");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PlanningCategory</b>
     * </p>
     *
     * @return Plan Category
     */
    @SerializedName( "PlanningCategory" )
    @JsonProperty( "PlanningCategory" )
    @Nullable
    @ODataField( odataName = "PlanningCategory" )
    private String planningCategory;
    /**
     * Use with available fluent helpers to apply the <b>PlanningCategory</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> PLANNING_CATEGORY =
        new FinPlanningEntryItemTPField<String>("PlanningCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LedgerFiscalYear</b>
     * </p>
     *
     * @return Fiscal Year of Ledger
     */
    @SerializedName( "LedgerFiscalYear" )
    @JsonProperty( "LedgerFiscalYear" )
    @Nullable
    @ODataField( odataName = "LedgerFiscalYear" )
    private String ledgerFiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>LedgerFiscalYear</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> LEDGER_FISCAL_YEAR =
        new FinPlanningEntryItemTPField<String>("LedgerFiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @return G/L Account
     */
    @SerializedName( "GLAccount" )
    @JsonProperty( "GLAccount" )
    @Nullable
    @ODataField( odataName = "GLAccount" )
    private String gLAccount;
    /**
     * Use with available fluent helpers to apply the <b>GLAccount</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> GL_ACCOUNT =
        new FinPlanningEntryItemTPField<String>("GLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> COMPANY_CODE =
        new FinPlanningEntryItemTPField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionType</b>
     * </p>
     *
     * @return Transaction type
     */
    @SerializedName( "FinancialTransactionType" )
    @JsonProperty( "FinancialTransactionType" )
    @Nullable
    @ODataField( odataName = "FinancialTransactionType" )
    private String financialTransactionType;
    /**
     * Use with available fluent helpers to apply the <b>FinancialTransactionType</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> FINANCIAL_TRANSACTION_TYPE =
        new FinPlanningEntryItemTPField<String>("FinancialTransactionType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> COST_CENTER =
        new FinPlanningEntryItemTPField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> PROFIT_CENTER =
        new FinPlanningEntryItemTPField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @return Functional Area
     */
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> FUNCTIONAL_AREA =
        new FinPlanningEntryItemTPField<String>("FunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> BUSINESS_AREA =
        new FinPlanningEntryItemTPField<String>("BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> CONTROLLING_AREA =
        new FinPlanningEntryItemTPField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @return Segment for Segmental Reporting
     */
    @SerializedName( "Segment" )
    @JsonProperty( "Segment" )
    @Nullable
    @ODataField( odataName = "Segment" )
    private String segment;
    /**
     * Use with available fluent helpers to apply the <b>Segment</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> SEGMENT =
        new FinPlanningEntryItemTPField<String>("Segment");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostCenter</b>
     * </p>
     *
     * @return Partner Cost Center
     */
    @SerializedName( "PartnerCostCenter" )
    @JsonProperty( "PartnerCostCenter" )
    @Nullable
    @ODataField( odataName = "PartnerCostCenter" )
    private String partnerCostCenter;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCostCenter</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> PARTNER_COST_CENTER =
        new FinPlanningEntryItemTPField<String>("PartnerCostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProfitCenter</b>
     * </p>
     *
     * @return Partner Profit Center
     */
    @SerializedName( "PartnerProfitCenter" )
    @JsonProperty( "PartnerProfitCenter" )
    @Nullable
    @ODataField( odataName = "PartnerProfitCenter" )
    private String partnerProfitCenter;
    /**
     * Use with available fluent helpers to apply the <b>PartnerProfitCenter</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> PARTNER_PROFIT_CENTER =
        new FinPlanningEntryItemTPField<String>("PartnerProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunctionalArea</b>
     * </p>
     *
     * @return Partner Functional Area
     */
    @SerializedName( "PartnerFunctionalArea" )
    @JsonProperty( "PartnerFunctionalArea" )
    @Nullable
    @ODataField( odataName = "PartnerFunctionalArea" )
    private String partnerFunctionalArea;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunctionalArea</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> PARTNER_FUNCTIONAL_AREA =
        new FinPlanningEntryItemTPField<String>("PartnerFunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessArea</b>
     * </p>
     *
     * @return Partner Business Area
     */
    @SerializedName( "PartnerBusinessArea" )
    @JsonProperty( "PartnerBusinessArea" )
    @Nullable
    @ODataField( odataName = "PartnerBusinessArea" )
    private String partnerBusinessArea;
    /**
     * Use with available fluent helpers to apply the <b>PartnerBusinessArea</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> PARTNER_BUSINESS_AREA =
        new FinPlanningEntryItemTPField<String>("PartnerBusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompany</b>
     * </p>
     *
     * @return Company ID of Trading Partner
     */
    @SerializedName( "PartnerCompany" )
    @JsonProperty( "PartnerCompany" )
    @Nullable
    @ODataField( odataName = "PartnerCompany" )
    private String partnerCompany;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCompany</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> PARTNER_COMPANY =
        new FinPlanningEntryItemTPField<String>("PartnerCompany");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSegment</b>
     * </p>
     *
     * @return Partner Segment for Segmental Reporting
     */
    @SerializedName( "PartnerSegment" )
    @JsonProperty( "PartnerSegment" )
    @Nullable
    @ODataField( odataName = "PartnerSegment" )
    private String partnerSegment;
    /**
     * Use with available fluent helpers to apply the <b>PartnerSegment</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> PARTNER_SEGMENT =
        new FinPlanningEntryItemTPField<String>("PartnerSegment");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FixedVariableType</b>
     * </p>
     *
     * @return Amount is of Type Fixed or Variable
     */
    @SerializedName( "FixedVariableType" )
    @JsonProperty( "FixedVariableType" )
    @Nullable
    @ODataField( odataName = "FixedVariableType" )
    private String fixedVariableType;
    /**
     * Use with available fluent helpers to apply the <b>FixedVariableType</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> FIXED_VARIABLE_TYPE =
        new FinPlanningEntryItemTPField<String>("FixedVariableType");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return Transaction Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> TRANSACTION_CURRENCY =
        new FinPlanningEntryItemTPField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInTransactionCurrency</b>
     * </p>
     *
     * @return Amount in Transaction Currency
     */
    @SerializedName( "AmountInTransactionCurrency" )
    @JsonProperty( "AmountInTransactionCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInTransactionCurrency" )
    private BigDecimal amountInTransactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInTransactionCurrency</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<BigDecimal> AMOUNT_IN_TRANSACTION_CURRENCY =
        new FinPlanningEntryItemTPField<BigDecimal>("AmountInTransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FixedAmountInTransCrcy</b>
     * </p>
     *
     * @return Fixed Amount in Transaction Currency
     */
    @SerializedName( "FixedAmountInTransCrcy" )
    @JsonProperty( "FixedAmountInTransCrcy" )
    @Nullable
    @ODataField( odataName = "FixedAmountInTransCrcy" )
    private BigDecimal fixedAmountInTransCrcy;
    /**
     * Use with available fluent helpers to apply the <b>FixedAmountInTransCrcy</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<BigDecimal> FIXED_AMOUNT_IN_TRANS_CRCY =
        new FinPlanningEntryItemTPField<BigDecimal>("FixedAmountInTransCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     *
     * @return Company Code Currency
     */
    @SerializedName( "CompanyCodeCurrency" )
    @JsonProperty( "CompanyCodeCurrency" )
    @Nullable
    @ODataField( odataName = "CompanyCodeCurrency" )
    private String companyCodeCurrency;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeCurrency</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> COMPANY_CODE_CURRENCY =
        new FinPlanningEntryItemTPField<String>("CompanyCodeCurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInCompanyCodeCurrency</b>
     * </p>
     *
     * @return Amount in Company Code Currency
     */
    @SerializedName( "AmountInCompanyCodeCurrency" )
    @JsonProperty( "AmountInCompanyCodeCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInCompanyCodeCurrency" )
    private BigDecimal amountInCompanyCodeCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInCompanyCodeCurrency</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<BigDecimal> AMOUNT_IN_COMPANY_CODE_CURRENCY =
        new FinPlanningEntryItemTPField<BigDecimal>("AmountInCompanyCodeCurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FixedAmountInCoCodeCrcy</b>
     * </p>
     *
     * @return Fixed Amount in Company Currency
     */
    @SerializedName( "FixedAmountInCoCodeCrcy" )
    @JsonProperty( "FixedAmountInCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "FixedAmountInCoCodeCrcy" )
    private BigDecimal fixedAmountInCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>FixedAmountInCoCodeCrcy</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<BigDecimal> FIXED_AMOUNT_IN_CO_CODE_CRCY =
        new FinPlanningEntryItemTPField<BigDecimal>("FixedAmountInCoCodeCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GlobalCurrency</b>
     * </p>
     *
     * @return Global Currency
     */
    @SerializedName( "GlobalCurrency" )
    @JsonProperty( "GlobalCurrency" )
    @Nullable
    @ODataField( odataName = "GlobalCurrency" )
    private String globalCurrency;
    /**
     * Use with available fluent helpers to apply the <b>GlobalCurrency</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> GLOBAL_CURRENCY =
        new FinPlanningEntryItemTPField<String>("GlobalCurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInGlobalCurrency</b>
     * </p>
     *
     * @return Amount in Global Currency
     */
    @SerializedName( "AmountInGlobalCurrency" )
    @JsonProperty( "AmountInGlobalCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInGlobalCurrency" )
    private BigDecimal amountInGlobalCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInGlobalCurrency</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<BigDecimal> AMOUNT_IN_GLOBAL_CURRENCY =
        new FinPlanningEntryItemTPField<BigDecimal>("AmountInGlobalCurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FixedAmountInGlobalCrcy</b>
     * </p>
     *
     * @return Fixed Amount in Global Currency
     */
    @SerializedName( "FixedAmountInGlobalCrcy" )
    @JsonProperty( "FixedAmountInGlobalCrcy" )
    @Nullable
    @ODataField( odataName = "FixedAmountInGlobalCrcy" )
    private BigDecimal fixedAmountInGlobalCrcy;
    /**
     * Use with available fluent helpers to apply the <b>FixedAmountInGlobalCrcy</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<BigDecimal> FIXED_AMOUNT_IN_GLOBAL_CRCY =
        new FinPlanningEntryItemTPField<BigDecimal>("FixedAmountInGlobalCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ControllingObjectCurrency</b>
     * </p>
     *
     * @return CO Object Currency
     */
    @SerializedName( "ControllingObjectCurrency" )
    @JsonProperty( "ControllingObjectCurrency" )
    @Nullable
    @ODataField( odataName = "ControllingObjectCurrency" )
    private String controllingObjectCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ControllingObjectCurrency</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> CONTROLLING_OBJECT_CURRENCY =
        new FinPlanningEntryItemTPField<String>("ControllingObjectCurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInObjectCurrency</b>
     * </p>
     *
     * @return Amount in CO Object Currency
     */
    @SerializedName( "AmountInObjectCurrency" )
    @JsonProperty( "AmountInObjectCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInObjectCurrency" )
    private BigDecimal amountInObjectCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInObjectCurrency</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<BigDecimal> AMOUNT_IN_OBJECT_CURRENCY =
        new FinPlanningEntryItemTPField<BigDecimal>("AmountInObjectCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalCurrency</b>
     * </p>
     *
     * @return Functional Currency
     */
    @SerializedName( "FunctionalCurrency" )
    @JsonProperty( "FunctionalCurrency" )
    @Nullable
    @ODataField( odataName = "FunctionalCurrency" )
    private String functionalCurrency;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalCurrency</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> FUNCTIONAL_CURRENCY =
        new FinPlanningEntryItemTPField<String>("FunctionalCurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFunctionalCurrency</b>
     * </p>
     *
     * @return Amount in Functional Currency
     */
    @SerializedName( "AmountInFunctionalCurrency" )
    @JsonProperty( "AmountInFunctionalCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInFunctionalCurrency" )
    private BigDecimal amountInFunctionalCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInFunctionalCurrency</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<BigDecimal> AMOUNT_IN_FUNCTIONAL_CURRENCY =
        new FinPlanningEntryItemTPField<BigDecimal>("AmountInFunctionalCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CostSourceUnit</b>
     * </p>
     *
     * @return Unit of Measure
     */
    @SerializedName( "CostSourceUnit" )
    @JsonProperty( "CostSourceUnit" )
    @Nullable
    @ODataField( odataName = "CostSourceUnit" )
    private String costSourceUnit;
    /**
     * Use with available fluent helpers to apply the <b>CostSourceUnit</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> COST_SOURCE_UNIT =
        new FinPlanningEntryItemTPField<String>("CostSourceUnit");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ValuationQuantity</b>
     * </p>
     *
     * @return Valuation Quantity
     */
    @SerializedName( "ValuationQuantity" )
    @JsonProperty( "ValuationQuantity" )
    @Nullable
    @ODataField( odataName = "ValuationQuantity" )
    private BigDecimal valuationQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ValuationQuantity</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<BigDecimal> VALUATION_QUANTITY =
        new FinPlanningEntryItemTPField<BigDecimal>("ValuationQuantity");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ValuationFixedQuantity</b>
     * </p>
     *
     * @return Valuation Fixed Quantity
     */
    @SerializedName( "ValuationFixedQuantity" )
    @JsonProperty( "ValuationFixedQuantity" )
    @Nullable
    @ODataField( odataName = "ValuationFixedQuantity" )
    private BigDecimal valuationFixedQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ValuationFixedQuantity</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<BigDecimal> VALUATION_FIXED_QUANTITY =
        new FinPlanningEntryItemTPField<BigDecimal>("ValuationFixedQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceQuantityUnit</b>
     * </p>
     *
     * @return Unit of Measure for Reference Quantity
     */
    @SerializedName( "ReferenceQuantityUnit" )
    @JsonProperty( "ReferenceQuantityUnit" )
    @Nullable
    @ODataField( odataName = "ReferenceQuantityUnit" )
    private String referenceQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceQuantityUnit</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> REFERENCE_QUANTITY_UNIT =
        new FinPlanningEntryItemTPField<String>("ReferenceQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceQuantity</b>
     * </p>
     *
     * @return Reference quantity
     */
    @SerializedName( "ReferenceQuantity" )
    @JsonProperty( "ReferenceQuantity" )
    @Nullable
    @ODataField( odataName = "ReferenceQuantity" )
    private BigDecimal referenceQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceQuantity</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<BigDecimal> REFERENCE_QUANTITY =
        new FinPlanningEntryItemTPField<BigDecimal>("ReferenceQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency1</b>
     * </p>
     *
     * @return Freely Defined Currency 1
     */
    @SerializedName( "FreeDefinedCurrency1" )
    @JsonProperty( "FreeDefinedCurrency1" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency1" )
    private String freeDefinedCurrency1;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency1</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> FREE_DEFINED_CURRENCY1 =
        new FinPlanningEntryItemTPField<String>("FreeDefinedCurrency1");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency1</b>
     * </p>
     *
     * @return Amount in Freely Defined Currency 1
     */
    @SerializedName( "AmountInFreeDefinedCurrency1" )
    @JsonProperty( "AmountInFreeDefinedCurrency1" )
    @Nullable
    @ODataField( odataName = "AmountInFreeDefinedCurrency1" )
    private BigDecimal amountInFreeDefinedCurrency1;
    /**
     * Use with available fluent helpers to apply the <b>AmountInFreeDefinedCurrency1</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<BigDecimal> AMOUNT_IN_FREE_DEFINED_CURRENCY1 =
        new FinPlanningEntryItemTPField<BigDecimal>("AmountInFreeDefinedCurrency1");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency2</b>
     * </p>
     *
     * @return Freely Defined Currency 2
     */
    @SerializedName( "FreeDefinedCurrency2" )
    @JsonProperty( "FreeDefinedCurrency2" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency2" )
    private String freeDefinedCurrency2;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency2</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> FREE_DEFINED_CURRENCY2 =
        new FinPlanningEntryItemTPField<String>("FreeDefinedCurrency2");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency2</b>
     * </p>
     *
     * @return Amount in Freely Defined Currency 2
     */
    @SerializedName( "AmountInFreeDefinedCurrency2" )
    @JsonProperty( "AmountInFreeDefinedCurrency2" )
    @Nullable
    @ODataField( odataName = "AmountInFreeDefinedCurrency2" )
    private BigDecimal amountInFreeDefinedCurrency2;
    /**
     * Use with available fluent helpers to apply the <b>AmountInFreeDefinedCurrency2</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<BigDecimal> AMOUNT_IN_FREE_DEFINED_CURRENCY2 =
        new FinPlanningEntryItemTPField<BigDecimal>("AmountInFreeDefinedCurrency2");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency3</b>
     * </p>
     *
     * @return Freely Defined Currency 3
     */
    @SerializedName( "FreeDefinedCurrency3" )
    @JsonProperty( "FreeDefinedCurrency3" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency3" )
    private String freeDefinedCurrency3;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency3</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> FREE_DEFINED_CURRENCY3 =
        new FinPlanningEntryItemTPField<String>("FreeDefinedCurrency3");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency3</b>
     * </p>
     *
     * @return Amount in Freely Defined Currency 3
     */
    @SerializedName( "AmountInFreeDefinedCurrency3" )
    @JsonProperty( "AmountInFreeDefinedCurrency3" )
    @Nullable
    @ODataField( odataName = "AmountInFreeDefinedCurrency3" )
    private BigDecimal amountInFreeDefinedCurrency3;
    /**
     * Use with available fluent helpers to apply the <b>AmountInFreeDefinedCurrency3</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<BigDecimal> AMOUNT_IN_FREE_DEFINED_CURRENCY3 =
        new FinPlanningEntryItemTPField<BigDecimal>("AmountInFreeDefinedCurrency3");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency4</b>
     * </p>
     *
     * @return Freely Defined Currency 4
     */
    @SerializedName( "FreeDefinedCurrency4" )
    @JsonProperty( "FreeDefinedCurrency4" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency4" )
    private String freeDefinedCurrency4;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency4</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> FREE_DEFINED_CURRENCY4 =
        new FinPlanningEntryItemTPField<String>("FreeDefinedCurrency4");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency4</b>
     * </p>
     *
     * @return Amount in Freely Defined Currency 4
     */
    @SerializedName( "AmountInFreeDefinedCurrency4" )
    @JsonProperty( "AmountInFreeDefinedCurrency4" )
    @Nullable
    @ODataField( odataName = "AmountInFreeDefinedCurrency4" )
    private BigDecimal amountInFreeDefinedCurrency4;
    /**
     * Use with available fluent helpers to apply the <b>AmountInFreeDefinedCurrency4</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<BigDecimal> AMOUNT_IN_FREE_DEFINED_CURRENCY4 =
        new FinPlanningEntryItemTPField<BigDecimal>("AmountInFreeDefinedCurrency4");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency5</b>
     * </p>
     *
     * @return Freely Defined Currency 5
     */
    @SerializedName( "FreeDefinedCurrency5" )
    @JsonProperty( "FreeDefinedCurrency5" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency5" )
    private String freeDefinedCurrency5;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency5</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> FREE_DEFINED_CURRENCY5 =
        new FinPlanningEntryItemTPField<String>("FreeDefinedCurrency5");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency5</b>
     * </p>
     *
     * @return Amount in Freely Defined Currency 5
     */
    @SerializedName( "AmountInFreeDefinedCurrency5" )
    @JsonProperty( "AmountInFreeDefinedCurrency5" )
    @Nullable
    @ODataField( odataName = "AmountInFreeDefinedCurrency5" )
    private BigDecimal amountInFreeDefinedCurrency5;
    /**
     * Use with available fluent helpers to apply the <b>AmountInFreeDefinedCurrency5</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<BigDecimal> AMOUNT_IN_FREE_DEFINED_CURRENCY5 =
        new FinPlanningEntryItemTPField<BigDecimal>("AmountInFreeDefinedCurrency5");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency6</b>
     * </p>
     *
     * @return Freely Defined Currency 6
     */
    @SerializedName( "FreeDefinedCurrency6" )
    @JsonProperty( "FreeDefinedCurrency6" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency6" )
    private String freeDefinedCurrency6;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency6</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> FREE_DEFINED_CURRENCY6 =
        new FinPlanningEntryItemTPField<String>("FreeDefinedCurrency6");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency6</b>
     * </p>
     *
     * @return Amount in Freely Defined Currency 6
     */
    @SerializedName( "AmountInFreeDefinedCurrency6" )
    @JsonProperty( "AmountInFreeDefinedCurrency6" )
    @Nullable
    @ODataField( odataName = "AmountInFreeDefinedCurrency6" )
    private BigDecimal amountInFreeDefinedCurrency6;
    /**
     * Use with available fluent helpers to apply the <b>AmountInFreeDefinedCurrency6</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<BigDecimal> AMOUNT_IN_FREE_DEFINED_CURRENCY6 =
        new FinPlanningEntryItemTPField<BigDecimal>("AmountInFreeDefinedCurrency6");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency7</b>
     * </p>
     *
     * @return Freely Defined Currency 7
     */
    @SerializedName( "FreeDefinedCurrency7" )
    @JsonProperty( "FreeDefinedCurrency7" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency7" )
    private String freeDefinedCurrency7;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency7</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> FREE_DEFINED_CURRENCY7 =
        new FinPlanningEntryItemTPField<String>("FreeDefinedCurrency7");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency7</b>
     * </p>
     *
     * @return Amount in Freely Defined Currency 7
     */
    @SerializedName( "AmountInFreeDefinedCurrency7" )
    @JsonProperty( "AmountInFreeDefinedCurrency7" )
    @Nullable
    @ODataField( odataName = "AmountInFreeDefinedCurrency7" )
    private BigDecimal amountInFreeDefinedCurrency7;
    /**
     * Use with available fluent helpers to apply the <b>AmountInFreeDefinedCurrency7</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<BigDecimal> AMOUNT_IN_FREE_DEFINED_CURRENCY7 =
        new FinPlanningEntryItemTPField<BigDecimal>("AmountInFreeDefinedCurrency7");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency8</b>
     * </p>
     *
     * @return Freely Defined Currency 8
     */
    @SerializedName( "FreeDefinedCurrency8" )
    @JsonProperty( "FreeDefinedCurrency8" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency8" )
    private String freeDefinedCurrency8;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency8</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> FREE_DEFINED_CURRENCY8 =
        new FinPlanningEntryItemTPField<String>("FreeDefinedCurrency8");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency8</b>
     * </p>
     *
     * @return Amount in Freely Defined Currency 8
     */
    @SerializedName( "AmountInFreeDefinedCurrency8" )
    @JsonProperty( "AmountInFreeDefinedCurrency8" )
    @Nullable
    @ODataField( odataName = "AmountInFreeDefinedCurrency8" )
    private BigDecimal amountInFreeDefinedCurrency8;
    /**
     * Use with available fluent helpers to apply the <b>AmountInFreeDefinedCurrency8</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<BigDecimal> AMOUNT_IN_FREE_DEFINED_CURRENCY8 =
        new FinPlanningEntryItemTPField<BigDecimal>("AmountInFreeDefinedCurrency8");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriod</b>
     * </p>
     *
     * @return Fiscal Period
     */
    @SerializedName( "FiscalPeriod" )
    @JsonProperty( "FiscalPeriod" )
    @Nullable
    @ODataField( odataName = "FiscalPeriod" )
    private String fiscalPeriod;
    /**
     * Use with available fluent helpers to apply the <b>FiscalPeriod</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> FISCAL_PERIOD =
        new FinPlanningEntryItemTPField<String>("FiscalPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearVariant</b>
     * </p>
     *
     * @return Fiscal Year Variant
     */
    @SerializedName( "FiscalYearVariant" )
    @JsonProperty( "FiscalYearVariant" )
    @Nullable
    @ODataField( odataName = "FiscalYearVariant" )
    private String fiscalYearVariant;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYearVariant</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> FISCAL_YEAR_VARIANT =
        new FinPlanningEntryItemTPField<String>("FiscalYearVariant");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearPeriod</b>
     * </p>
     *
     * @return The fiscalYearPeriod contained in this entity.
     */
    @SerializedName( "FiscalYearPeriod" )
    @JsonProperty( "FiscalYearPeriod" )
    @Nullable
    @ODataField( odataName = "FiscalYearPeriod" )
    private String fiscalYearPeriod;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYearPeriod</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> FISCAL_YEAR_PERIOD =
        new FinPlanningEntryItemTPField<String>("FiscalYearPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @return Chart of Accounts
     */
    @SerializedName( "ChartOfAccounts" )
    @JsonProperty( "ChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ChartOfAccounts" )
    private String chartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ChartOfAccounts</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> CHART_OF_ACCOUNTS =
        new FinPlanningEntryItemTPField<String>("ChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> PLANT = new FinPlanningEntryItemTPField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer Number
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> CUSTOMER =
        new FinPlanningEntryItemTPField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ControllingDebitCreditCode</b>
     * </p>
     *
     * @return CO Debit/Credit Indicator
     */
    @SerializedName( "ControllingDebitCreditCode" )
    @JsonProperty( "ControllingDebitCreditCode" )
    @Nullable
    @ODataField( odataName = "ControllingDebitCreditCode" )
    private String controllingDebitCreditCode;
    /**
     * Use with available fluent helpers to apply the <b>ControllingDebitCreditCode</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> CONTROLLING_DEBIT_CREDIT_CODE =
        new FinPlanningEntryItemTPField<String>("ControllingDebitCreditCode");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Project</b>
     * </p>
     *
     * @return Project Definition
     */
    @SerializedName( "Project" )
    @JsonProperty( "Project" )
    @Nullable
    @ODataField( odataName = "Project" )
    private String project;
    /**
     * Use with available fluent helpers to apply the <b>Project</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> PROJECT =
        new FinPlanningEntryItemTPField<String>("Project");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element)
     */
    @SerializedName( "WBSElement" )
    @JsonProperty( "WBSElement" )
    @Nullable
    @ODataField( odataName = "WBSElement" )
    private String wBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElement</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> WBS_ELEMENT =
        new FinPlanningEntryItemTPField<String>("WBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompanyCode</b>
     * </p>
     *
     * @return Company Code of Partner
     */
    @SerializedName( "PartnerCompanyCode" )
    @JsonProperty( "PartnerCompanyCode" )
    @Nullable
    @ODataField( odataName = "PartnerCompanyCode" )
    private String partnerCompanyCode;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCompanyCode</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> PARTNER_COMPANY_CODE =
        new FinPlanningEntryItemTPField<String>("PartnerCompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType</b>
     * </p>
     *
     * @return Activity Type
     */
    @SerializedName( "CostCtrActivityType" )
    @JsonProperty( "CostCtrActivityType" )
    @Nullable
    @ODataField( odataName = "CostCtrActivityType" )
    private String costCtrActivityType;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrActivityType</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> COST_CTR_ACTIVITY_TYPE =
        new FinPlanningEntryItemTPField<String>("CostCtrActivityType");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @return Order ID
     */
    @SerializedName( "OrderID" )
    @JsonProperty( "OrderID" )
    @Nullable
    @ODataField( odataName = "OrderID" )
    private String orderID;
    /**
     * Use with available fluent helpers to apply the <b>OrderID</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> ORDER_ID =
        new FinPlanningEntryItemTPField<String>("OrderID");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PartnerOrder</b>
     * </p>
     *
     * @return Partner Order
     */
    @SerializedName( "PartnerOrder" )
    @JsonProperty( "PartnerOrder" )
    @Nullable
    @ODataField( odataName = "PartnerOrder" )
    private String partnerOrder;
    /**
     * Use with available fluent helpers to apply the <b>PartnerOrder</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> PARTNER_ORDER =
        new FinPlanningEntryItemTPField<String>("PartnerOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostCtrActivityType</b>
     * </p>
     *
     * @return Partner Cost Center Activity Type
     */
    @SerializedName( "PartnerCostCtrActivityType" )
    @JsonProperty( "PartnerCostCtrActivityType" )
    @Nullable
    @ODataField( odataName = "PartnerCostCtrActivityType" )
    private String partnerCostCtrActivityType;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCostCtrActivityType</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> PARTNER_COST_CTR_ACTIVITY_TYPE =
        new FinPlanningEntryItemTPField<String>("PartnerCostCtrActivityType");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProject</b>
     * </p>
     *
     * @return Partner Project
     */
    @SerializedName( "PartnerProject" )
    @JsonProperty( "PartnerProject" )
    @Nullable
    @ODataField( odataName = "PartnerProject" )
    private String partnerProject;
    /**
     * Use with available fluent helpers to apply the <b>PartnerProject</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> PARTNER_PROJECT =
        new FinPlanningEntryItemTPField<String>("PartnerProject");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>PartnerWBSElement</b>
     * </p>
     *
     * @return Partner WBS Element
     */
    @SerializedName( "PartnerWBSElement" )
    @JsonProperty( "PartnerWBSElement" )
    @Nullable
    @ODataField( odataName = "PartnerWBSElement" )
    private String partnerWBSElement;
    /**
     * Use with available fluent helpers to apply the <b>PartnerWBSElement</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> PARTNER_WBS_ELEMENT =
        new FinPlanningEntryItemTPField<String>("PartnerWBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> SALES_ORGANIZATION =
        new FinPlanningEntryItemTPField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Distribution Channel
     */
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> DISTRIBUTION_CHANNEL =
        new FinPlanningEntryItemTPField<String>("DistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @return Division
     */
    @SerializedName( "Division" )
    @JsonProperty( "Division" )
    @Nullable
    @ODataField( odataName = "Division" )
    private String division;
    /**
     * Use with available fluent helpers to apply the <b>Division</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> DIVISION =
        new FinPlanningEntryItemTPField<String>("Division");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SoldMaterial</b>
     * </p>
     *
     * @return Product Sold
     */
    @SerializedName( "SoldMaterial" )
    @JsonProperty( "SoldMaterial" )
    @Nullable
    @ODataField( odataName = "SoldMaterial" )
    private String soldMaterial;
    /**
     * Use with available fluent helpers to apply the <b>SoldMaterial</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> SOLD_MATERIAL =
        new FinPlanningEntryItemTPField<String>("SoldMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Product Sold Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> MATERIAL_GROUP =
        new FinPlanningEntryItemTPField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup</b>
     * </p>
     *
     * @return Customer Group
     */
    @SerializedName( "CustomerGroup" )
    @JsonProperty( "CustomerGroup" )
    @Nullable
    @ODataField( odataName = "CustomerGroup" )
    private String customerGroup;
    /**
     * Use with available fluent helpers to apply the <b>CustomerGroup</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> CUSTOMER_GROUP =
        new FinPlanningEntryItemTPField<String>("CustomerGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CustomerSupplierCountry</b>
     * </p>
     *
     * @return Country/Region of Customer or Supplier
     */
    @SerializedName( "CustomerSupplierCountry" )
    @JsonProperty( "CustomerSupplierCountry" )
    @Nullable
    @ODataField( odataName = "CustomerSupplierCountry" )
    private String customerSupplierCountry;
    /**
     * Use with available fluent helpers to apply the <b>CustomerSupplierCountry</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> CUSTOMER_SUPPLIER_COUNTRY =
        new FinPlanningEntryItemTPField<String>("CustomerSupplierCountry");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerSupplierIndustry</b>
     * </p>
     *
     * @return Industry Key
     */
    @SerializedName( "CustomerSupplierIndustry" )
    @JsonProperty( "CustomerSupplierIndustry" )
    @Nullable
    @ODataField( odataName = "CustomerSupplierIndustry" )
    private String customerSupplierIndustry;
    /**
     * Use with available fluent helpers to apply the <b>CustomerSupplierIndustry</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> CUSTOMER_SUPPLIER_INDUSTRY =
        new FinPlanningEntryItemTPField<String>("CustomerSupplierIndustry");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDistrict</b>
     * </p>
     *
     * @return Sales District
     */
    @SerializedName( "SalesDistrict" )
    @JsonProperty( "SalesDistrict" )
    @Nullable
    @ODataField( odataName = "SalesDistrict" )
    private String salesDistrict;
    /**
     * Use with available fluent helpers to apply the <b>SalesDistrict</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> SALES_DISTRICT =
        new FinPlanningEntryItemTPField<String>("SalesDistrict");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FinancialManagementArea</b>
     * </p>
     *
     * @return Financial Management Area
     */
    @SerializedName( "FinancialManagementArea" )
    @JsonProperty( "FinancialManagementArea" )
    @Nullable
    @ODataField( odataName = "FinancialManagementArea" )
    private String financialManagementArea;
    /**
     * Use with available fluent helpers to apply the <b>FinancialManagementArea</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> FINANCIAL_MANAGEMENT_AREA =
        new FinPlanningEntryItemTPField<String>("FinancialManagementArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @return Fund
     */
    @SerializedName( "Fund" )
    @JsonProperty( "Fund" )
    @Nullable
    @ODataField( odataName = "Fund" )
    private String fund;
    /**
     * Use with available fluent helpers to apply the <b>Fund</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> FUND = new FinPlanningEntryItemTPField<String>("Fund");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @return Grant
     */
    @SerializedName( "GrantID" )
    @JsonProperty( "GrantID" )
    @Nullable
    @ODataField( odataName = "GrantID" )
    private String grantID;
    /**
     * Use with available fluent helpers to apply the <b>GrantID</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> GRANT_ID =
        new FinPlanningEntryItemTPField<String>("GrantID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriod</b>
     * </p>
     *
     * @return Budget Period
     */
    @SerializedName( "BudgetPeriod" )
    @JsonProperty( "BudgetPeriod" )
    @Nullable
    @ODataField( odataName = "BudgetPeriod" )
    private String budgetPeriod;
    /**
     * Use with available fluent helpers to apply the <b>BudgetPeriod</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> BUDGET_PERIOD =
        new FinPlanningEntryItemTPField<String>("BudgetPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BudgetProcess</b>
     * </p>
     *
     * @return Budget Process Type
     */
    @SerializedName( "BudgetProcess" )
    @JsonProperty( "BudgetProcess" )
    @Nullable
    @ODataField( odataName = "BudgetProcess" )
    private String budgetProcess;
    /**
     * Use with available fluent helpers to apply the <b>BudgetProcess</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> BUDGET_PROCESS =
        new FinPlanningEntryItemTPField<String>("BudgetProcess");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BudgetingType</b>
     * </p>
     *
     * @return Budget Type (Subcategory)
     */
    @SerializedName( "BudgetingType" )
    @JsonProperty( "BudgetingType" )
    @Nullable
    @ODataField( odataName = "BudgetingType" )
    private String budgetingType;
    /**
     * Use with available fluent helpers to apply the <b>BudgetingType</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> BUDGETING_TYPE =
        new FinPlanningEntryItemTPField<String>("BudgetingType");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SponsoredProgram</b>
     * </p>
     *
     * @return Sponsored Program
     */
    @SerializedName( "SponsoredProgram" )
    @JsonProperty( "SponsoredProgram" )
    @Nullable
    @ODataField( odataName = "SponsoredProgram" )
    private String sponsoredProgram;
    /**
     * Use with available fluent helpers to apply the <b>SponsoredProgram</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> SPONSORED_PROGRAM =
        new FinPlanningEntryItemTPField<String>("SponsoredProgram");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SponsoredClass</b>
     * </p>
     *
     * @return Sponsored Class
     */
    @SerializedName( "SponsoredClass" )
    @JsonProperty( "SponsoredClass" )
    @Nullable
    @ODataField( odataName = "SponsoredClass" )
    private String sponsoredClass;
    /**
     * Use with available fluent helpers to apply the <b>SponsoredClass</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> SPONSORED_CLASS =
        new FinPlanningEntryItemTPField<String>("SponsoredClass");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GteeMBudgetValidityNumber</b>
     * </p>
     *
     * @return Budget Validity Number
     */
    @SerializedName( "GteeMBudgetValidityNumber" )
    @JsonProperty( "GteeMBudgetValidityNumber" )
    @Nullable
    @ODataField( odataName = "GteeMBudgetValidityNumber" )
    private String gteeMBudgetValidityNumber;
    /**
     * Use with available fluent helpers to apply the <b>GteeMBudgetValidityNumber</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> GTEE_M_BUDGET_VALIDITY_NUMBER =
        new FinPlanningEntryItemTPField<String>("GteeMBudgetValidityNumber");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>REBusinessEntity</b>
     * </p>
     *
     * @return RE Business Entity
     */
    @SerializedName( "REBusinessEntity" )
    @JsonProperty( "REBusinessEntity" )
    @Nullable
    @ODataField( odataName = "REBusinessEntity" )
    private String rEBusinessEntity;
    /**
     * Use with available fluent helpers to apply the <b>REBusinessEntity</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> RE_BUSINESS_ENTITY =
        new FinPlanningEntryItemTPField<String>("REBusinessEntity");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>RealEstateBuilding</b>
     * </p>
     *
     * @return Real Estate Building
     */
    @SerializedName( "RealEstateBuilding" )
    @JsonProperty( "RealEstateBuilding" )
    @Nullable
    @ODataField( odataName = "RealEstateBuilding" )
    private String realEstateBuilding;
    /**
     * Use with available fluent helpers to apply the <b>RealEstateBuilding</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> REAL_ESTATE_BUILDING =
        new FinPlanningEntryItemTPField<String>("RealEstateBuilding");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>RealEstateProperty</b>
     * </p>
     *
     * @return Real Estate Property
     */
    @SerializedName( "RealEstateProperty" )
    @JsonProperty( "RealEstateProperty" )
    @Nullable
    @ODataField( odataName = "RealEstateProperty" )
    private String realEstateProperty;
    /**
     * Use with available fluent helpers to apply the <b>RealEstateProperty</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> REAL_ESTATE_PROPERTY =
        new FinPlanningEntryItemTPField<String>("RealEstateProperty");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>RERentalObject</b>
     * </p>
     *
     * @return RE Rental Object
     */
    @SerializedName( "RERentalObject" )
    @JsonProperty( "RERentalObject" )
    @Nullable
    @ODataField( odataName = "RERentalObject" )
    private String rERentalObject;
    /**
     * Use with available fluent helpers to apply the <b>RERentalObject</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> RE_RENTAL_OBJECT =
        new FinPlanningEntryItemTPField<String>("RERentalObject");
    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>RealEstateContract</b>
     * </p>
     *
     * @return Real Estate Contract
     */
    @SerializedName( "RealEstateContract" )
    @JsonProperty( "RealEstateContract" )
    @Nullable
    @ODataField( odataName = "RealEstateContract" )
    private String realEstateContract;
    /**
     * Use with available fluent helpers to apply the <b>RealEstateContract</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> REAL_ESTATE_CONTRACT =
        new FinPlanningEntryItemTPField<String>("RealEstateContract");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REServiceChargeKey</b>
     * </p>
     *
     * @return RE Service Charge Key
     */
    @SerializedName( "REServiceChargeKey" )
    @JsonProperty( "REServiceChargeKey" )
    @Nullable
    @ODataField( odataName = "REServiceChargeKey" )
    private String rEServiceChargeKey;
    /**
     * Use with available fluent helpers to apply the <b>REServiceChargeKey</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> RE_SERVICE_CHARGE_KEY =
        new FinPlanningEntryItemTPField<String>("REServiceChargeKey");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>RESettlementUnitID</b>
     * </p>
     *
     * @return RE Settlement Unit
     */
    @SerializedName( "RESettlementUnitID" )
    @JsonProperty( "RESettlementUnitID" )
    @Nullable
    @ODataField( odataName = "RESettlementUnitID" )
    private String rESettlementUnitID;
    /**
     * Use with available fluent helpers to apply the <b>RESettlementUnitID</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<String> RE_SETTLEMENT_UNIT_ID =
        new FinPlanningEntryItemTPField<String>("RESettlementUnitID");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SettlementReferenceDate</b>
     * </p>
     *
     * @return Reference Date for Settlement
     */
    @SerializedName( "SettlementReferenceDate" )
    @JsonProperty( "SettlementReferenceDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SettlementReferenceDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime settlementReferenceDate;
    /**
     * Use with available fluent helpers to apply the <b>SettlementReferenceDate</b> field to query operations.
     *
     */
    public final static FinPlanningEntryItemTPField<LocalDateTime> SETTLEMENT_REFERENCE_DATE =
        new FinPlanningEntryItemTPField<LocalDateTime>("SettlementReferenceDate");

    @Nonnull
    @Override
    public Class<FinPlanningEntryItemTP> getType()
    {
        return FinPlanningEntryItemTP.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ID</b>
     * </p>
     *
     * @param iD
     *            The iD to set.
     */
    public void setID( @Nullable final String iD )
    {
        rememberChangedField("ID", this.iD);
        this.iD = iD;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Ledger</b>
     * </p>
     *
     * @param ledger
     *            Ledger
     */
    public void setLedger( @Nullable final String ledger )
    {
        rememberChangedField("Ledger", this.ledger);
        this.ledger = ledger;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PlanningCategory</b>
     * </p>
     *
     * @param planningCategory
     *            Plan Category
     */
    public void setPlanningCategory( @Nullable final String planningCategory )
    {
        rememberChangedField("PlanningCategory", this.planningCategory);
        this.planningCategory = planningCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LedgerFiscalYear</b>
     * </p>
     *
     * @param ledgerFiscalYear
     *            Fiscal Year of Ledger
     */
    public void setLedgerFiscalYear( @Nullable final String ledgerFiscalYear )
    {
        rememberChangedField("LedgerFiscalYear", this.ledgerFiscalYear);
        this.ledgerFiscalYear = ledgerFiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @param gLAccount
     *            G/L Account
     */
    public void setGLAccount( @Nullable final String gLAccount )
    {
        rememberChangedField("GLAccount", this.gLAccount);
        this.gLAccount = gLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FinancialTransactionType</b>
     * </p>
     *
     * @param financialTransactionType
     *            Transaction type
     */
    public void setFinancialTransactionType( @Nullable final String financialTransactionType )
    {
        rememberChangedField("FinancialTransactionType", this.financialTransactionType);
        this.financialTransactionType = financialTransactionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @param functionalArea
     *            Functional Area
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @param segment
     *            Segment for Segmental Reporting
     */
    public void setSegment( @Nullable final String segment )
    {
        rememberChangedField("Segment", this.segment);
        this.segment = segment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostCenter</b>
     * </p>
     *
     * @param partnerCostCenter
     *            Partner Cost Center
     */
    public void setPartnerCostCenter( @Nullable final String partnerCostCenter )
    {
        rememberChangedField("PartnerCostCenter", this.partnerCostCenter);
        this.partnerCostCenter = partnerCostCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProfitCenter</b>
     * </p>
     *
     * @param partnerProfitCenter
     *            Partner Profit Center
     */
    public void setPartnerProfitCenter( @Nullable final String partnerProfitCenter )
    {
        rememberChangedField("PartnerProfitCenter", this.partnerProfitCenter);
        this.partnerProfitCenter = partnerProfitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunctionalArea</b>
     * </p>
     *
     * @param partnerFunctionalArea
     *            Partner Functional Area
     */
    public void setPartnerFunctionalArea( @Nullable final String partnerFunctionalArea )
    {
        rememberChangedField("PartnerFunctionalArea", this.partnerFunctionalArea);
        this.partnerFunctionalArea = partnerFunctionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBusinessArea</b>
     * </p>
     *
     * @param partnerBusinessArea
     *            Partner Business Area
     */
    public void setPartnerBusinessArea( @Nullable final String partnerBusinessArea )
    {
        rememberChangedField("PartnerBusinessArea", this.partnerBusinessArea);
        this.partnerBusinessArea = partnerBusinessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompany</b>
     * </p>
     *
     * @param partnerCompany
     *            Company ID of Trading Partner
     */
    public void setPartnerCompany( @Nullable final String partnerCompany )
    {
        rememberChangedField("PartnerCompany", this.partnerCompany);
        this.partnerCompany = partnerCompany;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSegment</b>
     * </p>
     *
     * @param partnerSegment
     *            Partner Segment for Segmental Reporting
     */
    public void setPartnerSegment( @Nullable final String partnerSegment )
    {
        rememberChangedField("PartnerSegment", this.partnerSegment);
        this.partnerSegment = partnerSegment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FixedVariableType</b>
     * </p>
     *
     * @param fixedVariableType
     *            Amount is of Type Fixed or Variable
     */
    public void setFixedVariableType( @Nullable final String fixedVariableType )
    {
        rememberChangedField("FixedVariableType", this.fixedVariableType);
        this.fixedVariableType = fixedVariableType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            Transaction Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInTransactionCurrency</b>
     * </p>
     *
     * @param amountInTransactionCurrency
     *            Amount in Transaction Currency
     */
    public void setAmountInTransactionCurrency( @Nullable final BigDecimal amountInTransactionCurrency )
    {
        rememberChangedField("AmountInTransactionCurrency", this.amountInTransactionCurrency);
        this.amountInTransactionCurrency = amountInTransactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FixedAmountInTransCrcy</b>
     * </p>
     *
     * @param fixedAmountInTransCrcy
     *            Fixed Amount in Transaction Currency
     */
    public void setFixedAmountInTransCrcy( @Nullable final BigDecimal fixedAmountInTransCrcy )
    {
        rememberChangedField("FixedAmountInTransCrcy", this.fixedAmountInTransCrcy);
        this.fixedAmountInTransCrcy = fixedAmountInTransCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     *
     * @param companyCodeCurrency
     *            Company Code Currency
     */
    public void setCompanyCodeCurrency( @Nullable final String companyCodeCurrency )
    {
        rememberChangedField("CompanyCodeCurrency", this.companyCodeCurrency);
        this.companyCodeCurrency = companyCodeCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInCompanyCodeCurrency</b>
     * </p>
     *
     * @param amountInCompanyCodeCurrency
     *            Amount in Company Code Currency
     */
    public void setAmountInCompanyCodeCurrency( @Nullable final BigDecimal amountInCompanyCodeCurrency )
    {
        rememberChangedField("AmountInCompanyCodeCurrency", this.amountInCompanyCodeCurrency);
        this.amountInCompanyCodeCurrency = amountInCompanyCodeCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FixedAmountInCoCodeCrcy</b>
     * </p>
     *
     * @param fixedAmountInCoCodeCrcy
     *            Fixed Amount in Company Currency
     */
    public void setFixedAmountInCoCodeCrcy( @Nullable final BigDecimal fixedAmountInCoCodeCrcy )
    {
        rememberChangedField("FixedAmountInCoCodeCrcy", this.fixedAmountInCoCodeCrcy);
        this.fixedAmountInCoCodeCrcy = fixedAmountInCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GlobalCurrency</b>
     * </p>
     *
     * @param globalCurrency
     *            Global Currency
     */
    public void setGlobalCurrency( @Nullable final String globalCurrency )
    {
        rememberChangedField("GlobalCurrency", this.globalCurrency);
        this.globalCurrency = globalCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInGlobalCurrency</b>
     * </p>
     *
     * @param amountInGlobalCurrency
     *            Amount in Global Currency
     */
    public void setAmountInGlobalCurrency( @Nullable final BigDecimal amountInGlobalCurrency )
    {
        rememberChangedField("AmountInGlobalCurrency", this.amountInGlobalCurrency);
        this.amountInGlobalCurrency = amountInGlobalCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FixedAmountInGlobalCrcy</b>
     * </p>
     *
     * @param fixedAmountInGlobalCrcy
     *            Fixed Amount in Global Currency
     */
    public void setFixedAmountInGlobalCrcy( @Nullable final BigDecimal fixedAmountInGlobalCrcy )
    {
        rememberChangedField("FixedAmountInGlobalCrcy", this.fixedAmountInGlobalCrcy);
        this.fixedAmountInGlobalCrcy = fixedAmountInGlobalCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ControllingObjectCurrency</b>
     * </p>
     *
     * @param controllingObjectCurrency
     *            CO Object Currency
     */
    public void setControllingObjectCurrency( @Nullable final String controllingObjectCurrency )
    {
        rememberChangedField("ControllingObjectCurrency", this.controllingObjectCurrency);
        this.controllingObjectCurrency = controllingObjectCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInObjectCurrency</b>
     * </p>
     *
     * @param amountInObjectCurrency
     *            Amount in CO Object Currency
     */
    public void setAmountInObjectCurrency( @Nullable final BigDecimal amountInObjectCurrency )
    {
        rememberChangedField("AmountInObjectCurrency", this.amountInObjectCurrency);
        this.amountInObjectCurrency = amountInObjectCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalCurrency</b>
     * </p>
     *
     * @param functionalCurrency
     *            Functional Currency
     */
    public void setFunctionalCurrency( @Nullable final String functionalCurrency )
    {
        rememberChangedField("FunctionalCurrency", this.functionalCurrency);
        this.functionalCurrency = functionalCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFunctionalCurrency</b>
     * </p>
     *
     * @param amountInFunctionalCurrency
     *            Amount in Functional Currency
     */
    public void setAmountInFunctionalCurrency( @Nullable final BigDecimal amountInFunctionalCurrency )
    {
        rememberChangedField("AmountInFunctionalCurrency", this.amountInFunctionalCurrency);
        this.amountInFunctionalCurrency = amountInFunctionalCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CostSourceUnit</b>
     * </p>
     *
     * @param costSourceUnit
     *            Unit of Measure
     */
    public void setCostSourceUnit( @Nullable final String costSourceUnit )
    {
        rememberChangedField("CostSourceUnit", this.costSourceUnit);
        this.costSourceUnit = costSourceUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ValuationQuantity</b>
     * </p>
     *
     * @param valuationQuantity
     *            Valuation Quantity
     */
    public void setValuationQuantity( @Nullable final BigDecimal valuationQuantity )
    {
        rememberChangedField("ValuationQuantity", this.valuationQuantity);
        this.valuationQuantity = valuationQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ValuationFixedQuantity</b>
     * </p>
     *
     * @param valuationFixedQuantity
     *            Valuation Fixed Quantity
     */
    public void setValuationFixedQuantity( @Nullable final BigDecimal valuationFixedQuantity )
    {
        rememberChangedField("ValuationFixedQuantity", this.valuationFixedQuantity);
        this.valuationFixedQuantity = valuationFixedQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceQuantityUnit</b>
     * </p>
     *
     * @param referenceQuantityUnit
     *            Unit of Measure for Reference Quantity
     */
    public void setReferenceQuantityUnit( @Nullable final String referenceQuantityUnit )
    {
        rememberChangedField("ReferenceQuantityUnit", this.referenceQuantityUnit);
        this.referenceQuantityUnit = referenceQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceQuantity</b>
     * </p>
     *
     * @param referenceQuantity
     *            Reference quantity
     */
    public void setReferenceQuantity( @Nullable final BigDecimal referenceQuantity )
    {
        rememberChangedField("ReferenceQuantity", this.referenceQuantity);
        this.referenceQuantity = referenceQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency1</b>
     * </p>
     *
     * @param freeDefinedCurrency1
     *            Freely Defined Currency 1
     */
    public void setFreeDefinedCurrency1( @Nullable final String freeDefinedCurrency1 )
    {
        rememberChangedField("FreeDefinedCurrency1", this.freeDefinedCurrency1);
        this.freeDefinedCurrency1 = freeDefinedCurrency1;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency1</b>
     * </p>
     *
     * @param amountInFreeDefinedCurrency1
     *            Amount in Freely Defined Currency 1
     */
    public void setAmountInFreeDefinedCurrency1( @Nullable final BigDecimal amountInFreeDefinedCurrency1 )
    {
        rememberChangedField("AmountInFreeDefinedCurrency1", this.amountInFreeDefinedCurrency1);
        this.amountInFreeDefinedCurrency1 = amountInFreeDefinedCurrency1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency2</b>
     * </p>
     *
     * @param freeDefinedCurrency2
     *            Freely Defined Currency 2
     */
    public void setFreeDefinedCurrency2( @Nullable final String freeDefinedCurrency2 )
    {
        rememberChangedField("FreeDefinedCurrency2", this.freeDefinedCurrency2);
        this.freeDefinedCurrency2 = freeDefinedCurrency2;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency2</b>
     * </p>
     *
     * @param amountInFreeDefinedCurrency2
     *            Amount in Freely Defined Currency 2
     */
    public void setAmountInFreeDefinedCurrency2( @Nullable final BigDecimal amountInFreeDefinedCurrency2 )
    {
        rememberChangedField("AmountInFreeDefinedCurrency2", this.amountInFreeDefinedCurrency2);
        this.amountInFreeDefinedCurrency2 = amountInFreeDefinedCurrency2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency3</b>
     * </p>
     *
     * @param freeDefinedCurrency3
     *            Freely Defined Currency 3
     */
    public void setFreeDefinedCurrency3( @Nullable final String freeDefinedCurrency3 )
    {
        rememberChangedField("FreeDefinedCurrency3", this.freeDefinedCurrency3);
        this.freeDefinedCurrency3 = freeDefinedCurrency3;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency3</b>
     * </p>
     *
     * @param amountInFreeDefinedCurrency3
     *            Amount in Freely Defined Currency 3
     */
    public void setAmountInFreeDefinedCurrency3( @Nullable final BigDecimal amountInFreeDefinedCurrency3 )
    {
        rememberChangedField("AmountInFreeDefinedCurrency3", this.amountInFreeDefinedCurrency3);
        this.amountInFreeDefinedCurrency3 = amountInFreeDefinedCurrency3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency4</b>
     * </p>
     *
     * @param freeDefinedCurrency4
     *            Freely Defined Currency 4
     */
    public void setFreeDefinedCurrency4( @Nullable final String freeDefinedCurrency4 )
    {
        rememberChangedField("FreeDefinedCurrency4", this.freeDefinedCurrency4);
        this.freeDefinedCurrency4 = freeDefinedCurrency4;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency4</b>
     * </p>
     *
     * @param amountInFreeDefinedCurrency4
     *            Amount in Freely Defined Currency 4
     */
    public void setAmountInFreeDefinedCurrency4( @Nullable final BigDecimal amountInFreeDefinedCurrency4 )
    {
        rememberChangedField("AmountInFreeDefinedCurrency4", this.amountInFreeDefinedCurrency4);
        this.amountInFreeDefinedCurrency4 = amountInFreeDefinedCurrency4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency5</b>
     * </p>
     *
     * @param freeDefinedCurrency5
     *            Freely Defined Currency 5
     */
    public void setFreeDefinedCurrency5( @Nullable final String freeDefinedCurrency5 )
    {
        rememberChangedField("FreeDefinedCurrency5", this.freeDefinedCurrency5);
        this.freeDefinedCurrency5 = freeDefinedCurrency5;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency5</b>
     * </p>
     *
     * @param amountInFreeDefinedCurrency5
     *            Amount in Freely Defined Currency 5
     */
    public void setAmountInFreeDefinedCurrency5( @Nullable final BigDecimal amountInFreeDefinedCurrency5 )
    {
        rememberChangedField("AmountInFreeDefinedCurrency5", this.amountInFreeDefinedCurrency5);
        this.amountInFreeDefinedCurrency5 = amountInFreeDefinedCurrency5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency6</b>
     * </p>
     *
     * @param freeDefinedCurrency6
     *            Freely Defined Currency 6
     */
    public void setFreeDefinedCurrency6( @Nullable final String freeDefinedCurrency6 )
    {
        rememberChangedField("FreeDefinedCurrency6", this.freeDefinedCurrency6);
        this.freeDefinedCurrency6 = freeDefinedCurrency6;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency6</b>
     * </p>
     *
     * @param amountInFreeDefinedCurrency6
     *            Amount in Freely Defined Currency 6
     */
    public void setAmountInFreeDefinedCurrency6( @Nullable final BigDecimal amountInFreeDefinedCurrency6 )
    {
        rememberChangedField("AmountInFreeDefinedCurrency6", this.amountInFreeDefinedCurrency6);
        this.amountInFreeDefinedCurrency6 = amountInFreeDefinedCurrency6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency7</b>
     * </p>
     *
     * @param freeDefinedCurrency7
     *            Freely Defined Currency 7
     */
    public void setFreeDefinedCurrency7( @Nullable final String freeDefinedCurrency7 )
    {
        rememberChangedField("FreeDefinedCurrency7", this.freeDefinedCurrency7);
        this.freeDefinedCurrency7 = freeDefinedCurrency7;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency7</b>
     * </p>
     *
     * @param amountInFreeDefinedCurrency7
     *            Amount in Freely Defined Currency 7
     */
    public void setAmountInFreeDefinedCurrency7( @Nullable final BigDecimal amountInFreeDefinedCurrency7 )
    {
        rememberChangedField("AmountInFreeDefinedCurrency7", this.amountInFreeDefinedCurrency7);
        this.amountInFreeDefinedCurrency7 = amountInFreeDefinedCurrency7;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency8</b>
     * </p>
     *
     * @param freeDefinedCurrency8
     *            Freely Defined Currency 8
     */
    public void setFreeDefinedCurrency8( @Nullable final String freeDefinedCurrency8 )
    {
        rememberChangedField("FreeDefinedCurrency8", this.freeDefinedCurrency8);
        this.freeDefinedCurrency8 = freeDefinedCurrency8;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency8</b>
     * </p>
     *
     * @param amountInFreeDefinedCurrency8
     *            Amount in Freely Defined Currency 8
     */
    public void setAmountInFreeDefinedCurrency8( @Nullable final BigDecimal amountInFreeDefinedCurrency8 )
    {
        rememberChangedField("AmountInFreeDefinedCurrency8", this.amountInFreeDefinedCurrency8);
        this.amountInFreeDefinedCurrency8 = amountInFreeDefinedCurrency8;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriod</b>
     * </p>
     *
     * @param fiscalPeriod
     *            Fiscal Period
     */
    public void setFiscalPeriod( @Nullable final String fiscalPeriod )
    {
        rememberChangedField("FiscalPeriod", this.fiscalPeriod);
        this.fiscalPeriod = fiscalPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearVariant</b>
     * </p>
     *
     * @param fiscalYearVariant
     *            Fiscal Year Variant
     */
    public void setFiscalYearVariant( @Nullable final String fiscalYearVariant )
    {
        rememberChangedField("FiscalYearVariant", this.fiscalYearVariant);
        this.fiscalYearVariant = fiscalYearVariant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearPeriod</b>
     * </p>
     *
     * @param fiscalYearPeriod
     *            The fiscalYearPeriod to set.
     */
    public void setFiscalYearPeriod( @Nullable final String fiscalYearPeriod )
    {
        rememberChangedField("FiscalYearPeriod", this.fiscalYearPeriod);
        this.fiscalYearPeriod = fiscalYearPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @param chartOfAccounts
     *            Chart of Accounts
     */
    public void setChartOfAccounts( @Nullable final String chartOfAccounts )
    {
        rememberChangedField("ChartOfAccounts", this.chartOfAccounts);
        this.chartOfAccounts = chartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer Number
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ControllingDebitCreditCode</b>
     * </p>
     *
     * @param controllingDebitCreditCode
     *            CO Debit/Credit Indicator
     */
    public void setControllingDebitCreditCode( @Nullable final String controllingDebitCreditCode )
    {
        rememberChangedField("ControllingDebitCreditCode", this.controllingDebitCreditCode);
        this.controllingDebitCreditCode = controllingDebitCreditCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Project</b>
     * </p>
     *
     * @param project
     *            Project Definition
     */
    public void setProject( @Nullable final String project )
    {
        rememberChangedField("Project", this.project);
        this.project = project;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @param wBSElement
     *            Work Breakdown Structure Element (WBS Element)
     */
    public void setWBSElement( @Nullable final String wBSElement )
    {
        rememberChangedField("WBSElement", this.wBSElement);
        this.wBSElement = wBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompanyCode</b>
     * </p>
     *
     * @param partnerCompanyCode
     *            Company Code of Partner
     */
    public void setPartnerCompanyCode( @Nullable final String partnerCompanyCode )
    {
        rememberChangedField("PartnerCompanyCode", this.partnerCompanyCode);
        this.partnerCompanyCode = partnerCompanyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType</b>
     * </p>
     *
     * @param costCtrActivityType
     *            Activity Type
     */
    public void setCostCtrActivityType( @Nullable final String costCtrActivityType )
    {
        rememberChangedField("CostCtrActivityType", this.costCtrActivityType);
        this.costCtrActivityType = costCtrActivityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @param orderID
     *            Order ID
     */
    public void setOrderID( @Nullable final String orderID )
    {
        rememberChangedField("OrderID", this.orderID);
        this.orderID = orderID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PartnerOrder</b>
     * </p>
     *
     * @param partnerOrder
     *            Partner Order
     */
    public void setPartnerOrder( @Nullable final String partnerOrder )
    {
        rememberChangedField("PartnerOrder", this.partnerOrder);
        this.partnerOrder = partnerOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostCtrActivityType</b>
     * </p>
     *
     * @param partnerCostCtrActivityType
     *            Partner Cost Center Activity Type
     */
    public void setPartnerCostCtrActivityType( @Nullable final String partnerCostCtrActivityType )
    {
        rememberChangedField("PartnerCostCtrActivityType", this.partnerCostCtrActivityType);
        this.partnerCostCtrActivityType = partnerCostCtrActivityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>PartnerProject</b>
     * </p>
     *
     * @param partnerProject
     *            Partner Project
     */
    public void setPartnerProject( @Nullable final String partnerProject )
    {
        rememberChangedField("PartnerProject", this.partnerProject);
        this.partnerProject = partnerProject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>PartnerWBSElement</b>
     * </p>
     *
     * @param partnerWBSElement
     *            Partner WBS Element
     */
    public void setPartnerWBSElement( @Nullable final String partnerWBSElement )
    {
        rememberChangedField("PartnerWBSElement", this.partnerWBSElement);
        this.partnerWBSElement = partnerWBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @param division
     *            Division
     */
    public void setDivision( @Nullable final String division )
    {
        rememberChangedField("Division", this.division);
        this.division = division;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SoldMaterial</b>
     * </p>
     *
     * @param soldMaterial
     *            Product Sold
     */
    public void setSoldMaterial( @Nullable final String soldMaterial )
    {
        rememberChangedField("SoldMaterial", this.soldMaterial);
        this.soldMaterial = soldMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Product Sold Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup</b>
     * </p>
     *
     * @param customerGroup
     *            Customer Group
     */
    public void setCustomerGroup( @Nullable final String customerGroup )
    {
        rememberChangedField("CustomerGroup", this.customerGroup);
        this.customerGroup = customerGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CustomerSupplierCountry</b>
     * </p>
     *
     * @param customerSupplierCountry
     *            Country/Region of Customer or Supplier
     */
    public void setCustomerSupplierCountry( @Nullable final String customerSupplierCountry )
    {
        rememberChangedField("CustomerSupplierCountry", this.customerSupplierCountry);
        this.customerSupplierCountry = customerSupplierCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerSupplierIndustry</b>
     * </p>
     *
     * @param customerSupplierIndustry
     *            Industry Key
     */
    public void setCustomerSupplierIndustry( @Nullable final String customerSupplierIndustry )
    {
        rememberChangedField("CustomerSupplierIndustry", this.customerSupplierIndustry);
        this.customerSupplierIndustry = customerSupplierIndustry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDistrict</b>
     * </p>
     *
     * @param salesDistrict
     *            Sales District
     */
    public void setSalesDistrict( @Nullable final String salesDistrict )
    {
        rememberChangedField("SalesDistrict", this.salesDistrict);
        this.salesDistrict = salesDistrict;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FinancialManagementArea</b>
     * </p>
     *
     * @param financialManagementArea
     *            Financial Management Area
     */
    public void setFinancialManagementArea( @Nullable final String financialManagementArea )
    {
        rememberChangedField("FinancialManagementArea", this.financialManagementArea);
        this.financialManagementArea = financialManagementArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @param fund
     *            Fund
     */
    public void setFund( @Nullable final String fund )
    {
        rememberChangedField("Fund", this.fund);
        this.fund = fund;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @param grantID
     *            Grant
     */
    public void setGrantID( @Nullable final String grantID )
    {
        rememberChangedField("GrantID", this.grantID);
        this.grantID = grantID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriod</b>
     * </p>
     *
     * @param budgetPeriod
     *            Budget Period
     */
    public void setBudgetPeriod( @Nullable final String budgetPeriod )
    {
        rememberChangedField("BudgetPeriod", this.budgetPeriod);
        this.budgetPeriod = budgetPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BudgetProcess</b>
     * </p>
     *
     * @param budgetProcess
     *            Budget Process Type
     */
    public void setBudgetProcess( @Nullable final String budgetProcess )
    {
        rememberChangedField("BudgetProcess", this.budgetProcess);
        this.budgetProcess = budgetProcess;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BudgetingType</b>
     * </p>
     *
     * @param budgetingType
     *            Budget Type (Subcategory)
     */
    public void setBudgetingType( @Nullable final String budgetingType )
    {
        rememberChangedField("BudgetingType", this.budgetingType);
        this.budgetingType = budgetingType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SponsoredProgram</b>
     * </p>
     *
     * @param sponsoredProgram
     *            Sponsored Program
     */
    public void setSponsoredProgram( @Nullable final String sponsoredProgram )
    {
        rememberChangedField("SponsoredProgram", this.sponsoredProgram);
        this.sponsoredProgram = sponsoredProgram;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SponsoredClass</b>
     * </p>
     *
     * @param sponsoredClass
     *            Sponsored Class
     */
    public void setSponsoredClass( @Nullable final String sponsoredClass )
    {
        rememberChangedField("SponsoredClass", this.sponsoredClass);
        this.sponsoredClass = sponsoredClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GteeMBudgetValidityNumber</b>
     * </p>
     *
     * @param gteeMBudgetValidityNumber
     *            Budget Validity Number
     */
    public void setGteeMBudgetValidityNumber( @Nullable final String gteeMBudgetValidityNumber )
    {
        rememberChangedField("GteeMBudgetValidityNumber", this.gteeMBudgetValidityNumber);
        this.gteeMBudgetValidityNumber = gteeMBudgetValidityNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>REBusinessEntity</b>
     * </p>
     *
     * @param rEBusinessEntity
     *            RE Business Entity
     */
    public void setREBusinessEntity( @Nullable final String rEBusinessEntity )
    {
        rememberChangedField("REBusinessEntity", this.rEBusinessEntity);
        this.rEBusinessEntity = rEBusinessEntity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>RealEstateBuilding</b>
     * </p>
     *
     * @param realEstateBuilding
     *            Real Estate Building
     */
    public void setRealEstateBuilding( @Nullable final String realEstateBuilding )
    {
        rememberChangedField("RealEstateBuilding", this.realEstateBuilding);
        this.realEstateBuilding = realEstateBuilding;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>RealEstateProperty</b>
     * </p>
     *
     * @param realEstateProperty
     *            Real Estate Property
     */
    public void setRealEstateProperty( @Nullable final String realEstateProperty )
    {
        rememberChangedField("RealEstateProperty", this.realEstateProperty);
        this.realEstateProperty = realEstateProperty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>RERentalObject</b>
     * </p>
     *
     * @param rERentalObject
     *            RE Rental Object
     */
    public void setRERentalObject( @Nullable final String rERentalObject )
    {
        rememberChangedField("RERentalObject", this.rERentalObject);
        this.rERentalObject = rERentalObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>RealEstateContract</b>
     * </p>
     *
     * @param realEstateContract
     *            Real Estate Contract
     */
    public void setRealEstateContract( @Nullable final String realEstateContract )
    {
        rememberChangedField("RealEstateContract", this.realEstateContract);
        this.realEstateContract = realEstateContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REServiceChargeKey</b>
     * </p>
     *
     * @param rEServiceChargeKey
     *            RE Service Charge Key
     */
    public void setREServiceChargeKey( @Nullable final String rEServiceChargeKey )
    {
        rememberChangedField("REServiceChargeKey", this.rEServiceChargeKey);
        this.rEServiceChargeKey = rEServiceChargeKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>RESettlementUnitID</b>
     * </p>
     *
     * @param rESettlementUnitID
     *            RE Settlement Unit
     */
    public void setRESettlementUnitID( @Nullable final String rESettlementUnitID )
    {
        rememberChangedField("RESettlementUnitID", this.rESettlementUnitID);
        this.rESettlementUnitID = rESettlementUnitID;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SettlementReferenceDate</b>
     * </p>
     *
     * @param settlementReferenceDate
     *            Reference Date for Settlement
     */
    public void setSettlementReferenceDate( @Nullable final LocalDateTime settlementReferenceDate )
    {
        rememberChangedField("SettlementReferenceDate", this.settlementReferenceDate);
        this.settlementReferenceDate = settlementReferenceDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_FinPlanningEntryItemTP";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ID", getID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ID", getID());
        values.put("Ledger", getLedger());
        values.put("PlanningCategory", getPlanningCategory());
        values.put("LedgerFiscalYear", getLedgerFiscalYear());
        values.put("GLAccount", getGLAccount());
        values.put("CompanyCode", getCompanyCode());
        values.put("FinancialTransactionType", getFinancialTransactionType());
        values.put("CostCenter", getCostCenter());
        values.put("ProfitCenter", getProfitCenter());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("BusinessArea", getBusinessArea());
        values.put("ControllingArea", getControllingArea());
        values.put("Segment", getSegment());
        values.put("PartnerCostCenter", getPartnerCostCenter());
        values.put("PartnerProfitCenter", getPartnerProfitCenter());
        values.put("PartnerFunctionalArea", getPartnerFunctionalArea());
        values.put("PartnerBusinessArea", getPartnerBusinessArea());
        values.put("PartnerCompany", getPartnerCompany());
        values.put("PartnerSegment", getPartnerSegment());
        values.put("FixedVariableType", getFixedVariableType());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("AmountInTransactionCurrency", getAmountInTransactionCurrency());
        values.put("FixedAmountInTransCrcy", getFixedAmountInTransCrcy());
        values.put("CompanyCodeCurrency", getCompanyCodeCurrency());
        values.put("AmountInCompanyCodeCurrency", getAmountInCompanyCodeCurrency());
        values.put("FixedAmountInCoCodeCrcy", getFixedAmountInCoCodeCrcy());
        values.put("GlobalCurrency", getGlobalCurrency());
        values.put("AmountInGlobalCurrency", getAmountInGlobalCurrency());
        values.put("FixedAmountInGlobalCrcy", getFixedAmountInGlobalCrcy());
        values.put("ControllingObjectCurrency", getControllingObjectCurrency());
        values.put("AmountInObjectCurrency", getAmountInObjectCurrency());
        values.put("FunctionalCurrency", getFunctionalCurrency());
        values.put("AmountInFunctionalCurrency", getAmountInFunctionalCurrency());
        values.put("CostSourceUnit", getCostSourceUnit());
        values.put("ValuationQuantity", getValuationQuantity());
        values.put("ValuationFixedQuantity", getValuationFixedQuantity());
        values.put("ReferenceQuantityUnit", getReferenceQuantityUnit());
        values.put("ReferenceQuantity", getReferenceQuantity());
        values.put("FreeDefinedCurrency1", getFreeDefinedCurrency1());
        values.put("AmountInFreeDefinedCurrency1", getAmountInFreeDefinedCurrency1());
        values.put("FreeDefinedCurrency2", getFreeDefinedCurrency2());
        values.put("AmountInFreeDefinedCurrency2", getAmountInFreeDefinedCurrency2());
        values.put("FreeDefinedCurrency3", getFreeDefinedCurrency3());
        values.put("AmountInFreeDefinedCurrency3", getAmountInFreeDefinedCurrency3());
        values.put("FreeDefinedCurrency4", getFreeDefinedCurrency4());
        values.put("AmountInFreeDefinedCurrency4", getAmountInFreeDefinedCurrency4());
        values.put("FreeDefinedCurrency5", getFreeDefinedCurrency5());
        values.put("AmountInFreeDefinedCurrency5", getAmountInFreeDefinedCurrency5());
        values.put("FreeDefinedCurrency6", getFreeDefinedCurrency6());
        values.put("AmountInFreeDefinedCurrency6", getAmountInFreeDefinedCurrency6());
        values.put("FreeDefinedCurrency7", getFreeDefinedCurrency7());
        values.put("AmountInFreeDefinedCurrency7", getAmountInFreeDefinedCurrency7());
        values.put("FreeDefinedCurrency8", getFreeDefinedCurrency8());
        values.put("AmountInFreeDefinedCurrency8", getAmountInFreeDefinedCurrency8());
        values.put("FiscalPeriod", getFiscalPeriod());
        values.put("FiscalYearVariant", getFiscalYearVariant());
        values.put("FiscalYearPeriod", getFiscalYearPeriod());
        values.put("ChartOfAccounts", getChartOfAccounts());
        values.put("Plant", getPlant());
        values.put("Customer", getCustomer());
        values.put("ControllingDebitCreditCode", getControllingDebitCreditCode());
        values.put("Project", getProject());
        values.put("WBSElement", getWBSElement());
        values.put("PartnerCompanyCode", getPartnerCompanyCode());
        values.put("CostCtrActivityType", getCostCtrActivityType());
        values.put("OrderID", getOrderID());
        values.put("PartnerOrder", getPartnerOrder());
        values.put("PartnerCostCtrActivityType", getPartnerCostCtrActivityType());
        values.put("PartnerProject", getPartnerProject());
        values.put("PartnerWBSElement", getPartnerWBSElement());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("Division", getDivision());
        values.put("SoldMaterial", getSoldMaterial());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("CustomerGroup", getCustomerGroup());
        values.put("CustomerSupplierCountry", getCustomerSupplierCountry());
        values.put("CustomerSupplierIndustry", getCustomerSupplierIndustry());
        values.put("SalesDistrict", getSalesDistrict());
        values.put("FinancialManagementArea", getFinancialManagementArea());
        values.put("Fund", getFund());
        values.put("GrantID", getGrantID());
        values.put("BudgetPeriod", getBudgetPeriod());
        values.put("BudgetProcess", getBudgetProcess());
        values.put("BudgetingType", getBudgetingType());
        values.put("SponsoredProgram", getSponsoredProgram());
        values.put("SponsoredClass", getSponsoredClass());
        values.put("GteeMBudgetValidityNumber", getGteeMBudgetValidityNumber());
        values.put("REBusinessEntity", getREBusinessEntity());
        values.put("RealEstateBuilding", getRealEstateBuilding());
        values.put("RealEstateProperty", getRealEstateProperty());
        values.put("RERentalObject", getRERentalObject());
        values.put("RealEstateContract", getRealEstateContract());
        values.put("REServiceChargeKey", getREServiceChargeKey());
        values.put("RESettlementUnitID", getRESettlementUnitID());
        values.put("SettlementReferenceDate", getSettlementReferenceDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ID") ) {
                final Object value = values.remove("ID");
                if( (value == null) || (!value.equals(getID())) ) {
                    setID(((String) value));
                }
            }
            if( values.containsKey("Ledger") ) {
                final Object value = values.remove("Ledger");
                if( (value == null) || (!value.equals(getLedger())) ) {
                    setLedger(((String) value));
                }
            }
            if( values.containsKey("PlanningCategory") ) {
                final Object value = values.remove("PlanningCategory");
                if( (value == null) || (!value.equals(getPlanningCategory())) ) {
                    setPlanningCategory(((String) value));
                }
            }
            if( values.containsKey("LedgerFiscalYear") ) {
                final Object value = values.remove("LedgerFiscalYear");
                if( (value == null) || (!value.equals(getLedgerFiscalYear())) ) {
                    setLedgerFiscalYear(((String) value));
                }
            }
            if( values.containsKey("GLAccount") ) {
                final Object value = values.remove("GLAccount");
                if( (value == null) || (!value.equals(getGLAccount())) ) {
                    setGLAccount(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("FinancialTransactionType") ) {
                final Object value = values.remove("FinancialTransactionType");
                if( (value == null) || (!value.equals(getFinancialTransactionType())) ) {
                    setFinancialTransactionType(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("Segment") ) {
                final Object value = values.remove("Segment");
                if( (value == null) || (!value.equals(getSegment())) ) {
                    setSegment(((String) value));
                }
            }
            if( values.containsKey("PartnerCostCenter") ) {
                final Object value = values.remove("PartnerCostCenter");
                if( (value == null) || (!value.equals(getPartnerCostCenter())) ) {
                    setPartnerCostCenter(((String) value));
                }
            }
            if( values.containsKey("PartnerProfitCenter") ) {
                final Object value = values.remove("PartnerProfitCenter");
                if( (value == null) || (!value.equals(getPartnerProfitCenter())) ) {
                    setPartnerProfitCenter(((String) value));
                }
            }
            if( values.containsKey("PartnerFunctionalArea") ) {
                final Object value = values.remove("PartnerFunctionalArea");
                if( (value == null) || (!value.equals(getPartnerFunctionalArea())) ) {
                    setPartnerFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("PartnerBusinessArea") ) {
                final Object value = values.remove("PartnerBusinessArea");
                if( (value == null) || (!value.equals(getPartnerBusinessArea())) ) {
                    setPartnerBusinessArea(((String) value));
                }
            }
            if( values.containsKey("PartnerCompany") ) {
                final Object value = values.remove("PartnerCompany");
                if( (value == null) || (!value.equals(getPartnerCompany())) ) {
                    setPartnerCompany(((String) value));
                }
            }
            if( values.containsKey("PartnerSegment") ) {
                final Object value = values.remove("PartnerSegment");
                if( (value == null) || (!value.equals(getPartnerSegment())) ) {
                    setPartnerSegment(((String) value));
                }
            }
            if( values.containsKey("FixedVariableType") ) {
                final Object value = values.remove("FixedVariableType");
                if( (value == null) || (!value.equals(getFixedVariableType())) ) {
                    setFixedVariableType(((String) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("AmountInTransactionCurrency") ) {
                final Object value = values.remove("AmountInTransactionCurrency");
                if( (value == null) || (!value.equals(getAmountInTransactionCurrency())) ) {
                    setAmountInTransactionCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("FixedAmountInTransCrcy") ) {
                final Object value = values.remove("FixedAmountInTransCrcy");
                if( (value == null) || (!value.equals(getFixedAmountInTransCrcy())) ) {
                    setFixedAmountInTransCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("CompanyCodeCurrency") ) {
                final Object value = values.remove("CompanyCodeCurrency");
                if( (value == null) || (!value.equals(getCompanyCodeCurrency())) ) {
                    setCompanyCodeCurrency(((String) value));
                }
            }
            if( values.containsKey("AmountInCompanyCodeCurrency") ) {
                final Object value = values.remove("AmountInCompanyCodeCurrency");
                if( (value == null) || (!value.equals(getAmountInCompanyCodeCurrency())) ) {
                    setAmountInCompanyCodeCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("FixedAmountInCoCodeCrcy") ) {
                final Object value = values.remove("FixedAmountInCoCodeCrcy");
                if( (value == null) || (!value.equals(getFixedAmountInCoCodeCrcy())) ) {
                    setFixedAmountInCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("GlobalCurrency") ) {
                final Object value = values.remove("GlobalCurrency");
                if( (value == null) || (!value.equals(getGlobalCurrency())) ) {
                    setGlobalCurrency(((String) value));
                }
            }
            if( values.containsKey("AmountInGlobalCurrency") ) {
                final Object value = values.remove("AmountInGlobalCurrency");
                if( (value == null) || (!value.equals(getAmountInGlobalCurrency())) ) {
                    setAmountInGlobalCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("FixedAmountInGlobalCrcy") ) {
                final Object value = values.remove("FixedAmountInGlobalCrcy");
                if( (value == null) || (!value.equals(getFixedAmountInGlobalCrcy())) ) {
                    setFixedAmountInGlobalCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("ControllingObjectCurrency") ) {
                final Object value = values.remove("ControllingObjectCurrency");
                if( (value == null) || (!value.equals(getControllingObjectCurrency())) ) {
                    setControllingObjectCurrency(((String) value));
                }
            }
            if( values.containsKey("AmountInObjectCurrency") ) {
                final Object value = values.remove("AmountInObjectCurrency");
                if( (value == null) || (!value.equals(getAmountInObjectCurrency())) ) {
                    setAmountInObjectCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("FunctionalCurrency") ) {
                final Object value = values.remove("FunctionalCurrency");
                if( (value == null) || (!value.equals(getFunctionalCurrency())) ) {
                    setFunctionalCurrency(((String) value));
                }
            }
            if( values.containsKey("AmountInFunctionalCurrency") ) {
                final Object value = values.remove("AmountInFunctionalCurrency");
                if( (value == null) || (!value.equals(getAmountInFunctionalCurrency())) ) {
                    setAmountInFunctionalCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CostSourceUnit") ) {
                final Object value = values.remove("CostSourceUnit");
                if( (value == null) || (!value.equals(getCostSourceUnit())) ) {
                    setCostSourceUnit(((String) value));
                }
            }
            if( values.containsKey("ValuationQuantity") ) {
                final Object value = values.remove("ValuationQuantity");
                if( (value == null) || (!value.equals(getValuationQuantity())) ) {
                    setValuationQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ValuationFixedQuantity") ) {
                final Object value = values.remove("ValuationFixedQuantity");
                if( (value == null) || (!value.equals(getValuationFixedQuantity())) ) {
                    setValuationFixedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ReferenceQuantityUnit") ) {
                final Object value = values.remove("ReferenceQuantityUnit");
                if( (value == null) || (!value.equals(getReferenceQuantityUnit())) ) {
                    setReferenceQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ReferenceQuantity") ) {
                final Object value = values.remove("ReferenceQuantity");
                if( (value == null) || (!value.equals(getReferenceQuantity())) ) {
                    setReferenceQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency1") ) {
                final Object value = values.remove("FreeDefinedCurrency1");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency1())) ) {
                    setFreeDefinedCurrency1(((String) value));
                }
            }
            if( values.containsKey("AmountInFreeDefinedCurrency1") ) {
                final Object value = values.remove("AmountInFreeDefinedCurrency1");
                if( (value == null) || (!value.equals(getAmountInFreeDefinedCurrency1())) ) {
                    setAmountInFreeDefinedCurrency1(((BigDecimal) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency2") ) {
                final Object value = values.remove("FreeDefinedCurrency2");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency2())) ) {
                    setFreeDefinedCurrency2(((String) value));
                }
            }
            if( values.containsKey("AmountInFreeDefinedCurrency2") ) {
                final Object value = values.remove("AmountInFreeDefinedCurrency2");
                if( (value == null) || (!value.equals(getAmountInFreeDefinedCurrency2())) ) {
                    setAmountInFreeDefinedCurrency2(((BigDecimal) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency3") ) {
                final Object value = values.remove("FreeDefinedCurrency3");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency3())) ) {
                    setFreeDefinedCurrency3(((String) value));
                }
            }
            if( values.containsKey("AmountInFreeDefinedCurrency3") ) {
                final Object value = values.remove("AmountInFreeDefinedCurrency3");
                if( (value == null) || (!value.equals(getAmountInFreeDefinedCurrency3())) ) {
                    setAmountInFreeDefinedCurrency3(((BigDecimal) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency4") ) {
                final Object value = values.remove("FreeDefinedCurrency4");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency4())) ) {
                    setFreeDefinedCurrency4(((String) value));
                }
            }
            if( values.containsKey("AmountInFreeDefinedCurrency4") ) {
                final Object value = values.remove("AmountInFreeDefinedCurrency4");
                if( (value == null) || (!value.equals(getAmountInFreeDefinedCurrency4())) ) {
                    setAmountInFreeDefinedCurrency4(((BigDecimal) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency5") ) {
                final Object value = values.remove("FreeDefinedCurrency5");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency5())) ) {
                    setFreeDefinedCurrency5(((String) value));
                }
            }
            if( values.containsKey("AmountInFreeDefinedCurrency5") ) {
                final Object value = values.remove("AmountInFreeDefinedCurrency5");
                if( (value == null) || (!value.equals(getAmountInFreeDefinedCurrency5())) ) {
                    setAmountInFreeDefinedCurrency5(((BigDecimal) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency6") ) {
                final Object value = values.remove("FreeDefinedCurrency6");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency6())) ) {
                    setFreeDefinedCurrency6(((String) value));
                }
            }
            if( values.containsKey("AmountInFreeDefinedCurrency6") ) {
                final Object value = values.remove("AmountInFreeDefinedCurrency6");
                if( (value == null) || (!value.equals(getAmountInFreeDefinedCurrency6())) ) {
                    setAmountInFreeDefinedCurrency6(((BigDecimal) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency7") ) {
                final Object value = values.remove("FreeDefinedCurrency7");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency7())) ) {
                    setFreeDefinedCurrency7(((String) value));
                }
            }
            if( values.containsKey("AmountInFreeDefinedCurrency7") ) {
                final Object value = values.remove("AmountInFreeDefinedCurrency7");
                if( (value == null) || (!value.equals(getAmountInFreeDefinedCurrency7())) ) {
                    setAmountInFreeDefinedCurrency7(((BigDecimal) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency8") ) {
                final Object value = values.remove("FreeDefinedCurrency8");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency8())) ) {
                    setFreeDefinedCurrency8(((String) value));
                }
            }
            if( values.containsKey("AmountInFreeDefinedCurrency8") ) {
                final Object value = values.remove("AmountInFreeDefinedCurrency8");
                if( (value == null) || (!value.equals(getAmountInFreeDefinedCurrency8())) ) {
                    setAmountInFreeDefinedCurrency8(((BigDecimal) value));
                }
            }
            if( values.containsKey("FiscalPeriod") ) {
                final Object value = values.remove("FiscalPeriod");
                if( (value == null) || (!value.equals(getFiscalPeriod())) ) {
                    setFiscalPeriod(((String) value));
                }
            }
            if( values.containsKey("FiscalYearVariant") ) {
                final Object value = values.remove("FiscalYearVariant");
                if( (value == null) || (!value.equals(getFiscalYearVariant())) ) {
                    setFiscalYearVariant(((String) value));
                }
            }
            if( values.containsKey("FiscalYearPeriod") ) {
                final Object value = values.remove("FiscalYearPeriod");
                if( (value == null) || (!value.equals(getFiscalYearPeriod())) ) {
                    setFiscalYearPeriod(((String) value));
                }
            }
            if( values.containsKey("ChartOfAccounts") ) {
                final Object value = values.remove("ChartOfAccounts");
                if( (value == null) || (!value.equals(getChartOfAccounts())) ) {
                    setChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("ControllingDebitCreditCode") ) {
                final Object value = values.remove("ControllingDebitCreditCode");
                if( (value == null) || (!value.equals(getControllingDebitCreditCode())) ) {
                    setControllingDebitCreditCode(((String) value));
                }
            }
            if( values.containsKey("Project") ) {
                final Object value = values.remove("Project");
                if( (value == null) || (!value.equals(getProject())) ) {
                    setProject(((String) value));
                }
            }
            if( values.containsKey("WBSElement") ) {
                final Object value = values.remove("WBSElement");
                if( (value == null) || (!value.equals(getWBSElement())) ) {
                    setWBSElement(((String) value));
                }
            }
            if( values.containsKey("PartnerCompanyCode") ) {
                final Object value = values.remove("PartnerCompanyCode");
                if( (value == null) || (!value.equals(getPartnerCompanyCode())) ) {
                    setPartnerCompanyCode(((String) value));
                }
            }
            if( values.containsKey("CostCtrActivityType") ) {
                final Object value = values.remove("CostCtrActivityType");
                if( (value == null) || (!value.equals(getCostCtrActivityType())) ) {
                    setCostCtrActivityType(((String) value));
                }
            }
            if( values.containsKey("OrderID") ) {
                final Object value = values.remove("OrderID");
                if( (value == null) || (!value.equals(getOrderID())) ) {
                    setOrderID(((String) value));
                }
            }
            if( values.containsKey("PartnerOrder") ) {
                final Object value = values.remove("PartnerOrder");
                if( (value == null) || (!value.equals(getPartnerOrder())) ) {
                    setPartnerOrder(((String) value));
                }
            }
            if( values.containsKey("PartnerCostCtrActivityType") ) {
                final Object value = values.remove("PartnerCostCtrActivityType");
                if( (value == null) || (!value.equals(getPartnerCostCtrActivityType())) ) {
                    setPartnerCostCtrActivityType(((String) value));
                }
            }
            if( values.containsKey("PartnerProject") ) {
                final Object value = values.remove("PartnerProject");
                if( (value == null) || (!value.equals(getPartnerProject())) ) {
                    setPartnerProject(((String) value));
                }
            }
            if( values.containsKey("PartnerWBSElement") ) {
                final Object value = values.remove("PartnerWBSElement");
                if( (value == null) || (!value.equals(getPartnerWBSElement())) ) {
                    setPartnerWBSElement(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("Division") ) {
                final Object value = values.remove("Division");
                if( (value == null) || (!value.equals(getDivision())) ) {
                    setDivision(((String) value));
                }
            }
            if( values.containsKey("SoldMaterial") ) {
                final Object value = values.remove("SoldMaterial");
                if( (value == null) || (!value.equals(getSoldMaterial())) ) {
                    setSoldMaterial(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("CustomerGroup") ) {
                final Object value = values.remove("CustomerGroup");
                if( (value == null) || (!value.equals(getCustomerGroup())) ) {
                    setCustomerGroup(((String) value));
                }
            }
            if( values.containsKey("CustomerSupplierCountry") ) {
                final Object value = values.remove("CustomerSupplierCountry");
                if( (value == null) || (!value.equals(getCustomerSupplierCountry())) ) {
                    setCustomerSupplierCountry(((String) value));
                }
            }
            if( values.containsKey("CustomerSupplierIndustry") ) {
                final Object value = values.remove("CustomerSupplierIndustry");
                if( (value == null) || (!value.equals(getCustomerSupplierIndustry())) ) {
                    setCustomerSupplierIndustry(((String) value));
                }
            }
            if( values.containsKey("SalesDistrict") ) {
                final Object value = values.remove("SalesDistrict");
                if( (value == null) || (!value.equals(getSalesDistrict())) ) {
                    setSalesDistrict(((String) value));
                }
            }
            if( values.containsKey("FinancialManagementArea") ) {
                final Object value = values.remove("FinancialManagementArea");
                if( (value == null) || (!value.equals(getFinancialManagementArea())) ) {
                    setFinancialManagementArea(((String) value));
                }
            }
            if( values.containsKey("Fund") ) {
                final Object value = values.remove("Fund");
                if( (value == null) || (!value.equals(getFund())) ) {
                    setFund(((String) value));
                }
            }
            if( values.containsKey("GrantID") ) {
                final Object value = values.remove("GrantID");
                if( (value == null) || (!value.equals(getGrantID())) ) {
                    setGrantID(((String) value));
                }
            }
            if( values.containsKey("BudgetPeriod") ) {
                final Object value = values.remove("BudgetPeriod");
                if( (value == null) || (!value.equals(getBudgetPeriod())) ) {
                    setBudgetPeriod(((String) value));
                }
            }
            if( values.containsKey("BudgetProcess") ) {
                final Object value = values.remove("BudgetProcess");
                if( (value == null) || (!value.equals(getBudgetProcess())) ) {
                    setBudgetProcess(((String) value));
                }
            }
            if( values.containsKey("BudgetingType") ) {
                final Object value = values.remove("BudgetingType");
                if( (value == null) || (!value.equals(getBudgetingType())) ) {
                    setBudgetingType(((String) value));
                }
            }
            if( values.containsKey("SponsoredProgram") ) {
                final Object value = values.remove("SponsoredProgram");
                if( (value == null) || (!value.equals(getSponsoredProgram())) ) {
                    setSponsoredProgram(((String) value));
                }
            }
            if( values.containsKey("SponsoredClass") ) {
                final Object value = values.remove("SponsoredClass");
                if( (value == null) || (!value.equals(getSponsoredClass())) ) {
                    setSponsoredClass(((String) value));
                }
            }
            if( values.containsKey("GteeMBudgetValidityNumber") ) {
                final Object value = values.remove("GteeMBudgetValidityNumber");
                if( (value == null) || (!value.equals(getGteeMBudgetValidityNumber())) ) {
                    setGteeMBudgetValidityNumber(((String) value));
                }
            }
            if( values.containsKey("REBusinessEntity") ) {
                final Object value = values.remove("REBusinessEntity");
                if( (value == null) || (!value.equals(getREBusinessEntity())) ) {
                    setREBusinessEntity(((String) value));
                }
            }
            if( values.containsKey("RealEstateBuilding") ) {
                final Object value = values.remove("RealEstateBuilding");
                if( (value == null) || (!value.equals(getRealEstateBuilding())) ) {
                    setRealEstateBuilding(((String) value));
                }
            }
            if( values.containsKey("RealEstateProperty") ) {
                final Object value = values.remove("RealEstateProperty");
                if( (value == null) || (!value.equals(getRealEstateProperty())) ) {
                    setRealEstateProperty(((String) value));
                }
            }
            if( values.containsKey("RERentalObject") ) {
                final Object value = values.remove("RERentalObject");
                if( (value == null) || (!value.equals(getRERentalObject())) ) {
                    setRERentalObject(((String) value));
                }
            }
            if( values.containsKey("RealEstateContract") ) {
                final Object value = values.remove("RealEstateContract");
                if( (value == null) || (!value.equals(getRealEstateContract())) ) {
                    setRealEstateContract(((String) value));
                }
            }
            if( values.containsKey("REServiceChargeKey") ) {
                final Object value = values.remove("REServiceChargeKey");
                if( (value == null) || (!value.equals(getREServiceChargeKey())) ) {
                    setREServiceChargeKey(((String) value));
                }
            }
            if( values.containsKey("RESettlementUnitID") ) {
                final Object value = values.remove("RESettlementUnitID");
                if( (value == null) || (!value.equals(getRESettlementUnitID())) ) {
                    setRESettlementUnitID(((String) value));
                }
            }
            if( values.containsKey("SettlementReferenceDate") ) {
                final Object value = values.remove("SettlementReferenceDate");
                if( (value == null) || (!value.equals(getSettlementReferenceDate())) ) {
                    setSettlementReferenceDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> FinPlanningEntryItemTPField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FinPlanningEntryItemTPField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FinPlanningEntryItemTPField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FinPlanningEntryItemTPField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.FinancialPlanningDataService.DEFAULT_SERVICE_PATH);
    }

}
