/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.field.FinancialPlanDataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.link.FinancialPlanDataLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.selectable.FinancialPlanDataSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>FinancialPlanDataType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FinancialPlanData extends VdmEntity<FinancialPlanData>
{

    /**
     * Selector for all available fields of FinancialPlanData.
     *
     */
    public final static FinancialPlanDataSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PlanDataAggrgnLvlFieldsString</b>
     * </p>
     *
     * @return The planDataAggrgnLvlFieldsString contained in this entity.
     */
    @Key
    @SerializedName( "PlanDataAggrgnLvlFieldsString" )
    @JsonProperty( "PlanDataAggrgnLvlFieldsString" )
    @Nullable
    @ODataField( odataName = "PlanDataAggrgnLvlFieldsString" )
    private String planDataAggrgnLvlFieldsString;
    /**
     * Use with available fluent helpers to apply the <b>PlanDataAggrgnLvlFieldsString</b> field to query operations.
     *
     */
    public final static FinancialPlanDataField<String> PLAN_DATA_AGGRGN_LVL_FIELDS_STRING =
        new FinancialPlanDataField<String>("PlanDataAggrgnLvlFieldsString");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PlanDataRplcScopeFieldsString</b>
     * </p>
     *
     * @return The planDataRplcScopeFieldsString contained in this entity.
     */
    @SerializedName( "PlanDataRplcScopeFieldsString" )
    @JsonProperty( "PlanDataRplcScopeFieldsString" )
    @Nullable
    @ODataField( odataName = "PlanDataRplcScopeFieldsString" )
    private String planDataRplcScopeFieldsString;
    /**
     * Use with available fluent helpers to apply the <b>PlanDataRplcScopeFieldsString</b> field to query operations.
     *
     */
    public final static FinancialPlanDataField<String> PLAN_DATA_RPLC_SCOPE_FIELDS_STRING =
        new FinancialPlanDataField<String>("PlanDataRplcScopeFieldsString");
    /**
     * Navigation property <b>to_FinPlanningEntryItemTP</b> for <b>FinancialPlanData</b> to multiple
     * <b>FinPlanningEntryItemTP</b>.
     *
     */
    @SerializedName( "to_FinPlanningEntryItemTP" )
    @JsonProperty( "to_FinPlanningEntryItemTP" )
    @ODataField( odataName = "to_FinPlanningEntryItemTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<FinPlanningEntryItemTP> toFinPlanningEntryItemTP;
    /**
     * Use with available fluent helpers to apply the <b>to_FinPlanningEntryItemTP</b> navigation property to query
     * operations.
     *
     */
    public final static FinancialPlanDataLink<FinPlanningEntryItemTP> TO_FIN_PLANNING_ENTRY_ITEM_TP =
        new FinancialPlanDataLink<FinPlanningEntryItemTP>("to_FinPlanningEntryItemTP");

    @Nonnull
    @Override
    public Class<FinancialPlanData> getType()
    {
        return FinancialPlanData.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PlanDataAggrgnLvlFieldsString</b>
     * </p>
     *
     * @param planDataAggrgnLvlFieldsString
     *            The planDataAggrgnLvlFieldsString to set.
     */
    public void setPlanDataAggrgnLvlFieldsString( @Nullable final String planDataAggrgnLvlFieldsString )
    {
        rememberChangedField("PlanDataAggrgnLvlFieldsString", this.planDataAggrgnLvlFieldsString);
        this.planDataAggrgnLvlFieldsString = planDataAggrgnLvlFieldsString;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PlanDataRplcScopeFieldsString</b>
     * </p>
     *
     * @param planDataRplcScopeFieldsString
     *            The planDataRplcScopeFieldsString to set.
     */
    public void setPlanDataRplcScopeFieldsString( @Nullable final String planDataRplcScopeFieldsString )
    {
        rememberChangedField("PlanDataRplcScopeFieldsString", this.planDataRplcScopeFieldsString);
        this.planDataRplcScopeFieldsString = planDataRplcScopeFieldsString;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FinancialPlanData";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PlanDataAggrgnLvlFieldsString", getPlanDataAggrgnLvlFieldsString());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PlanDataAggrgnLvlFieldsString", getPlanDataAggrgnLvlFieldsString());
        values.put("PlanDataRplcScopeFieldsString", getPlanDataRplcScopeFieldsString());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PlanDataAggrgnLvlFieldsString") ) {
                final Object value = values.remove("PlanDataAggrgnLvlFieldsString");
                if( (value == null) || (!value.equals(getPlanDataAggrgnLvlFieldsString())) ) {
                    setPlanDataAggrgnLvlFieldsString(((String) value));
                }
            }
            if( values.containsKey("PlanDataRplcScopeFieldsString") ) {
                final Object value = values.remove("PlanDataRplcScopeFieldsString");
                if( (value == null) || (!value.equals(getPlanDataRplcScopeFieldsString())) ) {
                    setPlanDataRplcScopeFieldsString(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_FinPlanningEntryItemTP") ) {
                final Object value = (values).remove("to_FinPlanningEntryItemTP");
                if( value instanceof Iterable ) {
                    if( toFinPlanningEntryItemTP == null ) {
                        toFinPlanningEntryItemTP = Lists.newArrayList();
                    } else {
                        toFinPlanningEntryItemTP = Lists.newArrayList(toFinPlanningEntryItemTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        FinPlanningEntryItemTP entity;
                        if( toFinPlanningEntryItemTP.size() > i ) {
                            entity = toFinPlanningEntryItemTP.get(i);
                        } else {
                            entity = new FinPlanningEntryItemTP();
                            toFinPlanningEntryItemTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> FinancialPlanDataField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FinancialPlanDataField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FinancialPlanDataField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FinancialPlanDataField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.FinancialPlanningDataService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toFinPlanningEntryItemTP != null ) {
            (values).put("to_FinPlanningEntryItemTP", toFinPlanningEntryItemTP);
        }
        return values;
    }

    /**
     * Fetches the <b>FinPlanningEntryItemTP</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_FinPlanningEntryItemTP</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>FinPlanningEntryItemTP</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FinPlanningEntryItemTP> fetchFinPlanningEntryItemTP()
    {
        return fetchFieldAsList("to_FinPlanningEntryItemTP", FinPlanningEntryItemTP.class);
    }

    /**
     * Retrieval of associated <b>FinPlanningEntryItemTP</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_FinPlanningEntryItemTP</b>.
     * <p>
     * If the navigation property <b>to_FinPlanningEntryItemTP</b> of a queried <b>FinancialPlanData</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FinPlanningEntryItemTP</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FinPlanningEntryItemTP> getFinPlanningEntryItemTPOrFetch()
    {
        if( toFinPlanningEntryItemTP == null ) {
            toFinPlanningEntryItemTP = fetchFinPlanningEntryItemTP();
        }
        return toFinPlanningEntryItemTP;
    }

    /**
     * Retrieval of associated <b>FinPlanningEntryItemTP</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_FinPlanningEntryItemTP</b>.
     * <p>
     * If the navigation property for an entity <b>FinancialPlanData</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_FinPlanningEntryItemTP</b> is already loaded, the result
     *         will contain the <b>FinPlanningEntryItemTP</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<FinPlanningEntryItemTP>> getFinPlanningEntryItemTPIfPresent()
    {
        return Option.of(toFinPlanningEntryItemTP);
    }

    /**
     * Overwrites the list of associated <b>FinPlanningEntryItemTP</b> entities for the loaded navigation property
     * <b>to_FinPlanningEntryItemTP</b>.
     * <p>
     * If the navigation property <b>to_FinPlanningEntryItemTP</b> of a queried <b>FinancialPlanData</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>FinPlanningEntryItemTP</b> entities.
     */
    public void setFinPlanningEntryItemTP( @Nonnull final List<FinPlanningEntryItemTP> value )
    {
        if( toFinPlanningEntryItemTP == null ) {
            toFinPlanningEntryItemTP = Lists.newArrayList();
        }
        toFinPlanningEntryItemTP.clear();
        toFinPlanningEntryItemTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>FinPlanningEntryItemTP</b> entities. This corresponds to the OData
     * navigation property <b>to_FinPlanningEntryItemTP</b>.
     * <p>
     * If the navigation property <b>to_FinPlanningEntryItemTP</b> of a queried <b>FinancialPlanData</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>FinPlanningEntryItemTP</b> entities.
     */
    public void addFinPlanningEntryItemTP( FinPlanningEntryItemTP... entity )
    {
        if( toFinPlanningEntryItemTP == null ) {
            toFinPlanningEntryItemTP = Lists.newArrayList();
        }
        toFinPlanningEntryItemTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of FinancialPlanData instances.
     *
     */
    public final static class FinancialPlanDataBuilder
    {

        private List<FinPlanningEntryItemTP> toFinPlanningEntryItemTP = Lists.newArrayList();

        private FinancialPlanData.FinancialPlanDataBuilder toFinPlanningEntryItemTP(
            final List<FinPlanningEntryItemTP> value )
        {
            toFinPlanningEntryItemTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_FinPlanningEntryItemTP</b> for <b>FinancialPlanData</b> to multiple
         * <b>FinPlanningEntryItemTP</b>.
         *
         * @param value
         *            The FinPlanningEntryItemTPs to build this FinancialPlanData with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FinancialPlanData.FinancialPlanDataBuilder finPlanningEntryItemTP( FinPlanningEntryItemTP... value )
        {
            return toFinPlanningEntryItemTP(Lists.newArrayList(value));
        }

    }

}
