/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link FinancialPlanningDataServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.FinancialPlanningDataService FinancialPlanningDataService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultFinancialPlanningDataServiceBatch
    extends
    BatchFluentHelperBasic<FinancialPlanningDataServiceBatch, FinancialPlanningDataServiceBatchChangeSet>
    implements
    FinancialPlanningDataServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.FinancialPlanningDataService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultFinancialPlanningDataServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultFinancialPlanningDataServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.FinancialPlanningDataService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.FinancialPlanningDataService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultFinancialPlanningDataServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultFinancialPlanningDataServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.FinancialPlanningDataService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultFinancialPlanningDataServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public FinancialPlanningDataServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultFinancialPlanningDataServiceBatchChangeSet(this, service);
    }

}
