/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinancialPlanData;

/**
 * Implementation of the {@link FinancialPlanningDataServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.FinancialPlanningDataService FinancialPlanningDataService}.
 *
 */
public class DefaultFinancialPlanningDataServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<FinancialPlanningDataServiceBatch, FinancialPlanningDataServiceBatchChangeSet>
    implements
    FinancialPlanningDataServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.FinancialPlanningDataService service;

    @SuppressWarnings( "deprecation" )
    DefaultFinancialPlanningDataServiceBatchChangeSet(
        @Nonnull final DefaultFinancialPlanningDataServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.FinancialPlanningDataService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultFinancialPlanningDataServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public FinancialPlanningDataServiceBatchChangeSet createFinancialPlanData(
        @Nonnull final FinancialPlanData financialPlanData )
    {
        return addRequestCreate(service::createFinancialPlanData, financialPlanData);
    }

}
