/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP
 * FinPlanningEntryItemTP}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.field.FinPlanningEntryItemTPField
 * FinPlanningEntryItemTPField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.link.FinPlanningEntryItemTPLink
 * FinPlanningEntryItemTPLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#ID
 * ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#LEDGER
 * LEDGER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#PLANNING_CATEGORY
 * PLANNING_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#LEDGER_FISCAL_YEAR
 * LEDGER_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#GL_ACCOUNT
 * GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#FINANCIAL_TRANSACTION_TYPE
 * FINANCIAL_TRANSACTION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#FUNCTIONAL_AREA
 * FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#SEGMENT
 * SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#PARTNER_COST_CENTER
 * PARTNER_COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#PARTNER_PROFIT_CENTER
 * PARTNER_PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#PARTNER_FUNCTIONAL_AREA
 * PARTNER_FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#PARTNER_BUSINESS_AREA
 * PARTNER_BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#PARTNER_COMPANY
 * PARTNER_COMPANY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#PARTNER_SEGMENT
 * PARTNER_SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#FIXED_VARIABLE_TYPE
 * FIXED_VARIABLE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#AMOUNT_IN_TRANSACTION_CURRENCY
 * AMOUNT_IN_TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#FIXED_AMOUNT_IN_TRANS_CRCY
 * FIXED_AMOUNT_IN_TRANS_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#COMPANY_CODE_CURRENCY
 * COMPANY_CODE_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#AMOUNT_IN_COMPANY_CODE_CURRENCY
 * AMOUNT_IN_COMPANY_CODE_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#FIXED_AMOUNT_IN_CO_CODE_CRCY
 * FIXED_AMOUNT_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#GLOBAL_CURRENCY
 * GLOBAL_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#AMOUNT_IN_GLOBAL_CURRENCY
 * AMOUNT_IN_GLOBAL_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#FIXED_AMOUNT_IN_GLOBAL_CRCY
 * FIXED_AMOUNT_IN_GLOBAL_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#CONTROLLING_OBJECT_CURRENCY
 * CONTROLLING_OBJECT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#AMOUNT_IN_OBJECT_CURRENCY
 * AMOUNT_IN_OBJECT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#FUNCTIONAL_CURRENCY
 * FUNCTIONAL_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#AMOUNT_IN_FUNCTIONAL_CURRENCY
 * AMOUNT_IN_FUNCTIONAL_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#COST_SOURCE_UNIT
 * COST_SOURCE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#VALUATION_QUANTITY
 * VALUATION_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#VALUATION_FIXED_QUANTITY
 * VALUATION_FIXED_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#REFERENCE_QUANTITY_UNIT
 * REFERENCE_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#REFERENCE_QUANTITY
 * REFERENCE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#FREE_DEFINED_CURRENCY1
 * FREE_DEFINED_CURRENCY1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#AMOUNT_IN_FREE_DEFINED_CURRENCY1
 * AMOUNT_IN_FREE_DEFINED_CURRENCY1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#FREE_DEFINED_CURRENCY2
 * FREE_DEFINED_CURRENCY2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#AMOUNT_IN_FREE_DEFINED_CURRENCY2
 * AMOUNT_IN_FREE_DEFINED_CURRENCY2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#FREE_DEFINED_CURRENCY3
 * FREE_DEFINED_CURRENCY3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#AMOUNT_IN_FREE_DEFINED_CURRENCY3
 * AMOUNT_IN_FREE_DEFINED_CURRENCY3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#FREE_DEFINED_CURRENCY4
 * FREE_DEFINED_CURRENCY4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#AMOUNT_IN_FREE_DEFINED_CURRENCY4
 * AMOUNT_IN_FREE_DEFINED_CURRENCY4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#FREE_DEFINED_CURRENCY5
 * FREE_DEFINED_CURRENCY5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#AMOUNT_IN_FREE_DEFINED_CURRENCY5
 * AMOUNT_IN_FREE_DEFINED_CURRENCY5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#FREE_DEFINED_CURRENCY6
 * FREE_DEFINED_CURRENCY6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#AMOUNT_IN_FREE_DEFINED_CURRENCY6
 * AMOUNT_IN_FREE_DEFINED_CURRENCY6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#FREE_DEFINED_CURRENCY7
 * FREE_DEFINED_CURRENCY7}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#AMOUNT_IN_FREE_DEFINED_CURRENCY7
 * AMOUNT_IN_FREE_DEFINED_CURRENCY7}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#FREE_DEFINED_CURRENCY8
 * FREE_DEFINED_CURRENCY8}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#AMOUNT_IN_FREE_DEFINED_CURRENCY8
 * AMOUNT_IN_FREE_DEFINED_CURRENCY8}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#FISCAL_PERIOD
 * FISCAL_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#FISCAL_YEAR_VARIANT
 * FISCAL_YEAR_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#FISCAL_YEAR_PERIOD
 * FISCAL_YEAR_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#CHART_OF_ACCOUNTS
 * CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#CONTROLLING_DEBIT_CREDIT_CODE
 * CONTROLLING_DEBIT_CREDIT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#PROJECT
 * PROJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#WBS_ELEMENT
 * WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#PARTNER_COMPANY_CODE
 * PARTNER_COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#COST_CTR_ACTIVITY_TYPE
 * COST_CTR_ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#ORDER_ID
 * ORDER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#PARTNER_ORDER
 * PARTNER_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#PARTNER_COST_CTR_ACTIVITY_TYPE
 * PARTNER_COST_CTR_ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#PARTNER_PROJECT
 * PARTNER_PROJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#PARTNER_WBS_ELEMENT
 * PARTNER_WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#SALES_ORGANIZATION
 * SALES_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#DISTRIBUTION_CHANNEL
 * DISTRIBUTION_CHANNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#DIVISION
 * DIVISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#SOLD_MATERIAL
 * SOLD_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#MATERIAL_GROUP
 * MATERIAL_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#CUSTOMER_GROUP
 * CUSTOMER_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#CUSTOMER_SUPPLIER_COUNTRY
 * CUSTOMER_SUPPLIER_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#CUSTOMER_SUPPLIER_INDUSTRY
 * CUSTOMER_SUPPLIER_INDUSTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#SALES_DISTRICT
 * SALES_DISTRICT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#FINANCIAL_MANAGEMENT_AREA
 * FINANCIAL_MANAGEMENT_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#FUND
 * FUND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#GRANT_ID
 * GRANT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#BUDGET_PERIOD
 * BUDGET_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#BUDGET_PROCESS
 * BUDGET_PROCESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#BUDGETING_TYPE
 * BUDGETING_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#SPONSORED_PROGRAM
 * SPONSORED_PROGRAM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#SPONSORED_CLASS
 * SPONSORED_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#GTEE_M_BUDGET_VALIDITY_NUMBER
 * GTEE_M_BUDGET_VALIDITY_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#RE_BUSINESS_ENTITY
 * RE_BUSINESS_ENTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#REAL_ESTATE_BUILDING
 * REAL_ESTATE_BUILDING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#REAL_ESTATE_PROPERTY
 * REAL_ESTATE_PROPERTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#RE_RENTAL_OBJECT
 * RE_RENTAL_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#REAL_ESTATE_CONTRACT
 * REAL_ESTATE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#RE_SERVICE_CHARGE_KEY
 * RE_SERVICE_CHARGE_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#RE_SETTLEMENT_UNIT_ID
 * RE_SETTLEMENT_UNIT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinPlanningEntryItemTP#SETTLEMENT_REFERENCE_DATE
 * SETTLEMENT_REFERENCE_DATE}</li>
 * </ul>
 *
 */
public interface FinPlanningEntryItemTPSelectable extends EntitySelectable<FinPlanningEntryItemTP>
{

}
