/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinancialPlanData;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinancialPlanData
 * FinancialPlanData}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.field.FinancialPlanDataField
 * FinancialPlanDataField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.link.FinancialPlanDataLink
 * FinancialPlanDataLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinancialPlanData#PLAN_DATA_AGGRGN_LVL_FIELDS_STRING
 * PLAN_DATA_AGGRGN_LVL_FIELDS_STRING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinancialPlanData#PLAN_DATA_RPLC_SCOPE_FIELDS_STRING
 * PLAN_DATA_RPLC_SCOPE_FIELDS_STRING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningdata.FinancialPlanData#TO_FIN_PLANNING_ENTRY_ITEM_TP
 * TO_FIN_PLANNING_ENTRY_ITEM_TP}</li>
 * </ul>
 *
 */
public interface FinancialPlanDataSelectable extends EntitySelectable<FinancialPlanData>
{

}
