/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.field.CompanyCodeField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.selectable.CompanyCodeSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Company Code Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CompanyCodeType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CompanyCode extends VdmEntity<CompanyCode>
{

    /**
     * Selector for all available fields of CompanyCode.
     *
     */
    public final static CompanyCodeSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @Key
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static CompanyCodeField<String> COMPANY_CODE = new CompanyCodeField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeName</b>
     * </p>
     *
     * @return Name of Company Code or Company
     */
    @SerializedName( "CompanyCodeName" )
    @JsonProperty( "CompanyCodeName" )
    @Nullable
    @ODataField( odataName = "CompanyCodeName" )
    private String companyCodeName;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeName</b> field to query operations.
     *
     */
    public final static CompanyCodeField<String> COMPANY_CODE_NAME = new CompanyCodeField<String>("CompanyCodeName");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     *
     * @return City
     */
    @SerializedName( "CityName" )
    @JsonProperty( "CityName" )
    @Nullable
    @ODataField( odataName = "CityName" )
    private String cityName;
    /**
     * Use with available fluent helpers to apply the <b>CityName</b> field to query operations.
     *
     */
    public final static CompanyCodeField<String> CITY_NAME = new CompanyCodeField<String>("CityName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @return Country/Region Key
     */
    @SerializedName( "Country" )
    @JsonProperty( "Country" )
    @Nullable
    @ODataField( odataName = "Country" )
    private String country;
    /**
     * Use with available fluent helpers to apply the <b>Country</b> field to query operations.
     *
     */
    public final static CompanyCodeField<String> COUNTRY = new CompanyCodeField<String>("Country");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static CompanyCodeField<String> CURRENCY = new CompanyCodeField<String>("Currency");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static CompanyCodeField<String> LANGUAGE = new CompanyCodeField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @return Chart of Accounts
     */
    @SerializedName( "ChartOfAccounts" )
    @JsonProperty( "ChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ChartOfAccounts" )
    private String chartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ChartOfAccounts</b> field to query operations.
     *
     */
    public final static CompanyCodeField<String> CHART_OF_ACCOUNTS = new CompanyCodeField<String>("ChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearVariant</b>
     * </p>
     *
     * @return Fiscal Year Variant
     */
    @SerializedName( "FiscalYearVariant" )
    @JsonProperty( "FiscalYearVariant" )
    @Nullable
    @ODataField( odataName = "FiscalYearVariant" )
    private String fiscalYearVariant;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYearVariant</b> field to query operations.
     *
     */
    public final static CompanyCodeField<String> FISCAL_YEAR_VARIANT =
        new CompanyCodeField<String>("FiscalYearVariant");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>Company</b>
     * </p>
     *
     * @return Company
     */
    @SerializedName( "Company" )
    @JsonProperty( "Company" )
    @Nullable
    @ODataField( odataName = "Company" )
    private String company;
    /**
     * Use with available fluent helpers to apply the <b>Company</b> field to query operations.
     *
     */
    public final static CompanyCodeField<String> COMPANY = new CompanyCodeField<String>("Company");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CreditControlArea</b>
     * </p>
     *
     * @return Credit Control Area
     */
    @SerializedName( "CreditControlArea" )
    @JsonProperty( "CreditControlArea" )
    @Nullable
    @ODataField( odataName = "CreditControlArea" )
    private String creditControlArea;
    /**
     * Use with available fluent helpers to apply the <b>CreditControlArea</b> field to query operations.
     *
     */
    public final static CompanyCodeField<String> CREDIT_CONTROL_AREA =
        new CompanyCodeField<String>("CreditControlArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CountryChartOfAccounts</b>
     * </p>
     *
     * @return Alternative Chart of Accounts
     */
    @SerializedName( "CountryChartOfAccounts" )
    @JsonProperty( "CountryChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "CountryChartOfAccounts" )
    private String countryChartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>CountryChartOfAccounts</b> field to query operations.
     *
     */
    public final static CompanyCodeField<String> COUNTRY_CHART_OF_ACCOUNTS =
        new CompanyCodeField<String>("CountryChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FinancialManagementArea</b>
     * </p>
     *
     * @return Financial Management Area
     */
    @SerializedName( "FinancialManagementArea" )
    @JsonProperty( "FinancialManagementArea" )
    @Nullable
    @ODataField( odataName = "FinancialManagementArea" )
    private String financialManagementArea;
    /**
     * Use with available fluent helpers to apply the <b>FinancialManagementArea</b> field to query operations.
     *
     */
    public final static CompanyCodeField<String> FINANCIAL_MANAGEMENT_AREA =
        new CompanyCodeField<String>("FinancialManagementArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressID</b>
     * </p>
     *
     * @return Address
     */
    @SerializedName( "AddressID" )
    @JsonProperty( "AddressID" )
    @Nullable
    @ODataField( odataName = "AddressID" )
    private String addressID;
    /**
     * Use with available fluent helpers to apply the <b>AddressID</b> field to query operations.
     *
     */
    public final static CompanyCodeField<String> ADDRESS_ID = new CompanyCodeField<String>("AddressID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TaxableEntity</b>
     * </p>
     *
     * @return Taxes on Sales/Purchases Group
     */
    @SerializedName( "TaxableEntity" )
    @JsonProperty( "TaxableEntity" )
    @Nullable
    @ODataField( odataName = "TaxableEntity" )
    private String taxableEntity;
    /**
     * Use with available fluent helpers to apply the <b>TaxableEntity</b> field to query operations.
     *
     */
    public final static CompanyCodeField<String> TAXABLE_ENTITY = new CompanyCodeField<String>("TaxableEntity");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>VATRegistration</b>
     * </p>
     *
     * @return VAT Registration Number
     */
    @SerializedName( "VATRegistration" )
    @JsonProperty( "VATRegistration" )
    @Nullable
    @ODataField( odataName = "VATRegistration" )
    private String vATRegistration;
    /**
     * Use with available fluent helpers to apply the <b>VATRegistration</b> field to query operations.
     *
     */
    public final static CompanyCodeField<String> VAT_REGISTRATION = new CompanyCodeField<String>("VATRegistration");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ExtendedWhldgTaxIsActive</b>
     * </p>
     *
     * @return Indicator: Extended Withholding Tax Active
     */
    @SerializedName( "ExtendedWhldgTaxIsActive" )
    @JsonProperty( "ExtendedWhldgTaxIsActive" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ExtendedWhldgTaxIsActive" )
    private Boolean extendedWhldgTaxIsActive;
    /**
     * Use with available fluent helpers to apply the <b>ExtendedWhldgTaxIsActive</b> field to query operations.
     *
     */
    public final static CompanyCodeField<Boolean> EXTENDED_WHLDG_TAX_IS_ACTIVE =
        new CompanyCodeField<Boolean>("ExtendedWhldgTaxIsActive");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static CompanyCodeField<String> CONTROLLING_AREA = new CompanyCodeField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FieldStatusVariant</b>
     * </p>
     *
     * @return Field Status Variant
     */
    @SerializedName( "FieldStatusVariant" )
    @JsonProperty( "FieldStatusVariant" )
    @Nullable
    @ODataField( odataName = "FieldStatusVariant" )
    private String fieldStatusVariant;
    /**
     * Use with available fluent helpers to apply the <b>FieldStatusVariant</b> field to query operations.
     *
     */
    public final static CompanyCodeField<String> FIELD_STATUS_VARIANT =
        new CompanyCodeField<String>("FieldStatusVariant");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>NonTaxableTransactionTaxCode</b>
     * </p>
     *
     * @return Output Tax Code for Non-Taxable Transactions
     */
    @SerializedName( "NonTaxableTransactionTaxCode" )
    @JsonProperty( "NonTaxableTransactionTaxCode" )
    @Nullable
    @ODataField( odataName = "NonTaxableTransactionTaxCode" )
    private String nonTaxableTransactionTaxCode;
    /**
     * Use with available fluent helpers to apply the <b>NonTaxableTransactionTaxCode</b> field to query operations.
     *
     */
    public final static CompanyCodeField<String> NON_TAXABLE_TRANSACTION_TAX_CODE =
        new CompanyCodeField<String>("NonTaxableTransactionTaxCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DocDateIsUsedForTaxDetn</b>
     * </p>
     *
     * @return Indicator: Document Date As the Basis for Tax Determination
     */
    @SerializedName( "DocDateIsUsedForTaxDetn" )
    @JsonProperty( "DocDateIsUsedForTaxDetn" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "DocDateIsUsedForTaxDetn" )
    private Boolean docDateIsUsedForTaxDetn;
    /**
     * Use with available fluent helpers to apply the <b>DocDateIsUsedForTaxDetn</b> field to query operations.
     *
     */
    public final static CompanyCodeField<Boolean> DOC_DATE_IS_USED_FOR_TAX_DETN =
        new CompanyCodeField<Boolean>("DocDateIsUsedForTaxDetn");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TaxRptgDateIsActive</b>
     * </p>
     *
     * @return Tax Reporting Date Active in Documents
     */
    @SerializedName( "TaxRptgDateIsActive" )
    @JsonProperty( "TaxRptgDateIsActive" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "TaxRptgDateIsActive" )
    private Boolean taxRptgDateIsActive;
    /**
     * Use with available fluent helpers to apply the <b>TaxRptgDateIsActive</b> field to query operations.
     *
     */
    public final static CompanyCodeField<Boolean> TAX_RPTG_DATE_IS_ACTIVE =
        new CompanyCodeField<Boolean>("TaxRptgDateIsActive");

    @Nonnull
    @Override
    public Class<CompanyCode> getType()
    {
        return CompanyCode.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeName</b>
     * </p>
     *
     * @param companyCodeName
     *            Name of Company Code or Company
     */
    public void setCompanyCodeName( @Nullable final String companyCodeName )
    {
        rememberChangedField("CompanyCodeName", this.companyCodeName);
        this.companyCodeName = companyCodeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     *
     * @param cityName
     *            City
     */
    public void setCityName( @Nullable final String cityName )
    {
        rememberChangedField("CityName", this.cityName);
        this.cityName = cityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @param country
     *            Country/Region Key
     */
    public void setCountry( @Nullable final String country )
    {
        rememberChangedField("Country", this.country);
        this.country = country;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency Key
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @param chartOfAccounts
     *            Chart of Accounts
     */
    public void setChartOfAccounts( @Nullable final String chartOfAccounts )
    {
        rememberChangedField("ChartOfAccounts", this.chartOfAccounts);
        this.chartOfAccounts = chartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearVariant</b>
     * </p>
     *
     * @param fiscalYearVariant
     *            Fiscal Year Variant
     */
    public void setFiscalYearVariant( @Nullable final String fiscalYearVariant )
    {
        rememberChangedField("FiscalYearVariant", this.fiscalYearVariant);
        this.fiscalYearVariant = fiscalYearVariant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>Company</b>
     * </p>
     *
     * @param company
     *            Company
     */
    public void setCompany( @Nullable final String company )
    {
        rememberChangedField("Company", this.company);
        this.company = company;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CreditControlArea</b>
     * </p>
     *
     * @param creditControlArea
     *            Credit Control Area
     */
    public void setCreditControlArea( @Nullable final String creditControlArea )
    {
        rememberChangedField("CreditControlArea", this.creditControlArea);
        this.creditControlArea = creditControlArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CountryChartOfAccounts</b>
     * </p>
     *
     * @param countryChartOfAccounts
     *            Alternative Chart of Accounts
     */
    public void setCountryChartOfAccounts( @Nullable final String countryChartOfAccounts )
    {
        rememberChangedField("CountryChartOfAccounts", this.countryChartOfAccounts);
        this.countryChartOfAccounts = countryChartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FinancialManagementArea</b>
     * </p>
     *
     * @param financialManagementArea
     *            Financial Management Area
     */
    public void setFinancialManagementArea( @Nullable final String financialManagementArea )
    {
        rememberChangedField("FinancialManagementArea", this.financialManagementArea);
        this.financialManagementArea = financialManagementArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressID</b>
     * </p>
     *
     * @param addressID
     *            Address
     */
    public void setAddressID( @Nullable final String addressID )
    {
        rememberChangedField("AddressID", this.addressID);
        this.addressID = addressID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TaxableEntity</b>
     * </p>
     *
     * @param taxableEntity
     *            Taxes on Sales/Purchases Group
     */
    public void setTaxableEntity( @Nullable final String taxableEntity )
    {
        rememberChangedField("TaxableEntity", this.taxableEntity);
        this.taxableEntity = taxableEntity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>VATRegistration</b>
     * </p>
     *
     * @param vATRegistration
     *            VAT Registration Number
     */
    public void setVATRegistration( @Nullable final String vATRegistration )
    {
        rememberChangedField("VATRegistration", this.vATRegistration);
        this.vATRegistration = vATRegistration;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ExtendedWhldgTaxIsActive</b>
     * </p>
     *
     * @param extendedWhldgTaxIsActive
     *            Indicator: Extended Withholding Tax Active
     */
    public void setExtendedWhldgTaxIsActive( @Nullable final Boolean extendedWhldgTaxIsActive )
    {
        rememberChangedField("ExtendedWhldgTaxIsActive", this.extendedWhldgTaxIsActive);
        this.extendedWhldgTaxIsActive = extendedWhldgTaxIsActive;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FieldStatusVariant</b>
     * </p>
     *
     * @param fieldStatusVariant
     *            Field Status Variant
     */
    public void setFieldStatusVariant( @Nullable final String fieldStatusVariant )
    {
        rememberChangedField("FieldStatusVariant", this.fieldStatusVariant);
        this.fieldStatusVariant = fieldStatusVariant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>NonTaxableTransactionTaxCode</b>
     * </p>
     *
     * @param nonTaxableTransactionTaxCode
     *            Output Tax Code for Non-Taxable Transactions
     */
    public void setNonTaxableTransactionTaxCode( @Nullable final String nonTaxableTransactionTaxCode )
    {
        rememberChangedField("NonTaxableTransactionTaxCode", this.nonTaxableTransactionTaxCode);
        this.nonTaxableTransactionTaxCode = nonTaxableTransactionTaxCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DocDateIsUsedForTaxDetn</b>
     * </p>
     *
     * @param docDateIsUsedForTaxDetn
     *            Indicator: Document Date As the Basis for Tax Determination
     */
    public void setDocDateIsUsedForTaxDetn( @Nullable final Boolean docDateIsUsedForTaxDetn )
    {
        rememberChangedField("DocDateIsUsedForTaxDetn", this.docDateIsUsedForTaxDetn);
        this.docDateIsUsedForTaxDetn = docDateIsUsedForTaxDetn;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TaxRptgDateIsActive</b>
     * </p>
     *
     * @param taxRptgDateIsActive
     *            Tax Reporting Date Active in Documents
     */
    public void setTaxRptgDateIsActive( @Nullable final Boolean taxRptgDateIsActive )
    {
        rememberChangedField("TaxRptgDateIsActive", this.taxRptgDateIsActive);
        this.taxRptgDateIsActive = taxRptgDateIsActive;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CompanyCode";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CompanyCode", getCompanyCode());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CompanyCode", getCompanyCode());
        values.put("CompanyCodeName", getCompanyCodeName());
        values.put("CityName", getCityName());
        values.put("Country", getCountry());
        values.put("Currency", getCurrency());
        values.put("Language", getLanguage());
        values.put("ChartOfAccounts", getChartOfAccounts());
        values.put("FiscalYearVariant", getFiscalYearVariant());
        values.put("Company", getCompany());
        values.put("CreditControlArea", getCreditControlArea());
        values.put("CountryChartOfAccounts", getCountryChartOfAccounts());
        values.put("FinancialManagementArea", getFinancialManagementArea());
        values.put("AddressID", getAddressID());
        values.put("TaxableEntity", getTaxableEntity());
        values.put("VATRegistration", getVATRegistration());
        values.put("ExtendedWhldgTaxIsActive", getExtendedWhldgTaxIsActive());
        values.put("ControllingArea", getControllingArea());
        values.put("FieldStatusVariant", getFieldStatusVariant());
        values.put("NonTaxableTransactionTaxCode", getNonTaxableTransactionTaxCode());
        values.put("DocDateIsUsedForTaxDetn", getDocDateIsUsedForTaxDetn());
        values.put("TaxRptgDateIsActive", getTaxRptgDateIsActive());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("CompanyCodeName") ) {
                final Object value = values.remove("CompanyCodeName");
                if( (value == null) || (!value.equals(getCompanyCodeName())) ) {
                    setCompanyCodeName(((String) value));
                }
            }
            if( values.containsKey("CityName") ) {
                final Object value = values.remove("CityName");
                if( (value == null) || (!value.equals(getCityName())) ) {
                    setCityName(((String) value));
                }
            }
            if( values.containsKey("Country") ) {
                final Object value = values.remove("Country");
                if( (value == null) || (!value.equals(getCountry())) ) {
                    setCountry(((String) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ChartOfAccounts") ) {
                final Object value = values.remove("ChartOfAccounts");
                if( (value == null) || (!value.equals(getChartOfAccounts())) ) {
                    setChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("FiscalYearVariant") ) {
                final Object value = values.remove("FiscalYearVariant");
                if( (value == null) || (!value.equals(getFiscalYearVariant())) ) {
                    setFiscalYearVariant(((String) value));
                }
            }
            if( values.containsKey("Company") ) {
                final Object value = values.remove("Company");
                if( (value == null) || (!value.equals(getCompany())) ) {
                    setCompany(((String) value));
                }
            }
            if( values.containsKey("CreditControlArea") ) {
                final Object value = values.remove("CreditControlArea");
                if( (value == null) || (!value.equals(getCreditControlArea())) ) {
                    setCreditControlArea(((String) value));
                }
            }
            if( values.containsKey("CountryChartOfAccounts") ) {
                final Object value = values.remove("CountryChartOfAccounts");
                if( (value == null) || (!value.equals(getCountryChartOfAccounts())) ) {
                    setCountryChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("FinancialManagementArea") ) {
                final Object value = values.remove("FinancialManagementArea");
                if( (value == null) || (!value.equals(getFinancialManagementArea())) ) {
                    setFinancialManagementArea(((String) value));
                }
            }
            if( values.containsKey("AddressID") ) {
                final Object value = values.remove("AddressID");
                if( (value == null) || (!value.equals(getAddressID())) ) {
                    setAddressID(((String) value));
                }
            }
            if( values.containsKey("TaxableEntity") ) {
                final Object value = values.remove("TaxableEntity");
                if( (value == null) || (!value.equals(getTaxableEntity())) ) {
                    setTaxableEntity(((String) value));
                }
            }
            if( values.containsKey("VATRegistration") ) {
                final Object value = values.remove("VATRegistration");
                if( (value == null) || (!value.equals(getVATRegistration())) ) {
                    setVATRegistration(((String) value));
                }
            }
            if( values.containsKey("ExtendedWhldgTaxIsActive") ) {
                final Object value = values.remove("ExtendedWhldgTaxIsActive");
                if( (value == null) || (!value.equals(getExtendedWhldgTaxIsActive())) ) {
                    setExtendedWhldgTaxIsActive(((Boolean) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("FieldStatusVariant") ) {
                final Object value = values.remove("FieldStatusVariant");
                if( (value == null) || (!value.equals(getFieldStatusVariant())) ) {
                    setFieldStatusVariant(((String) value));
                }
            }
            if( values.containsKey("NonTaxableTransactionTaxCode") ) {
                final Object value = values.remove("NonTaxableTransactionTaxCode");
                if( (value == null) || (!value.equals(getNonTaxableTransactionTaxCode())) ) {
                    setNonTaxableTransactionTaxCode(((String) value));
                }
            }
            if( values.containsKey("DocDateIsUsedForTaxDetn") ) {
                final Object value = values.remove("DocDateIsUsedForTaxDetn");
                if( (value == null) || (!value.equals(getDocDateIsUsedForTaxDetn())) ) {
                    setDocDateIsUsedForTaxDetn(((Boolean) value));
                }
            }
            if( values.containsKey("TaxRptgDateIsActive") ) {
                final Object value = values.remove("TaxRptgDateIsActive");
                if( (value == null) || (!value.equals(getTaxRptgDateIsActive())) ) {
                    setTaxRptgDateIsActive(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CompanyCodeField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CompanyCodeField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CompanyCodeField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CompanyCodeField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.FinancialPlanningEntryItemService.DEFAULT_SERVICE_PATH);
    }

}
