/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.selectable.GLAccountInChartOfAccountsSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccounts
 * GLAccountInChartOfAccounts} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class GLAccountInChartOfAccountsByKeyFluentHelper
    extends
    FluentHelperByKey<GLAccountInChartOfAccountsByKeyFluentHelper, GLAccountInChartOfAccounts, GLAccountInChartOfAccountsSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccounts
     * GLAccountInChartOfAccounts} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code GLAccountInChartOfAccounts}
     * @param gLAccount
     *            G/L Account Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code GLAccountInChartOfAccounts}
     * @param chartOfAccounts
     *            Chart of Accounts
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public GLAccountInChartOfAccountsByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String chartOfAccounts,
        final String gLAccount )
    {
        super(servicePath, entityCollection);
        this.key.put("ChartOfAccounts", chartOfAccounts);
        this.key.put("GLAccount", gLAccount);
    }

    @Override
    @Nonnull
    protected Class<GLAccountInChartOfAccounts> getEntityClass()
    {
        return GLAccountInChartOfAccounts.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
