/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link FinancialPlanningEntryItemServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.FinancialPlanningEntryItemService
 * FinancialPlanningEntryItemService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultFinancialPlanningEntryItemServiceBatch
    extends
    BatchFluentHelperBasic<FinancialPlanningEntryItemServiceBatch, FinancialPlanningEntryItemServiceBatchChangeSet>
    implements
    FinancialPlanningEntryItemServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.FinancialPlanningEntryItemService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultFinancialPlanningEntryItemServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultFinancialPlanningEntryItemServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.FinancialPlanningEntryItemService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.FinancialPlanningEntryItemService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultFinancialPlanningEntryItemServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultFinancialPlanningEntryItemServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.FinancialPlanningEntryItemService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultFinancialPlanningEntryItemServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public FinancialPlanningEntryItemServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultFinancialPlanningEntryItemServiceBatchChangeSet(this, service);
    }

}
