/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link FinancialPlanningEntryItemServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.FinancialPlanningEntryItemService
 * FinancialPlanningEntryItemService}.
 *
 */
public class DefaultFinancialPlanningEntryItemServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<FinancialPlanningEntryItemServiceBatch, FinancialPlanningEntryItemServiceBatchChangeSet>
    implements
    FinancialPlanningEntryItemServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.FinancialPlanningEntryItemService service;

    @SuppressWarnings( "deprecation" )
    DefaultFinancialPlanningEntryItemServiceBatchChangeSet(
        @Nonnull final DefaultFinancialPlanningEntryItemServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.FinancialPlanningEntryItemService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultFinancialPlanningEntryItemServiceBatchChangeSet getThis()
    {
        return this;
    }

}
