/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem
 * FinPlanningEntryItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.field.FinPlanningEntryItemField
 * FinPlanningEntryItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.link.FinPlanningEntryItemLink
 * FinPlanningEntryItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#ID
 * ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#LEDGER
 * LEDGER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#LEDGER_NAME
 * LEDGER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#PLANNING_CATEGORY
 * PLANNING_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#LEDGER_FISCAL_YEAR
 * LEDGER_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#GL_ACCOUNT
 * GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#GL_ACCOUNT_NAME
 * GL_ACCOUNT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#COMPANY_CODE_NAME
 * COMPANY_CODE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#FINANCIAL_TRANSACTION_TYPE
 * FINANCIAL_TRANSACTION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#COST_CENTER_NAME
 * COST_CENTER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#PROFIT_CENTER_NAME
 * PROFIT_CENTER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#FUNCTIONAL_AREA
 * FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#FUNCTIONAL_AREA_NAME
 * FUNCTIONAL_AREA_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#BUSINESS_AREA_NAME
 * BUSINESS_AREA_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#CONTROLLING_AREA_NAME
 * CONTROLLING_AREA_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#SEGMENT
 * SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#SEGMENT_NAME
 * SEGMENT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#PARTNER_COST_CENTER
 * PARTNER_COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#PARTNER_COST_CENTER_NAME
 * PARTNER_COST_CENTER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#PARTNER_PROFIT_CENTER
 * PARTNER_PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#PARTNER_PROFIT_CENTER_NAME
 * PARTNER_PROFIT_CENTER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#PARTNER_FUNCTIONAL_AREA
 * PARTNER_FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#PARTNER_FUNCTIONAL_AREA_NAME
 * PARTNER_FUNCTIONAL_AREA_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#PARTNER_BUSINESS_AREA
 * PARTNER_BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#PARTNER_BUSINESS_AREA_NAME
 * PARTNER_BUSINESS_AREA_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#PARTNER_COMPANY
 * PARTNER_COMPANY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#PARTNER_COMPANY_NAME
 * PARTNER_COMPANY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#PARTNER_SEGMENT
 * PARTNER_SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#PARTNER_SEGMENT_NAME
 * PARTNER_SEGMENT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#AMOUNT_IN_TRANSACTION_CURRENCY
 * AMOUNT_IN_TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#COMPANY_CODE_CURRENCY
 * COMPANY_CODE_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#AMOUNT_IN_COMPANY_CODE_CURRENCY
 * AMOUNT_IN_COMPANY_CODE_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#GLOBAL_CURRENCY
 * GLOBAL_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#AMOUNT_IN_GLOBAL_CURRENCY
 * AMOUNT_IN_GLOBAL_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#CONTROLLING_OBJECT_CURRENCY
 * CONTROLLING_OBJECT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#AMOUNT_IN_OBJECT_CURRENCY
 * AMOUNT_IN_OBJECT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#FUNCTIONAL_CURRENCY
 * FUNCTIONAL_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#AMOUNT_IN_FUNCTIONAL_CURRENCY
 * AMOUNT_IN_FUNCTIONAL_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#COST_SOURCE_UNIT
 * COST_SOURCE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#VALUATION_QUANTITY
 * VALUATION_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#REFERENCE_QUANTITY_UNIT
 * REFERENCE_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#REFERENCE_QUANTITY
 * REFERENCE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#FREE_DEFINED_CURRENCY1
 * FREE_DEFINED_CURRENCY1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#AMOUNT_IN_FREE_DEFINED_CURRENCY1
 * AMOUNT_IN_FREE_DEFINED_CURRENCY1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#FREE_DEFINED_CURRENCY2
 * FREE_DEFINED_CURRENCY2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#AMOUNT_IN_FREE_DEFINED_CURRENCY2
 * AMOUNT_IN_FREE_DEFINED_CURRENCY2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#FREE_DEFINED_CURRENCY3
 * FREE_DEFINED_CURRENCY3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#AMOUNT_IN_FREE_DEFINED_CURRENCY3
 * AMOUNT_IN_FREE_DEFINED_CURRENCY3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#FREE_DEFINED_CURRENCY4
 * FREE_DEFINED_CURRENCY4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#AMOUNT_IN_FREE_DEFINED_CURRENCY4
 * AMOUNT_IN_FREE_DEFINED_CURRENCY4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#FREE_DEFINED_CURRENCY5
 * FREE_DEFINED_CURRENCY5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#AMOUNT_IN_FREE_DEFINED_CURRENCY5
 * AMOUNT_IN_FREE_DEFINED_CURRENCY5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#FREE_DEFINED_CURRENCY6
 * FREE_DEFINED_CURRENCY6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#AMOUNT_IN_FREE_DEFINED_CURRENCY6
 * AMOUNT_IN_FREE_DEFINED_CURRENCY6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#FREE_DEFINED_CURRENCY7
 * FREE_DEFINED_CURRENCY7}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#AMOUNT_IN_FREE_DEFINED_CURRENCY7
 * AMOUNT_IN_FREE_DEFINED_CURRENCY7}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#FREE_DEFINED_CURRENCY8
 * FREE_DEFINED_CURRENCY8}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#AMOUNT_IN_FREE_DEFINED_CURRENCY8
 * AMOUNT_IN_FREE_DEFINED_CURRENCY8}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#FISCAL_PERIOD
 * FISCAL_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#FISCAL_YEAR_VARIANT
 * FISCAL_YEAR_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#FISCAL_YEAR_PERIOD
 * FISCAL_YEAR_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#CHART_OF_ACCOUNTS
 * CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#PLANT_NAME
 * PLANT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#CUSTOMER_NAME
 * CUSTOMER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#CONTROLLING_DEBIT_CREDIT_CODE
 * CONTROLLING_DEBIT_CREDIT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#PROJECT_EXTERNAL_ID
 * PROJECT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#PROJECT
 * PROJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#PROJECT_DESCRIPTION
 * PROJECT_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#WBS_ELEMENT_EXTERNAL_ID
 * WBS_ELEMENT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#WBS_ELEMENT
 * WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#WBS_ELEMENT_DESCRIPTION
 * WBS_ELEMENT_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#PARTNER_COMPANY_CODE
 * PARTNER_COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#PARTNER_COMPANY_CODE_NAME
 * PARTNER_COMPANY_CODE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#COST_CTR_ACTIVITY_TYPE
 * COST_CTR_ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#COST_CTR_ACTIVITY_TYPE_NAME
 * COST_CTR_ACTIVITY_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#ORDER_ID
 * ORDER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#PARTNER_ORDER
 * PARTNER_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#PARTNER_COST_CTR_ACTIVITY_TYPE
 * PARTNER_COST_CTR_ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#PARTNER_COST_CTR_ACTIVITY_TYPE_NAME
 * PARTNER_COST_CTR_ACTIVITY_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#PARTNER_PROJECT
 * PARTNER_PROJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#PARTNER_PROJECT_DESCRIPTION
 * PARTNER_PROJECT_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#PARTNER_WBS_ELEMENT
 * PARTNER_WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#PARTNER_WBS_ELEMENT_DESCRIPTION
 * PARTNER_WBS_ELEMENT_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#SALES_ORGANIZATION
 * SALES_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#SALES_ORGANIZATION_NAME
 * SALES_ORGANIZATION_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#DISTRIBUTION_CHANNEL
 * DISTRIBUTION_CHANNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#DISTRIBUTION_CHANNEL_NAME
 * DISTRIBUTION_CHANNEL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#DIVISION
 * DIVISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#DIVISION_NAME
 * DIVISION_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#SOLD_MATERIAL
 * SOLD_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#SOLD_MATERIAL_NAME
 * SOLD_MATERIAL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#MATERIAL_GROUP
 * MATERIAL_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#MATERIAL_GROUP_NAME
 * MATERIAL_GROUP_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#CUSTOMER_GROUP
 * CUSTOMER_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#CUSTOMER_GROUP_NAME
 * CUSTOMER_GROUP_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#CUSTOMER_SUPPLIER_COUNTRY
 * CUSTOMER_SUPPLIER_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#CUSTOMER_SUPPLIER_COUNTRY_NAME
 * CUSTOMER_SUPPLIER_COUNTRY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#CUSTOMER_SUPPLIER_INDUSTRY
 * CUSTOMER_SUPPLIER_INDUSTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#CUSTOMER_SUPPLIER_INDUSTRY_NAME
 * CUSTOMER_SUPPLIER_INDUSTRY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#SALES_DISTRICT
 * SALES_DISTRICT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#SALES_DISTRICT_NAME
 * SALES_DISTRICT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#FINANCIAL_MANAGEMENT_AREA
 * FINANCIAL_MANAGEMENT_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#FUND
 * FUND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#GRANT_ID
 * GRANT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#BUDGET_PERIOD
 * BUDGET_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#BUDGET_PROCESS
 * BUDGET_PROCESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#BUDGETING_TYPE
 * BUDGETING_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#SPONSORED_PROGRAM
 * SPONSORED_PROGRAM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#SPONSORED_CLASS
 * SPONSORED_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#GTEE_M_BUDGET_VALIDITY_NUMBER
 * GTEE_M_BUDGET_VALIDITY_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#RE_BUSINESS_ENTITY
 * RE_BUSINESS_ENTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#REAL_ESTATE_BUILDING
 * REAL_ESTATE_BUILDING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#REAL_ESTATE_PROPERTY
 * REAL_ESTATE_PROPERTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#RE_RENTAL_OBJECT
 * RE_RENTAL_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#REAL_ESTATE_CONTRACT
 * REAL_ESTATE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#RE_SERVICE_CHARGE_KEY
 * RE_SERVICE_CHARGE_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#RE_SETTLEMENT_UNIT_ID
 * RE_SETTLEMENT_UNIT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#SETTLEMENT_REFERENCE_DATE
 * SETTLEMENT_REFERENCE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#TO_COMPANY_CODE
 * TO_COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#TO_CURRENT_COST_CENTER
 * TO_CURRENT_COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#TO_CURRENT_PROFIT_CENTER
 * TO_CURRENT_PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.FinPlanningEntryItem#TO_GL_ACCOUNT_IN_CHART_OF_ACCOUNTS
 * TO_GL_ACCOUNT_IN_CHART_OF_ACCOUNTS}</li>
 * </ul>
 *
 */
public interface FinPlanningEntryItemSelectable extends EntitySelectable<FinPlanningEntryItem>
{

}
