/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccounts;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccounts
 * GLAccountInChartOfAccounts}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.field.GLAccountInChartOfAccountsField
 * GLAccountInChartOfAccountsField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.link.GLAccountInChartOfAccountsLink
 * GLAccountInChartOfAccountsLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccounts#CHART_OF_ACCOUNTS
 * CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccounts#GL_ACCOUNT
 * GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccounts#IS_BALANCE_SHEET_ACCOUNT
 * IS_BALANCE_SHEET_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccounts#GL_ACCOUNT_GROUP
 * GL_ACCOUNT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccounts#CORPORATE_GROUP_ACCOUNT
 * CORPORATE_GROUP_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccounts#PROFIT_LOSS_ACCOUNT_TYPE
 * PROFIT_LOSS_ACCOUNT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccounts#SAMPLE_GL_ACCOUNT
 * SAMPLE_GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccounts#ACCOUNT_IS_MARKED_FOR_DELETION
 * ACCOUNT_IS_MARKED_FOR_DELETION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccounts#ACCOUNT_IS_BLOCKED_FOR_CREATION
 * ACCOUNT_IS_BLOCKED_FOR_CREATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccounts#ACCOUNT_IS_BLOCKED_FOR_POSTING
 * ACCOUNT_IS_BLOCKED_FOR_POSTING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccounts#ACCOUNT_IS_BLOCKED_FOR_PLANNING
 * ACCOUNT_IS_BLOCKED_FOR_PLANNING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccounts#PARTNER_COMPANY
 * PARTNER_COMPANY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccounts#FUNCTIONAL_AREA
 * FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccounts#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccounts#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccounts#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccounts#GL_ACCOUNT_TYPE
 * GL_ACCOUNT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccounts#GL_ACCOUNT_EXTERNAL
 * GL_ACCOUNT_EXTERNAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.financialplanningentryitem.GLAccountInChartOfAccounts#IS_PROFIT_LOSS_ACCOUNT
 * IS_PROFIT_LOSS_ACCOUNT}</li>
 * </ul>
 *
 */
public interface GLAccountInChartOfAccountsSelectable extends EntitySelectable<GLAccountInChartOfAccounts>
{

}
