/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionalarea;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionalarea.field.FunctionalAreaTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionalarea.link.FunctionalAreaTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionalarea.selectable.FunctionalAreaTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Functional Area Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_FunctionalAreaTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FunctionalAreaText extends VdmEntity<FunctionalAreaText>
{

    /**
     * Selector for all available fields of FunctionalAreaText.
     *
     */
    public final static FunctionalAreaTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static FunctionalAreaTextField<String> LANGUAGE = new FunctionalAreaTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @return Functional Area
     */
    @Key
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static FunctionalAreaTextField<String> FUNCTIONAL_AREA =
        new FunctionalAreaTextField<String>("FunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalAreaName</b>
     * </p>
     *
     * @return Name of the Functional Area
     */
    @SerializedName( "FunctionalAreaName" )
    @JsonProperty( "FunctionalAreaName" )
    @Nullable
    @ODataField( odataName = "FunctionalAreaName" )
    private String functionalAreaName;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalAreaName</b> field to query operations.
     *
     */
    public final static FunctionalAreaTextField<String> FUNCTIONAL_AREA_NAME =
        new FunctionalAreaTextField<String>("FunctionalAreaName");
    /**
     * Navigation property <b>to_FunctionalArea</b> for <b>FunctionalAreaText</b> to single <b>FunctionalArea</b>.
     *
     */
    @SerializedName( "to_FunctionalArea" )
    @JsonProperty( "to_FunctionalArea" )
    @ODataField( odataName = "to_FunctionalArea" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private FunctionalArea toFunctionalArea;
    /**
     * Use with available fluent helpers to apply the <b>to_FunctionalArea</b> navigation property to query operations.
     *
     */
    public final static FunctionalAreaTextOneToOneLink<FunctionalArea> TO_FUNCTIONAL_AREA =
        new FunctionalAreaTextOneToOneLink<FunctionalArea>("to_FunctionalArea");

    @Nonnull
    @Override
    public Class<FunctionalAreaText> getType()
    {
        return FunctionalAreaText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @param functionalArea
     *            Functional Area
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalAreaName</b>
     * </p>
     *
     * @param functionalAreaName
     *            Name of the Functional Area
     */
    public void setFunctionalAreaName( @Nullable final String functionalAreaName )
    {
        rememberChangedField("FunctionalAreaName", this.functionalAreaName);
        this.functionalAreaName = functionalAreaName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_FunctionalAreaText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("FunctionalArea", getFunctionalArea());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("FunctionalAreaName", getFunctionalAreaName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("FunctionalAreaName") ) {
                final Object value = values.remove("FunctionalAreaName");
                if( (value == null) || (!value.equals(getFunctionalAreaName())) ) {
                    setFunctionalAreaName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_FunctionalArea") ) {
                final Object value = (values).remove("to_FunctionalArea");
                if( value instanceof Map ) {
                    if( toFunctionalArea == null ) {
                        toFunctionalArea = new FunctionalArea();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toFunctionalArea.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> FunctionalAreaTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FunctionalAreaTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FunctionalAreaTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FunctionalAreaTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.FunctionalAreaService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toFunctionalArea != null ) {
            (values).put("to_FunctionalArea", toFunctionalArea);
        }
        return values;
    }

    /**
     * Fetches the <b>FunctionalArea</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_FunctionalArea</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>FunctionalArea</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FunctionalArea fetchFunctionalArea()
    {
        return fetchFieldAsSingle("to_FunctionalArea", FunctionalArea.class);
    }

    /**
     * Retrieval of associated <b>FunctionalArea</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_FunctionalArea</b>.
     * <p>
     * If the navigation property <b>to_FunctionalArea</b> of a queried <b>FunctionalAreaText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FunctionalArea</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FunctionalArea getFunctionalAreaOrFetch()
    {
        if( toFunctionalArea == null ) {
            toFunctionalArea = fetchFunctionalArea();
        }
        return toFunctionalArea;
    }

    /**
     * Retrieval of associated <b>FunctionalArea</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_FunctionalArea</b>.
     * <p>
     * If the navigation property for an entity <b>FunctionalAreaText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_FunctionalArea</b> is already loaded, the result will
     *         contain the <b>FunctionalArea</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<FunctionalArea> getFunctionalAreaIfPresent()
    {
        return Option.of(toFunctionalArea);
    }

    /**
     * Overwrites the associated <b>FunctionalArea</b> entity for the loaded navigation property
     * <b>to_FunctionalArea</b>.
     *
     * @param value
     *            New <b>FunctionalArea</b> entity.
     */
    public void setFunctionalArea( final FunctionalArea value )
    {
        toFunctionalArea = value;
    }

    /**
     * Helper class to allow for fluent creation of FunctionalAreaText instances.
     *
     */
    public final static class FunctionalAreaTextBuilder
    {

        private FunctionalArea toFunctionalArea;
        private String functionalArea = null;

        private FunctionalAreaText.FunctionalAreaTextBuilder toFunctionalArea( final FunctionalArea value )
        {
            toFunctionalArea = value;
            return this;
        }

        /**
         * Navigation property <b>to_FunctionalArea</b> for <b>FunctionalAreaText</b> to single <b>FunctionalArea</b>.
         *
         * @param value
         *            The FunctionalArea to build this FunctionalAreaText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FunctionalAreaText.FunctionalAreaTextBuilder functionalArea( final FunctionalArea value )
        {
            return toFunctionalArea(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 16
         * <p>
         * Original property name from the Odata EDM: <b>FunctionalArea</b>
         * </p>
         *
         * @param value
         *            The functionalArea to build this FunctionalAreaText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FunctionalAreaText.FunctionalAreaTextBuilder functionalArea( final String value )
        {
            functionalArea = value;
            return this;
        }

    }

}
