/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionalarea.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link FunctionalAreaServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.FunctionalAreaService FunctionalAreaService}, allowing you
 * to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultFunctionalAreaServiceBatch
    extends
    BatchFluentHelperBasic<FunctionalAreaServiceBatch, FunctionalAreaServiceBatchChangeSet>
    implements
    FunctionalAreaServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.FunctionalAreaService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultFunctionalAreaServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultFunctionalAreaServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.FunctionalAreaService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.FunctionalAreaService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultFunctionalAreaServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultFunctionalAreaServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.FunctionalAreaService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultFunctionalAreaServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public FunctionalAreaServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultFunctionalAreaServiceBatchChangeSet(this, service);
    }

}
