/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionalarea.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link FunctionalAreaServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.FunctionalAreaService FunctionalAreaService}.
 *
 */
public class DefaultFunctionalAreaServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<FunctionalAreaServiceBatch, FunctionalAreaServiceBatchChangeSet>
    implements
    FunctionalAreaServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.FunctionalAreaService service;

    @SuppressWarnings( "deprecation" )
    DefaultFunctionalAreaServiceBatchChangeSet(
        @Nonnull final DefaultFunctionalAreaServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.FunctionalAreaService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultFunctionalAreaServiceBatchChangeSet getThis()
    {
        return this;
    }

}
