/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionalarea.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionalarea.FunctionalArea;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionalarea.FunctionalArea FunctionalArea}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionalarea.field.FunctionalAreaField
 * FunctionalAreaField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionalarea.link.FunctionalAreaLink
 * FunctionalAreaLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionalarea.FunctionalArea#FUNCTIONAL_AREA
 * FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionalarea.FunctionalArea#TO_TEXT TO_TEXT}</li>
 * </ul>
 *
 */
public interface FunctionalAreaSelectable extends EntitySelectable<FunctionalArea>
{

}
