/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionalarea.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionalarea.FunctionalAreaText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionalarea.FunctionalAreaText FunctionalAreaText}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionalarea.field.FunctionalAreaTextField
 * FunctionalAreaTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionalarea.link.FunctionalAreaTextLink
 * FunctionalAreaTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionalarea.FunctionalAreaText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionalarea.FunctionalAreaText#FUNCTIONAL_AREA
 * FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionalarea.FunctionalAreaText#FUNCTIONAL_AREA_NAME
 * FUNCTIONAL_AREA_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionalarea.FunctionalAreaText#TO_FUNCTIONAL_AREA
 * TO_FUNCTIONAL_AREA}</li>
 * </ul>
 *
 */
public interface FunctionalAreaTextSelectable extends EntitySelectable<FunctionalAreaText>
{

}
