/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.field.CharacteristicField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.link.CharacteristicLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.link.CharacteristicOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.selectable.CharacteristicSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Class Characteristics
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CharacteristicType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Characteristic extends VdmEntity<Characteristic>
{

    /**
     * Selector for all available fields of Characteristic.
     *
     */
    public final static CharacteristicSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 90
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @return Key of Object to be Classified
     */
    @Key
    @SerializedName( "FunctionalLocation" )
    @JsonProperty( "FunctionalLocation" )
    @Nullable
    @ODataField( odataName = "FunctionalLocation" )
    private String functionalLocation;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalLocation</b> field to query operations.
     *
     */
    public final static CharacteristicField<String> FUNCTIONAL_LOCATION =
        new CharacteristicField<String>("FunctionalLocation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassInternalID</b>
     * </p>
     *
     * @return Internal Class Number
     */
    @Key
    @SerializedName( "ClassInternalID" )
    @JsonProperty( "ClassInternalID" )
    @Nullable
    @ODataField( odataName = "ClassInternalID" )
    private String classInternalID;
    /**
     * Use with available fluent helpers to apply the <b>ClassInternalID</b> field to query operations.
     *
     */
    public final static CharacteristicField<String> CLASS_INTERNAL_ID =
        new CharacteristicField<String>("ClassInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharcInternalID</b>
     * </p>
     *
     * @return Characteristic Internal ID
     */
    @Key
    @SerializedName( "CharcInternalID" )
    @JsonProperty( "CharcInternalID" )
    @Nullable
    @ODataField( odataName = "CharcInternalID" )
    private String charcInternalID;
    /**
     * Use with available fluent helpers to apply the <b>CharcInternalID</b> field to query operations.
     *
     */
    public final static CharacteristicField<String> CHARC_INTERNAL_ID =
        new CharacteristicField<String>("CharcInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocationLabelName</b>
     * </p>
     *
     * @return Functional Location Label
     */
    @SerializedName( "FunctionalLocationLabelName" )
    @JsonProperty( "FunctionalLocationLabelName" )
    @Nullable
    @ODataField( odataName = "FunctionalLocationLabelName" )
    private String functionalLocationLabelName;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalLocationLabelName</b> field to query operations.
     *
     */
    public final static CharacteristicField<String> FUNCTIONAL_LOCATION_LABEL_NAME =
        new CharacteristicField<String>("FunctionalLocationLabelName");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Characteristic</b>
     * </p>
     *
     * @return Characteristic Name
     */
    @SerializedName( "Characteristic" )
    @JsonProperty( "Characteristic" )
    @Nullable
    @ODataField( odataName = "Characteristic" )
    private String characteristic;
    /**
     * Use with available fluent helpers to apply the <b>Characteristic</b> field to query operations.
     *
     */
    public final static CharacteristicField<String> CHARACTERISTIC = new CharacteristicField<String>("Characteristic");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CharcDataType</b>
     * </p>
     *
     * @return Data type of characteristic
     */
    @SerializedName( "CharcDataType" )
    @JsonProperty( "CharcDataType" )
    @Nullable
    @ODataField( odataName = "CharcDataType" )
    private String charcDataType;
    /**
     * Use with available fluent helpers to apply the <b>CharcDataType</b> field to query operations.
     *
     */
    public final static CharacteristicField<String> CHARC_DATA_TYPE = new CharacteristicField<String>("CharcDataType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @return The keyDate contained in this entity.
     */
    @SerializedName( "KeyDate" )
    @JsonProperty( "KeyDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "KeyDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime keyDate;
    /**
     * Use with available fluent helpers to apply the <b>KeyDate</b> field to query operations.
     *
     */
    public final static CharacteristicField<LocalDateTime> KEY_DATE = new CharacteristicField<LocalDateTime>("KeyDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static CharacteristicField<String> CHANGE_NUMBER = new CharacteristicField<String>("ChangeNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassType</b>
     * </p>
     *
     * @return Class Type
     */
    @SerializedName( "ClassType" )
    @JsonProperty( "ClassType" )
    @Nullable
    @ODataField( odataName = "ClassType" )
    private String classType;
    /**
     * Use with available fluent helpers to apply the <b>ClassType</b> field to query operations.
     *
     */
    public final static CharacteristicField<String> CLASS_TYPE = new CharacteristicField<String>("ClassType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassMaintAuthGrp</b>
     * </p>
     *
     * @return Class Maintenance Authorization Group
     */
    @SerializedName( "ClassMaintAuthGrp" )
    @JsonProperty( "ClassMaintAuthGrp" )
    @Nullable
    @ODataField( odataName = "ClassMaintAuthGrp" )
    private String classMaintAuthGrp;
    /**
     * Use with available fluent helpers to apply the <b>ClassMaintAuthGrp</b> field to query operations.
     *
     */
    public final static CharacteristicField<String> CLASS_MAINT_AUTH_GRP =
        new CharacteristicField<String>("ClassMaintAuthGrp");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassClassfctnAuthGrp</b>
     * </p>
     *
     * @return Classification Authorization Group
     */
    @SerializedName( "ClassClassfctnAuthGrp" )
    @JsonProperty( "ClassClassfctnAuthGrp" )
    @Nullable
    @ODataField( odataName = "ClassClassfctnAuthGrp" )
    private String classClassfctnAuthGrp;
    /**
     * Use with available fluent helpers to apply the <b>ClassClassfctnAuthGrp</b> field to query operations.
     *
     */
    public final static CharacteristicField<String> CLASS_CLASSFCTN_AUTH_GRP =
        new CharacteristicField<String>("ClassClassfctnAuthGrp");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Class</b>
     * </p>
     *
     * @return Class number
     */
    @SerializedName( "Class" )
    @JsonProperty( "Class" )
    @Nullable
    @ODataField( odataName = "Class" )
    private String classProperty;
    /**
     * Use with available fluent helpers to apply the <b>Class</b> field to query operations.
     *
     */
    public final static CharacteristicField<String> CLASS_PROPERTY = new CharacteristicField<String>("Class");
    /**
     * Navigation property <b>to_Class</b> for <b>Characteristic</b> to single <b>FunctionalLocationClass</b>.
     *
     */
    @SerializedName( "to_Class" )
    @JsonProperty( "to_Class" )
    @ODataField( odataName = "to_Class" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private FunctionalLocationClass toClass;
    /**
     * Navigation property <b>to_FunctionalLocation</b> for <b>Characteristic</b> to single <b>FunctionalLocation</b>.
     *
     */
    @SerializedName( "to_FunctionalLocation" )
    @JsonProperty( "to_FunctionalLocation" )
    @ODataField( odataName = "to_FunctionalLocation" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private FunctionalLocation toFunctionalLocation;
    /**
     * Navigation property <b>to_Value</b> for <b>Characteristic</b> to multiple <b>Value</b>.
     *
     */
    @SerializedName( "to_Value" )
    @JsonProperty( "to_Value" )
    @ODataField( odataName = "to_Value" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<Value> toValue;
    /**
     * Use with available fluent helpers to apply the <b>to_Class</b> navigation property to query operations.
     *
     */
    public final static CharacteristicOneToOneLink<FunctionalLocationClass> TO_CLASS =
        new CharacteristicOneToOneLink<FunctionalLocationClass>("to_Class");
    /**
     * Use with available fluent helpers to apply the <b>to_FunctionalLocation</b> navigation property to query
     * operations.
     *
     */
    public final static CharacteristicOneToOneLink<FunctionalLocation> TO_FUNCTIONAL_LOCATION =
        new CharacteristicOneToOneLink<FunctionalLocation>("to_FunctionalLocation");
    /**
     * Use with available fluent helpers to apply the <b>to_Value</b> navigation property to query operations.
     *
     */
    public final static CharacteristicLink<Value> TO_VALUE = new CharacteristicLink<Value>("to_Value");

    @Nonnull
    @Override
    public Class<Characteristic> getType()
    {
        return Characteristic.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 90
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @param functionalLocation
     *            Key of Object to be Classified
     */
    public void setFunctionalLocation( @Nullable final String functionalLocation )
    {
        rememberChangedField("FunctionalLocation", this.functionalLocation);
        this.functionalLocation = functionalLocation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassInternalID</b>
     * </p>
     *
     * @param classInternalID
     *            Internal Class Number
     */
    public void setClassInternalID( @Nullable final String classInternalID )
    {
        rememberChangedField("ClassInternalID", this.classInternalID);
        this.classInternalID = classInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharcInternalID</b>
     * </p>
     *
     * @param charcInternalID
     *            Characteristic Internal ID
     */
    public void setCharcInternalID( @Nullable final String charcInternalID )
    {
        rememberChangedField("CharcInternalID", this.charcInternalID);
        this.charcInternalID = charcInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocationLabelName</b>
     * </p>
     *
     * @param functionalLocationLabelName
     *            Functional Location Label
     */
    public void setFunctionalLocationLabelName( @Nullable final String functionalLocationLabelName )
    {
        rememberChangedField("FunctionalLocationLabelName", this.functionalLocationLabelName);
        this.functionalLocationLabelName = functionalLocationLabelName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Characteristic</b>
     * </p>
     *
     * @param characteristic
     *            Characteristic Name
     */
    public void setCharacteristic( @Nullable final String characteristic )
    {
        rememberChangedField("Characteristic", this.characteristic);
        this.characteristic = characteristic;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CharcDataType</b>
     * </p>
     *
     * @param charcDataType
     *            Data type of characteristic
     */
    public void setCharcDataType( @Nullable final String charcDataType )
    {
        rememberChangedField("CharcDataType", this.charcDataType);
        this.charcDataType = charcDataType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @param keyDate
     *            The keyDate to set.
     */
    public void setKeyDate( @Nullable final LocalDateTime keyDate )
    {
        rememberChangedField("KeyDate", this.keyDate);
        this.keyDate = keyDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassType</b>
     * </p>
     *
     * @param classType
     *            Class Type
     */
    public void setClassType( @Nullable final String classType )
    {
        rememberChangedField("ClassType", this.classType);
        this.classType = classType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassMaintAuthGrp</b>
     * </p>
     *
     * @param classMaintAuthGrp
     *            Class Maintenance Authorization Group
     */
    public void setClassMaintAuthGrp( @Nullable final String classMaintAuthGrp )
    {
        rememberChangedField("ClassMaintAuthGrp", this.classMaintAuthGrp);
        this.classMaintAuthGrp = classMaintAuthGrp;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassClassfctnAuthGrp</b>
     * </p>
     *
     * @param classClassfctnAuthGrp
     *            Classification Authorization Group
     */
    public void setClassClassfctnAuthGrp( @Nullable final String classClassfctnAuthGrp )
    {
        rememberChangedField("ClassClassfctnAuthGrp", this.classClassfctnAuthGrp);
        this.classClassfctnAuthGrp = classClassfctnAuthGrp;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Class</b>
     * </p>
     *
     * @param classProperty
     *            Class number
     */
    public void setClassProperty( @Nullable final String classProperty )
    {
        rememberChangedField("Class", this.classProperty);
        this.classProperty = classProperty;
    }

    @Override
    protected String getEntityCollection()
    {
        return "Characteristic";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("FunctionalLocation", getFunctionalLocation());
        result.put("ClassInternalID", getClassInternalID());
        result.put("CharcInternalID", getCharcInternalID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("FunctionalLocation", getFunctionalLocation());
        values.put("ClassInternalID", getClassInternalID());
        values.put("CharcInternalID", getCharcInternalID());
        values.put("FunctionalLocationLabelName", getFunctionalLocationLabelName());
        values.put("Characteristic", getCharacteristic());
        values.put("CharcDataType", getCharcDataType());
        values.put("KeyDate", getKeyDate());
        values.put("ChangeNumber", getChangeNumber());
        values.put("ClassType", getClassType());
        values.put("ClassMaintAuthGrp", getClassMaintAuthGrp());
        values.put("ClassClassfctnAuthGrp", getClassClassfctnAuthGrp());
        values.put("Class", getClassProperty());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("FunctionalLocation") ) {
                final Object value = values.remove("FunctionalLocation");
                if( (value == null) || (!value.equals(getFunctionalLocation())) ) {
                    setFunctionalLocation(((String) value));
                }
            }
            if( values.containsKey("ClassInternalID") ) {
                final Object value = values.remove("ClassInternalID");
                if( (value == null) || (!value.equals(getClassInternalID())) ) {
                    setClassInternalID(((String) value));
                }
            }
            if( values.containsKey("CharcInternalID") ) {
                final Object value = values.remove("CharcInternalID");
                if( (value == null) || (!value.equals(getCharcInternalID())) ) {
                    setCharcInternalID(((String) value));
                }
            }
            if( values.containsKey("FunctionalLocationLabelName") ) {
                final Object value = values.remove("FunctionalLocationLabelName");
                if( (value == null) || (!value.equals(getFunctionalLocationLabelName())) ) {
                    setFunctionalLocationLabelName(((String) value));
                }
            }
            if( values.containsKey("Characteristic") ) {
                final Object value = values.remove("Characteristic");
                if( (value == null) || (!value.equals(getCharacteristic())) ) {
                    setCharacteristic(((String) value));
                }
            }
            if( values.containsKey("CharcDataType") ) {
                final Object value = values.remove("CharcDataType");
                if( (value == null) || (!value.equals(getCharcDataType())) ) {
                    setCharcDataType(((String) value));
                }
            }
            if( values.containsKey("KeyDate") ) {
                final Object value = values.remove("KeyDate");
                if( (value == null) || (!value.equals(getKeyDate())) ) {
                    setKeyDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("ClassType") ) {
                final Object value = values.remove("ClassType");
                if( (value == null) || (!value.equals(getClassType())) ) {
                    setClassType(((String) value));
                }
            }
            if( values.containsKey("ClassMaintAuthGrp") ) {
                final Object value = values.remove("ClassMaintAuthGrp");
                if( (value == null) || (!value.equals(getClassMaintAuthGrp())) ) {
                    setClassMaintAuthGrp(((String) value));
                }
            }
            if( values.containsKey("ClassClassfctnAuthGrp") ) {
                final Object value = values.remove("ClassClassfctnAuthGrp");
                if( (value == null) || (!value.equals(getClassClassfctnAuthGrp())) ) {
                    setClassClassfctnAuthGrp(((String) value));
                }
            }
            if( values.containsKey("Class") ) {
                final Object value = values.remove("Class");
                if( (value == null) || (!value.equals(getClassProperty())) ) {
                    setClassProperty(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Class") ) {
                final Object value = (values).remove("to_Class");
                if( value instanceof Map ) {
                    if( toClass == null ) {
                        toClass = new FunctionalLocationClass();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toClass.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_FunctionalLocation") ) {
                final Object value = (values).remove("to_FunctionalLocation");
                if( value instanceof Map ) {
                    if( toFunctionalLocation == null ) {
                        toFunctionalLocation = new FunctionalLocation();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toFunctionalLocation.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Value") ) {
                final Object value = (values).remove("to_Value");
                if( value instanceof Iterable ) {
                    if( toValue == null ) {
                        toValue = Lists.newArrayList();
                    } else {
                        toValue = Lists.newArrayList(toValue);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        Value entity;
                        if( toValue.size() > i ) {
                            entity = toValue.get(i);
                        } else {
                            entity = new Value();
                            toValue.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CharacteristicField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CharacteristicField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CharacteristicField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CharacteristicField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.FunctionalLocationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toClass != null ) {
            (values).put("to_Class", toClass);
        }
        if( toFunctionalLocation != null ) {
            (values).put("to_FunctionalLocation", toFunctionalLocation);
        }
        if( toValue != null ) {
            (values).put("to_Value", toValue);
        }
        return values;
    }

    /**
     * Fetches the <b>FunctionalLocationClass</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Class</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>FunctionalLocationClass</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FunctionalLocationClass fetchClassObjects()
    {
        return fetchFieldAsSingle("to_Class", FunctionalLocationClass.class);
    }

    /**
     * Retrieval of associated <b>FunctionalLocationClass</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Class</b>.
     * <p>
     * If the navigation property <b>to_Class</b> of a queried <b>Characteristic</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FunctionalLocationClass</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FunctionalLocationClass getClassObjectsOrFetch()
    {
        if( toClass == null ) {
            toClass = fetchClassObjects();
        }
        return toClass;
    }

    /**
     * Retrieval of associated <b>FunctionalLocationClass</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Class</b>.
     * <p>
     * If the navigation property for an entity <b>Characteristic</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Class</b> is already loaded, the result will contain the
     *         <b>FunctionalLocationClass</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<FunctionalLocationClass> getClassObjectsIfPresent()
    {
        return Option.of(toClass);
    }

    /**
     * Overwrites the associated <b>FunctionalLocationClass</b> entity for the loaded navigation property
     * <b>to_Class</b>.
     *
     * @param value
     *            New <b>FunctionalLocationClass</b> entity.
     */
    public void setClassObjects( final FunctionalLocationClass value )
    {
        toClass = value;
    }

    /**
     * Fetches the <b>FunctionalLocation</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_FunctionalLocation</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>FunctionalLocation</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FunctionalLocation fetchFunctionalLocation()
    {
        return fetchFieldAsSingle("to_FunctionalLocation", FunctionalLocation.class);
    }

    /**
     * Retrieval of associated <b>FunctionalLocation</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_FunctionalLocation</b>.
     * <p>
     * If the navigation property <b>to_FunctionalLocation</b> of a queried <b>Characteristic</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FunctionalLocation</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FunctionalLocation getFunctionalLocationOrFetch()
    {
        if( toFunctionalLocation == null ) {
            toFunctionalLocation = fetchFunctionalLocation();
        }
        return toFunctionalLocation;
    }

    /**
     * Retrieval of associated <b>FunctionalLocation</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_FunctionalLocation</b>.
     * <p>
     * If the navigation property for an entity <b>Characteristic</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_FunctionalLocation</b> is already loaded, the result
     *         will contain the <b>FunctionalLocation</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<FunctionalLocation> getFunctionalLocationIfPresent()
    {
        return Option.of(toFunctionalLocation);
    }

    /**
     * Overwrites the associated <b>FunctionalLocation</b> entity for the loaded navigation property
     * <b>to_FunctionalLocation</b>.
     *
     * @param value
     *            New <b>FunctionalLocation</b> entity.
     */
    public void setFunctionalLocation( final FunctionalLocation value )
    {
        toFunctionalLocation = value;
    }

    /**
     * Fetches the <b>Value</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Value</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>Value</b> entities. If no entities are associated then an empty
     *         list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<Value> fetchValue()
    {
        return fetchFieldAsList("to_Value", Value.class);
    }

    /**
     * Retrieval of associated <b>Value</b> entities (one to many). This corresponds to the OData navigation property
     * <b>to_Value</b>.
     * <p>
     * If the navigation property <b>to_Value</b> of a queried <b>Characteristic</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Value</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<Value> getValueOrFetch()
    {
        if( toValue == null ) {
            toValue = fetchValue();
        }
        return toValue;
    }

    /**
     * Retrieval of associated <b>Value</b> entities (one to many). This corresponds to the OData navigation property
     * <b>to_Value</b>.
     * <p>
     * If the navigation property for an entity <b>Characteristic</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Value</b> is already loaded, the result will contain the
     *         <b>Value</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<Value>> getValueIfPresent()
    {
        return Option.of(toValue);
    }

    /**
     * Overwrites the list of associated <b>Value</b> entities for the loaded navigation property <b>to_Value</b>.
     * <p>
     * If the navigation property <b>to_Value</b> of a queried <b>Characteristic</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>Value</b> entities.
     */
    public void setValue( @Nonnull final List<Value> value )
    {
        if( toValue == null ) {
            toValue = Lists.newArrayList();
        }
        toValue.clear();
        toValue.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>Value</b> entities. This corresponds to the OData navigation property
     * <b>to_Value</b>.
     * <p>
     * If the navigation property <b>to_Value</b> of a queried <b>Characteristic</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>Value</b> entities.
     */
    public void addValue( Value... entity )
    {
        if( toValue == null ) {
            toValue = Lists.newArrayList();
        }
        toValue.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of Characteristic instances.
     *
     */
    public final static class CharacteristicBuilder
    {

        private FunctionalLocationClass toClass;
        private String classProperty = null;
        private FunctionalLocation toFunctionalLocation;
        private String functionalLocation = null;
        private List<Value> toValue = Lists.newArrayList();

        private Characteristic.CharacteristicBuilder toClass( final FunctionalLocationClass value )
        {
            toClass = value;
            return this;
        }

        /**
         * Navigation property <b>to_Class</b> for <b>Characteristic</b> to single <b>FunctionalLocationClass</b>.
         *
         * @param value
         *            The FunctionalLocationClass to build this Characteristic with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Characteristic.CharacteristicBuilder classProperty( final FunctionalLocationClass value )
        {
            return toClass(value);
        }

        /**
         * Constraints: Not nullable, Maximum length: 18
         * <p>
         * Original property name from the Odata EDM: <b>Class</b>
         * </p>
         *
         * @param value
         *            The classProperty to build this Characteristic with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Characteristic.CharacteristicBuilder classProperty( final String value )
        {
            classProperty = value;
            return this;
        }

        private Characteristic.CharacteristicBuilder toFunctionalLocation( final FunctionalLocation value )
        {
            toFunctionalLocation = value;
            return this;
        }

        /**
         * Navigation property <b>to_FunctionalLocation</b> for <b>Characteristic</b> to single
         * <b>FunctionalLocation</b>.
         *
         * @param value
         *            The FunctionalLocation to build this Characteristic with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Characteristic.CharacteristicBuilder functionalLocation( final FunctionalLocation value )
        {
            return toFunctionalLocation(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 90
         * <p>
         * Original property name from the Odata EDM: <b>FunctionalLocation</b>
         * </p>
         *
         * @param value
         *            The functionalLocation to build this Characteristic with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Characteristic.CharacteristicBuilder functionalLocation( final String value )
        {
            functionalLocation = value;
            return this;
        }

        private Characteristic.CharacteristicBuilder toValue( final List<Value> value )
        {
            toValue.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Value</b> for <b>Characteristic</b> to multiple <b>Value</b>.
         *
         * @param value
         *            The Values to build this Characteristic with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Characteristic.CharacteristicBuilder value( Value... value )
        {
            return toValue(Lists.newArrayList(value));
        }

    }

}
