/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperCreate;

/**
 * Fluent helper to create a new
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation FunctionalLocation}
 * entity and save it to the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class FunctionalLocationCreateFluentHelper
    extends
    FluentHelperCreate<FunctionalLocationCreateFluentHelper, FunctionalLocation>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation
     * FunctionalLocation} entity object that will be created in the S/4HANA system.
     *
     */
    private final FunctionalLocation entity;

    /**
     * Creates a fluent helper object that will create a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation
     * FunctionalLocation} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to direct the create requests to.
     * @param servicePath
     *            The service path to direct the create requests to.
     * @param entity
     *            The FunctionalLocation to create.
     */
    public FunctionalLocationCreateFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final FunctionalLocation entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected FunctionalLocation getEntity()
    {
        return entity;
    }

}
