/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.field.FunctionalLocationLongTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.link.FunctionalLocationLongTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.selectable.FunctionalLocationLongTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Functional Location Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FunctionalLocationLongTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FunctionalLocationLongText extends VdmEntity<FunctionalLocationLongText>
{

    /**
     * Selector for all available fields of FunctionalLocationLongText.
     *
     */
    public final static FunctionalLocationLongTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @return Functional location
     */
    @Key
    @SerializedName( "FunctionalLocation" )
    @JsonProperty( "FunctionalLocation" )
    @Nullable
    @ODataField( odataName = "FunctionalLocation" )
    private String functionalLocation;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalLocation</b> field to query operations.
     *
     */
    public final static FunctionalLocationLongTextField<String> FUNCTIONAL_LOCATION =
        new FunctionalLocationLongTextField<String>("FunctionalLocation");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocationLabelName</b>
     * </p>
     *
     * @return Functional Location Label
     */
    @SerializedName( "FunctionalLocationLabelName" )
    @JsonProperty( "FunctionalLocationLabelName" )
    @Nullable
    @ODataField( odataName = "FunctionalLocationLabelName" )
    private String functionalLocationLabelName;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalLocationLabelName</b> field to query operations.
     *
     */
    public final static FunctionalLocationLongTextField<String> FUNCTIONAL_LOCATION_LABEL_NAME =
        new FunctionalLocationLongTextField<String>("FunctionalLocationLabelName");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>TextObjectKey</b>
     * </p>
     *
     * @return Functional location
     */
    @SerializedName( "TextObjectKey" )
    @JsonProperty( "TextObjectKey" )
    @Nullable
    @ODataField( odataName = "TextObjectKey" )
    private String textObjectKey;
    /**
     * Use with available fluent helpers to apply the <b>TextObjectKey</b> field to query operations.
     *
     */
    public final static FunctionalLocationLongTextField<String> TEXT_OBJECT_KEY =
        new FunctionalLocationLongTextField<String>("TextObjectKey");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static FunctionalLocationLongTextField<String> LANGUAGE =
        new FunctionalLocationLongTextField<String>("Language");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FuncnlLocLongText</b>
     * </p>
     *
     * @return Long Text
     */
    @SerializedName( "FuncnlLocLongText" )
    @JsonProperty( "FuncnlLocLongText" )
    @Nullable
    @ODataField( odataName = "FuncnlLocLongText" )
    private String funcnlLocLongText;
    /**
     * Use with available fluent helpers to apply the <b>FuncnlLocLongText</b> field to query operations.
     *
     */
    public final static FunctionalLocationLongTextField<String> FUNCNL_LOC_LONG_TEXT =
        new FunctionalLocationLongTextField<String>("FuncnlLocLongText");
    /**
     * Navigation property <b>to_FunctionalLocation</b> for <b>FunctionalLocationLongText</b> to single
     * <b>FunctionalLocation</b>.
     *
     */
    @SerializedName( "to_FunctionalLocation" )
    @JsonProperty( "to_FunctionalLocation" )
    @ODataField( odataName = "to_FunctionalLocation" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private FunctionalLocation toFunctionalLocation;
    /**
     * Use with available fluent helpers to apply the <b>to_FunctionalLocation</b> navigation property to query
     * operations.
     *
     */
    public final static FunctionalLocationLongTextOneToOneLink<FunctionalLocation> TO_FUNCTIONAL_LOCATION =
        new FunctionalLocationLongTextOneToOneLink<FunctionalLocation>("to_FunctionalLocation");

    @Nonnull
    @Override
    public Class<FunctionalLocationLongText> getType()
    {
        return FunctionalLocationLongText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @param functionalLocation
     *            Functional location
     */
    public void setFunctionalLocation( @Nullable final String functionalLocation )
    {
        rememberChangedField("FunctionalLocation", this.functionalLocation);
        this.functionalLocation = functionalLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocationLabelName</b>
     * </p>
     *
     * @param functionalLocationLabelName
     *            Functional Location Label
     */
    public void setFunctionalLocationLabelName( @Nullable final String functionalLocationLabelName )
    {
        rememberChangedField("FunctionalLocationLabelName", this.functionalLocationLabelName);
        this.functionalLocationLabelName = functionalLocationLabelName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>TextObjectKey</b>
     * </p>
     *
     * @param textObjectKey
     *            Functional location
     */
    public void setTextObjectKey( @Nullable final String textObjectKey )
    {
        rememberChangedField("TextObjectKey", this.textObjectKey);
        this.textObjectKey = textObjectKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FuncnlLocLongText</b>
     * </p>
     *
     * @param funcnlLocLongText
     *            Long Text
     */
    public void setFuncnlLocLongText( @Nullable final String funcnlLocLongText )
    {
        rememberChangedField("FuncnlLocLongText", this.funcnlLocLongText);
        this.funcnlLocLongText = funcnlLocLongText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FunctionalLocationLongText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("FunctionalLocation", getFunctionalLocation());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("FunctionalLocation", getFunctionalLocation());
        values.put("FunctionalLocationLabelName", getFunctionalLocationLabelName());
        values.put("TextObjectKey", getTextObjectKey());
        values.put("Language", getLanguage());
        values.put("FuncnlLocLongText", getFuncnlLocLongText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("FunctionalLocation") ) {
                final Object value = values.remove("FunctionalLocation");
                if( (value == null) || (!value.equals(getFunctionalLocation())) ) {
                    setFunctionalLocation(((String) value));
                }
            }
            if( values.containsKey("FunctionalLocationLabelName") ) {
                final Object value = values.remove("FunctionalLocationLabelName");
                if( (value == null) || (!value.equals(getFunctionalLocationLabelName())) ) {
                    setFunctionalLocationLabelName(((String) value));
                }
            }
            if( values.containsKey("TextObjectKey") ) {
                final Object value = values.remove("TextObjectKey");
                if( (value == null) || (!value.equals(getTextObjectKey())) ) {
                    setTextObjectKey(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("FuncnlLocLongText") ) {
                final Object value = values.remove("FuncnlLocLongText");
                if( (value == null) || (!value.equals(getFuncnlLocLongText())) ) {
                    setFuncnlLocLongText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_FunctionalLocation") ) {
                final Object value = (values).remove("to_FunctionalLocation");
                if( value instanceof Map ) {
                    if( toFunctionalLocation == null ) {
                        toFunctionalLocation = new FunctionalLocation();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toFunctionalLocation.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> FunctionalLocationLongTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new FunctionalLocationLongTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FunctionalLocationLongTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FunctionalLocationLongTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.FunctionalLocationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toFunctionalLocation != null ) {
            (values).put("to_FunctionalLocation", toFunctionalLocation);
        }
        return values;
    }

    /**
     * Fetches the <b>FunctionalLocation</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_FunctionalLocation</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>FunctionalLocation</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FunctionalLocation fetchFunctionalLocation()
    {
        return fetchFieldAsSingle("to_FunctionalLocation", FunctionalLocation.class);
    }

    /**
     * Retrieval of associated <b>FunctionalLocation</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_FunctionalLocation</b>.
     * <p>
     * If the navigation property <b>to_FunctionalLocation</b> of a queried <b>FunctionalLocationLongText</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FunctionalLocation</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FunctionalLocation getFunctionalLocationOrFetch()
    {
        if( toFunctionalLocation == null ) {
            toFunctionalLocation = fetchFunctionalLocation();
        }
        return toFunctionalLocation;
    }

    /**
     * Retrieval of associated <b>FunctionalLocation</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_FunctionalLocation</b>.
     * <p>
     * If the navigation property for an entity <b>FunctionalLocationLongText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_FunctionalLocation</b> is already loaded, the result
     *         will contain the <b>FunctionalLocation</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<FunctionalLocation> getFunctionalLocationIfPresent()
    {
        return Option.of(toFunctionalLocation);
    }

    /**
     * Overwrites the associated <b>FunctionalLocation</b> entity for the loaded navigation property
     * <b>to_FunctionalLocation</b>.
     *
     * @param value
     *            New <b>FunctionalLocation</b> entity.
     */
    public void setFunctionalLocation( final FunctionalLocation value )
    {
        toFunctionalLocation = value;
    }

    /**
     * Helper class to allow for fluent creation of FunctionalLocationLongText instances.
     *
     */
    public final static class FunctionalLocationLongTextBuilder
    {

        private FunctionalLocation toFunctionalLocation;
        private String functionalLocation = null;

        private FunctionalLocationLongText.FunctionalLocationLongTextBuilder toFunctionalLocation(
            final FunctionalLocation value )
        {
            toFunctionalLocation = value;
            return this;
        }

        /**
         * Navigation property <b>to_FunctionalLocation</b> for <b>FunctionalLocationLongText</b> to single
         * <b>FunctionalLocation</b>.
         *
         * @param value
         *            The FunctionalLocation to build this FunctionalLocationLongText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FunctionalLocationLongText.FunctionalLocationLongTextBuilder functionalLocation(
            final FunctionalLocation value )
        {
            return toFunctionalLocation(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 30
         * <p>
         * Original property name from the Odata EDM: <b>FunctionalLocation</b>
         * </p>
         *
         * @param value
         *            The functionalLocation to build this FunctionalLocationLongText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FunctionalLocationLongText.FunctionalLocationLongTextBuilder functionalLocation( final String value )
        {
            functionalLocation = value;
            return this;
        }

    }

}
