/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.selectable.FunctionalLocationLongTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongText
 * FunctionalLocationLongText} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class FunctionalLocationLongTextByKeyFluentHelper
    extends
    FluentHelperByKey<FunctionalLocationLongTextByKeyFluentHelper, FunctionalLocationLongText, FunctionalLocationLongTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongText
     * FunctionalLocationLongText} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code FunctionalLocationLongText}
     * @param servicePath
     *            Service path to be used to fetch a single {@code FunctionalLocationLongText}
     * @param functionalLocation
     *            Functional location
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     */
    public FunctionalLocationLongTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String functionalLocation )
    {
        super(servicePath, entityCollection);
        this.key.put("FunctionalLocation", functionalLocation);
    }

    @Override
    @Nonnull
    protected Class<FunctionalLocationLongText> getEntityClass()
    {
        return FunctionalLocationLongText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
