/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.field.FunctionalLocationPartnerField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.link.FunctionalLocationPartnerOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.selectable.FunctionalLocationPartnerSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Functional Location Partner
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FunctionalLocationPartnerType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FunctionalLocationPartner extends VdmEntity<FunctionalLocationPartner>
{

    /**
     * Selector for all available fields of FunctionalLocationPartner.
     *
     */
    public final static FunctionalLocationPartnerSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @return Functional location
     */
    @Key
    @SerializedName( "FunctionalLocation" )
    @JsonProperty( "FunctionalLocation" )
    @Nullable
    @ODataField( odataName = "FunctionalLocation" )
    private String functionalLocation;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalLocation</b> field to query operations.
     *
     */
    public final static FunctionalLocationPartnerField<String> FUNCTIONAL_LOCATION =
        new FunctionalLocationPartnerField<String>("FunctionalLocation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @return Partner Function
     */
    @Key
    @SerializedName( "PartnerFunction" )
    @JsonProperty( "PartnerFunction" )
    @Nullable
    @ODataField( odataName = "PartnerFunction" )
    private String partnerFunction;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunction</b> field to query operations.
     *
     */
    public final static FunctionalLocationPartnerField<String> PARTNER_FUNCTION =
        new FunctionalLocationPartnerField<String>("PartnerFunction");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>FuncnlLocPartnerObjectNmbr</b>
     * </p>
     *
     * @return Counter for differentiation 6-digit
     */
    @Key
    @SerializedName( "FuncnlLocPartnerObjectNmbr" )
    @JsonProperty( "FuncnlLocPartnerObjectNmbr" )
    @Nullable
    @ODataField( odataName = "FuncnlLocPartnerObjectNmbr" )
    private String funcnlLocPartnerObjectNmbr;
    /**
     * Use with available fluent helpers to apply the <b>FuncnlLocPartnerObjectNmbr</b> field to query operations.
     *
     */
    public final static FunctionalLocationPartnerField<String> FUNCNL_LOC_PARTNER_OBJECT_NMBR =
        new FunctionalLocationPartnerField<String>("FuncnlLocPartnerObjectNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocationLabelName</b>
     * </p>
     *
     * @return Functional Location Label
     */
    @SerializedName( "FunctionalLocationLabelName" )
    @JsonProperty( "FunctionalLocationLabelName" )
    @Nullable
    @ODataField( odataName = "FunctionalLocationLabelName" )
    private String functionalLocationLabelName;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalLocationLabelName</b> field to query operations.
     *
     */
    public final static FunctionalLocationPartnerField<String> FUNCTIONAL_LOCATION_LABEL_NAME =
        new FunctionalLocationPartnerField<String>("FunctionalLocationLabelName");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Partner</b>
     * </p>
     *
     * @return Partner
     */
    @SerializedName( "Partner" )
    @JsonProperty( "Partner" )
    @Nullable
    @ODataField( odataName = "Partner" )
    private String partner;
    /**
     * Use with available fluent helpers to apply the <b>Partner</b> field to query operations.
     *
     */
    public final static FunctionalLocationPartnerField<String> PARTNER =
        new FunctionalLocationPartnerField<String>("Partner");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of Person Responsible for Creating the Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static FunctionalLocationPartnerField<String> CREATED_BY_USER =
        new FunctionalLocationPartnerField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static FunctionalLocationPartnerField<LocalDateTime> CREATION_DATE =
        new FunctionalLocationPartnerField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @return Time at Which Record Was Added
     */
    @SerializedName( "CreationTime" )
    @JsonProperty( "CreationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CreationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime creationTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationTime</b> field to query operations.
     *
     */
    public final static FunctionalLocationPartnerField<LocalTime> CREATION_TIME =
        new FunctionalLocationPartnerField<LocalTime>("CreationTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Name of Person Who Changed Object
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static FunctionalLocationPartnerField<String> LAST_CHANGED_BY_USER =
        new FunctionalLocationPartnerField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeTime</b>
     * </p>
     *
     * @return Time of Change
     */
    @SerializedName( "LastChangeTime" )
    @JsonProperty( "LastChangeTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime lastChangeTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeTime</b> field to query operations.
     *
     */
    public final static FunctionalLocationPartnerField<LocalTime> LAST_CHANGE_TIME =
        new FunctionalLocationPartnerField<LocalTime>("LastChangeTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static FunctionalLocationPartnerField<LocalDateTime> LAST_CHANGE_DATE =
        new FunctionalLocationPartnerField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjectInternalID</b>
     * </p>
     *
     * @return Object Number
     */
    @SerializedName( "MaintObjectInternalID" )
    @JsonProperty( "MaintObjectInternalID" )
    @Nullable
    @ODataField( odataName = "MaintObjectInternalID" )
    private String maintObjectInternalID;
    /**
     * Use with available fluent helpers to apply the <b>MaintObjectInternalID</b> field to query operations.
     *
     */
    public final static FunctionalLocationPartnerField<String> MAINT_OBJECT_INTERNAL_ID =
        new FunctionalLocationPartnerField<String>("MaintObjectInternalID");
    /**
     * Navigation property <b>to_FunctionalLocation</b> for <b>FunctionalLocationPartner</b> to single
     * <b>FunctionalLocation</b>.
     *
     */
    @SerializedName( "to_FunctionalLocation" )
    @JsonProperty( "to_FunctionalLocation" )
    @ODataField( odataName = "to_FunctionalLocation" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private FunctionalLocation toFunctionalLocation;
    /**
     * Use with available fluent helpers to apply the <b>to_FunctionalLocation</b> navigation property to query
     * operations.
     *
     */
    public final static FunctionalLocationPartnerOneToOneLink<FunctionalLocation> TO_FUNCTIONAL_LOCATION =
        new FunctionalLocationPartnerOneToOneLink<FunctionalLocation>("to_FunctionalLocation");

    @Nonnull
    @Override
    public Class<FunctionalLocationPartner> getType()
    {
        return FunctionalLocationPartner.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @param functionalLocation
     *            Functional location
     */
    public void setFunctionalLocation( @Nullable final String functionalLocation )
    {
        rememberChangedField("FunctionalLocation", this.functionalLocation);
        this.functionalLocation = functionalLocation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @param partnerFunction
     *            Partner Function
     */
    public void setPartnerFunction( @Nullable final String partnerFunction )
    {
        rememberChangedField("PartnerFunction", this.partnerFunction);
        this.partnerFunction = partnerFunction;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>FuncnlLocPartnerObjectNmbr</b>
     * </p>
     *
     * @param funcnlLocPartnerObjectNmbr
     *            Counter for differentiation 6-digit
     */
    public void setFuncnlLocPartnerObjectNmbr( @Nullable final String funcnlLocPartnerObjectNmbr )
    {
        rememberChangedField("FuncnlLocPartnerObjectNmbr", this.funcnlLocPartnerObjectNmbr);
        this.funcnlLocPartnerObjectNmbr = funcnlLocPartnerObjectNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocationLabelName</b>
     * </p>
     *
     * @param functionalLocationLabelName
     *            Functional Location Label
     */
    public void setFunctionalLocationLabelName( @Nullable final String functionalLocationLabelName )
    {
        rememberChangedField("FunctionalLocationLabelName", this.functionalLocationLabelName);
        this.functionalLocationLabelName = functionalLocationLabelName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Partner</b>
     * </p>
     *
     * @param partner
     *            Partner
     */
    public void setPartner( @Nullable final String partner )
    {
        rememberChangedField("Partner", this.partner);
        this.partner = partner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of Person Responsible for Creating the Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @param creationTime
     *            Time at Which Record Was Added
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Name of Person Who Changed Object
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeTime</b>
     * </p>
     *
     * @param lastChangeTime
     *            Time of Change
     */
    public void setLastChangeTime( @Nullable final LocalTime lastChangeTime )
    {
        rememberChangedField("LastChangeTime", this.lastChangeTime);
        this.lastChangeTime = lastChangeTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjectInternalID</b>
     * </p>
     *
     * @param maintObjectInternalID
     *            Object Number
     */
    public void setMaintObjectInternalID( @Nullable final String maintObjectInternalID )
    {
        rememberChangedField("MaintObjectInternalID", this.maintObjectInternalID);
        this.maintObjectInternalID = maintObjectInternalID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FunctionalLocationPartner";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("FunctionalLocation", getFunctionalLocation());
        result.put("PartnerFunction", getPartnerFunction());
        result.put("FuncnlLocPartnerObjectNmbr", getFuncnlLocPartnerObjectNmbr());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("FunctionalLocation", getFunctionalLocation());
        values.put("PartnerFunction", getPartnerFunction());
        values.put("FuncnlLocPartnerObjectNmbr", getFuncnlLocPartnerObjectNmbr());
        values.put("FunctionalLocationLabelName", getFunctionalLocationLabelName());
        values.put("Partner", getPartner());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeTime", getLastChangeTime());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("MaintObjectInternalID", getMaintObjectInternalID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("FunctionalLocation") ) {
                final Object value = values.remove("FunctionalLocation");
                if( (value == null) || (!value.equals(getFunctionalLocation())) ) {
                    setFunctionalLocation(((String) value));
                }
            }
            if( values.containsKey("PartnerFunction") ) {
                final Object value = values.remove("PartnerFunction");
                if( (value == null) || (!value.equals(getPartnerFunction())) ) {
                    setPartnerFunction(((String) value));
                }
            }
            if( values.containsKey("FuncnlLocPartnerObjectNmbr") ) {
                final Object value = values.remove("FuncnlLocPartnerObjectNmbr");
                if( (value == null) || (!value.equals(getFuncnlLocPartnerObjectNmbr())) ) {
                    setFuncnlLocPartnerObjectNmbr(((String) value));
                }
            }
            if( values.containsKey("FunctionalLocationLabelName") ) {
                final Object value = values.remove("FunctionalLocationLabelName");
                if( (value == null) || (!value.equals(getFunctionalLocationLabelName())) ) {
                    setFunctionalLocationLabelName(((String) value));
                }
            }
            if( values.containsKey("Partner") ) {
                final Object value = values.remove("Partner");
                if( (value == null) || (!value.equals(getPartner())) ) {
                    setPartner(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeTime") ) {
                final Object value = values.remove("LastChangeTime");
                if( (value == null) || (!value.equals(getLastChangeTime())) ) {
                    setLastChangeTime(((LocalTime) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MaintObjectInternalID") ) {
                final Object value = values.remove("MaintObjectInternalID");
                if( (value == null) || (!value.equals(getMaintObjectInternalID())) ) {
                    setMaintObjectInternalID(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_FunctionalLocation") ) {
                final Object value = (values).remove("to_FunctionalLocation");
                if( value instanceof Map ) {
                    if( toFunctionalLocation == null ) {
                        toFunctionalLocation = new FunctionalLocation();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toFunctionalLocation.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> FunctionalLocationPartnerField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FunctionalLocationPartnerField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FunctionalLocationPartnerField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FunctionalLocationPartnerField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.FunctionalLocationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toFunctionalLocation != null ) {
            (values).put("to_FunctionalLocation", toFunctionalLocation);
        }
        return values;
    }

    /**
     * Fetches the <b>FunctionalLocation</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_FunctionalLocation</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>FunctionalLocation</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FunctionalLocation fetchFunctionalLocation()
    {
        return fetchFieldAsSingle("to_FunctionalLocation", FunctionalLocation.class);
    }

    /**
     * Retrieval of associated <b>FunctionalLocation</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_FunctionalLocation</b>.
     * <p>
     * If the navigation property <b>to_FunctionalLocation</b> of a queried <b>FunctionalLocationPartner</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FunctionalLocation</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FunctionalLocation getFunctionalLocationOrFetch()
    {
        if( toFunctionalLocation == null ) {
            toFunctionalLocation = fetchFunctionalLocation();
        }
        return toFunctionalLocation;
    }

    /**
     * Retrieval of associated <b>FunctionalLocation</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_FunctionalLocation</b>.
     * <p>
     * If the navigation property for an entity <b>FunctionalLocationPartner</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_FunctionalLocation</b> is already loaded, the result
     *         will contain the <b>FunctionalLocation</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<FunctionalLocation> getFunctionalLocationIfPresent()
    {
        return Option.of(toFunctionalLocation);
    }

    /**
     * Overwrites the associated <b>FunctionalLocation</b> entity for the loaded navigation property
     * <b>to_FunctionalLocation</b>.
     *
     * @param value
     *            New <b>FunctionalLocation</b> entity.
     */
    public void setFunctionalLocation( final FunctionalLocation value )
    {
        toFunctionalLocation = value;
    }

    /**
     * Helper class to allow for fluent creation of FunctionalLocationPartner instances.
     *
     */
    public final static class FunctionalLocationPartnerBuilder
    {

        private FunctionalLocation toFunctionalLocation;
        private String functionalLocation = null;

        private FunctionalLocationPartner.FunctionalLocationPartnerBuilder toFunctionalLocation(
            final FunctionalLocation value )
        {
            toFunctionalLocation = value;
            return this;
        }

        /**
         * Navigation property <b>to_FunctionalLocation</b> for <b>FunctionalLocationPartner</b> to single
         * <b>FunctionalLocation</b>.
         *
         * @param value
         *            The FunctionalLocation to build this FunctionalLocationPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FunctionalLocationPartner.FunctionalLocationPartnerBuilder functionalLocation(
            final FunctionalLocation value )
        {
            return toFunctionalLocation(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 30
         * <p>
         * Original property name from the Odata EDM: <b>FunctionalLocation</b>
         * </p>
         *
         * @param value
         *            The functionalLocation to build this FunctionalLocationPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FunctionalLocationPartner.FunctionalLocationPartnerBuilder functionalLocation( final String value )
        {
            functionalLocation = value;
            return this;
        }

    }

}
