/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.field.FunctionalLocationWarrantyField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.link.FunctionalLocationWarrantyOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.selectable.FunctionalLocationWarrantySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Functional Location Warranty
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FunctionalLocationWarrantyType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FunctionalLocationWarranty extends VdmEntity<FunctionalLocationWarranty>
{

    /**
     * Selector for all available fields of FunctionalLocationWarranty.
     *
     */
    public final static FunctionalLocationWarrantySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @return Functional location
     */
    @Key
    @SerializedName( "FunctionalLocation" )
    @JsonProperty( "FunctionalLocation" )
    @Nullable
    @ODataField( odataName = "FunctionalLocation" )
    private String functionalLocation;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalLocation</b> field to query operations.
     *
     */
    public final static FunctionalLocationWarrantyField<String> FUNCTIONAL_LOCATION =
        new FunctionalLocationWarrantyField<String>("FunctionalLocation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WarrantyType</b>
     * </p>
     *
     * @return Warranty type
     */
    @Key
    @SerializedName( "WarrantyType" )
    @JsonProperty( "WarrantyType" )
    @Nullable
    @ODataField( odataName = "WarrantyType" )
    private String warrantyType;
    /**
     * Use with available fluent helpers to apply the <b>WarrantyType</b> field to query operations.
     *
     */
    public final static FunctionalLocationWarrantyField<String> WARRANTY_TYPE =
        new FunctionalLocationWarrantyField<String>("WarrantyType");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocationLabelName</b>
     * </p>
     *
     * @return Functional Location Label
     */
    @SerializedName( "FunctionalLocationLabelName" )
    @JsonProperty( "FunctionalLocationLabelName" )
    @Nullable
    @ODataField( odataName = "FunctionalLocationLabelName" )
    private String functionalLocationLabelName;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalLocationLabelName</b> field to query operations.
     *
     */
    public final static FunctionalLocationWarrantyField<String> FUNCTIONAL_LOCATION_LABEL_NAME =
        new FunctionalLocationWarrantyField<String>("FunctionalLocationLabelName");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MasterWarranty</b>
     * </p>
     *
     * @return Master warranty number
     */
    @SerializedName( "MasterWarranty" )
    @JsonProperty( "MasterWarranty" )
    @Nullable
    @ODataField( odataName = "MasterWarranty" )
    private String masterWarranty;
    /**
     * Use with available fluent helpers to apply the <b>MasterWarranty</b> field to query operations.
     *
     */
    public final static FunctionalLocationWarrantyField<String> MASTER_WARRANTY =
        new FunctionalLocationWarrantyField<String>("MasterWarranty");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>WarrantyStartDate</b>
     * </p>
     *
     * @return Warranty Date
     */
    @SerializedName( "WarrantyStartDate" )
    @JsonProperty( "WarrantyStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "WarrantyStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime warrantyStartDate;
    /**
     * Use with available fluent helpers to apply the <b>WarrantyStartDate</b> field to query operations.
     *
     */
    public final static FunctionalLocationWarrantyField<LocalDateTime> WARRANTY_START_DATE =
        new FunctionalLocationWarrantyField<LocalDateTime>("WarrantyStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>WarrantyEndDate</b>
     * </p>
     *
     * @return Date on which the warranty ends
     */
    @SerializedName( "WarrantyEndDate" )
    @JsonProperty( "WarrantyEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "WarrantyEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime warrantyEndDate;
    /**
     * Use with available fluent helpers to apply the <b>WarrantyEndDate</b> field to query operations.
     *
     */
    public final static FunctionalLocationWarrantyField<LocalDateTime> WARRANTY_END_DATE =
        new FunctionalLocationWarrantyField<LocalDateTime>("WarrantyEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WrntyIsInhtdFromSuperiorObject</b>
     * </p>
     *
     * @return Indicator, Whether Technical Object Should Inherit Warranty
     */
    @SerializedName( "WrntyIsInhtdFromSuperiorObject" )
    @JsonProperty( "WrntyIsInhtdFromSuperiorObject" )
    @Nullable
    @ODataField( odataName = "WrntyIsInhtdFromSuperiorObject" )
    private String wrntyIsInhtdFromSuperiorObject;
    /**
     * Use with available fluent helpers to apply the <b>WrntyIsInhtdFromSuperiorObject</b> field to query operations.
     *
     */
    public final static FunctionalLocationWarrantyField<String> WRNTY_IS_INHTD_FROM_SUPERIOR_OBJECT =
        new FunctionalLocationWarrantyField<String>("WrntyIsInhtdFromSuperiorObject");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WrntyIsPassedOnToChildObject</b>
     * </p>
     *
     * @return Indicator: Pass on Warranty
     */
    @SerializedName( "WrntyIsPassedOnToChildObject" )
    @JsonProperty( "WrntyIsPassedOnToChildObject" )
    @Nullable
    @ODataField( odataName = "WrntyIsPassedOnToChildObject" )
    private String wrntyIsPassedOnToChildObject;
    /**
     * Use with available fluent helpers to apply the <b>WrntyIsPassedOnToChildObject</b> field to query operations.
     *
     */
    public final static FunctionalLocationWarrantyField<String> WRNTY_IS_PASSED_ON_TO_CHILD_OBJECT =
        new FunctionalLocationWarrantyField<String>("WrntyIsPassedOnToChildObject");
    /**
     * Navigation property <b>to_FunctionalLocation</b> for <b>FunctionalLocationWarranty</b> to single
     * <b>FunctionalLocation</b>.
     *
     */
    @SerializedName( "to_FunctionalLocation" )
    @JsonProperty( "to_FunctionalLocation" )
    @ODataField( odataName = "to_FunctionalLocation" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private FunctionalLocation toFunctionalLocation;
    /**
     * Use with available fluent helpers to apply the <b>to_FunctionalLocation</b> navigation property to query
     * operations.
     *
     */
    public final static FunctionalLocationWarrantyOneToOneLink<FunctionalLocation> TO_FUNCTIONAL_LOCATION =
        new FunctionalLocationWarrantyOneToOneLink<FunctionalLocation>("to_FunctionalLocation");

    @Nonnull
    @Override
    public Class<FunctionalLocationWarranty> getType()
    {
        return FunctionalLocationWarranty.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @param functionalLocation
     *            Functional location
     */
    public void setFunctionalLocation( @Nullable final String functionalLocation )
    {
        rememberChangedField("FunctionalLocation", this.functionalLocation);
        this.functionalLocation = functionalLocation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WarrantyType</b>
     * </p>
     *
     * @param warrantyType
     *            Warranty type
     */
    public void setWarrantyType( @Nullable final String warrantyType )
    {
        rememberChangedField("WarrantyType", this.warrantyType);
        this.warrantyType = warrantyType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocationLabelName</b>
     * </p>
     *
     * @param functionalLocationLabelName
     *            Functional Location Label
     */
    public void setFunctionalLocationLabelName( @Nullable final String functionalLocationLabelName )
    {
        rememberChangedField("FunctionalLocationLabelName", this.functionalLocationLabelName);
        this.functionalLocationLabelName = functionalLocationLabelName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MasterWarranty</b>
     * </p>
     *
     * @param masterWarranty
     *            Master warranty number
     */
    public void setMasterWarranty( @Nullable final String masterWarranty )
    {
        rememberChangedField("MasterWarranty", this.masterWarranty);
        this.masterWarranty = masterWarranty;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>WarrantyStartDate</b>
     * </p>
     *
     * @param warrantyStartDate
     *            Warranty Date
     */
    public void setWarrantyStartDate( @Nullable final LocalDateTime warrantyStartDate )
    {
        rememberChangedField("WarrantyStartDate", this.warrantyStartDate);
        this.warrantyStartDate = warrantyStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>WarrantyEndDate</b>
     * </p>
     *
     * @param warrantyEndDate
     *            Date on which the warranty ends
     */
    public void setWarrantyEndDate( @Nullable final LocalDateTime warrantyEndDate )
    {
        rememberChangedField("WarrantyEndDate", this.warrantyEndDate);
        this.warrantyEndDate = warrantyEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WrntyIsInhtdFromSuperiorObject</b>
     * </p>
     *
     * @param wrntyIsInhtdFromSuperiorObject
     *            Indicator, Whether Technical Object Should Inherit Warranty
     */
    public void setWrntyIsInhtdFromSuperiorObject( @Nullable final String wrntyIsInhtdFromSuperiorObject )
    {
        rememberChangedField("WrntyIsInhtdFromSuperiorObject", this.wrntyIsInhtdFromSuperiorObject);
        this.wrntyIsInhtdFromSuperiorObject = wrntyIsInhtdFromSuperiorObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WrntyIsPassedOnToChildObject</b>
     * </p>
     *
     * @param wrntyIsPassedOnToChildObject
     *            Indicator: Pass on Warranty
     */
    public void setWrntyIsPassedOnToChildObject( @Nullable final String wrntyIsPassedOnToChildObject )
    {
        rememberChangedField("WrntyIsPassedOnToChildObject", this.wrntyIsPassedOnToChildObject);
        this.wrntyIsPassedOnToChildObject = wrntyIsPassedOnToChildObject;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FunctionalLocationWarranty";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("FunctionalLocation", getFunctionalLocation());
        result.put("WarrantyType", getWarrantyType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("FunctionalLocation", getFunctionalLocation());
        values.put("WarrantyType", getWarrantyType());
        values.put("FunctionalLocationLabelName", getFunctionalLocationLabelName());
        values.put("MasterWarranty", getMasterWarranty());
        values.put("WarrantyStartDate", getWarrantyStartDate());
        values.put("WarrantyEndDate", getWarrantyEndDate());
        values.put("WrntyIsInhtdFromSuperiorObject", getWrntyIsInhtdFromSuperiorObject());
        values.put("WrntyIsPassedOnToChildObject", getWrntyIsPassedOnToChildObject());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("FunctionalLocation") ) {
                final Object value = values.remove("FunctionalLocation");
                if( (value == null) || (!value.equals(getFunctionalLocation())) ) {
                    setFunctionalLocation(((String) value));
                }
            }
            if( values.containsKey("WarrantyType") ) {
                final Object value = values.remove("WarrantyType");
                if( (value == null) || (!value.equals(getWarrantyType())) ) {
                    setWarrantyType(((String) value));
                }
            }
            if( values.containsKey("FunctionalLocationLabelName") ) {
                final Object value = values.remove("FunctionalLocationLabelName");
                if( (value == null) || (!value.equals(getFunctionalLocationLabelName())) ) {
                    setFunctionalLocationLabelName(((String) value));
                }
            }
            if( values.containsKey("MasterWarranty") ) {
                final Object value = values.remove("MasterWarranty");
                if( (value == null) || (!value.equals(getMasterWarranty())) ) {
                    setMasterWarranty(((String) value));
                }
            }
            if( values.containsKey("WarrantyStartDate") ) {
                final Object value = values.remove("WarrantyStartDate");
                if( (value == null) || (!value.equals(getWarrantyStartDate())) ) {
                    setWarrantyStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("WarrantyEndDate") ) {
                final Object value = values.remove("WarrantyEndDate");
                if( (value == null) || (!value.equals(getWarrantyEndDate())) ) {
                    setWarrantyEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("WrntyIsInhtdFromSuperiorObject") ) {
                final Object value = values.remove("WrntyIsInhtdFromSuperiorObject");
                if( (value == null) || (!value.equals(getWrntyIsInhtdFromSuperiorObject())) ) {
                    setWrntyIsInhtdFromSuperiorObject(((String) value));
                }
            }
            if( values.containsKey("WrntyIsPassedOnToChildObject") ) {
                final Object value = values.remove("WrntyIsPassedOnToChildObject");
                if( (value == null) || (!value.equals(getWrntyIsPassedOnToChildObject())) ) {
                    setWrntyIsPassedOnToChildObject(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_FunctionalLocation") ) {
                final Object value = (values).remove("to_FunctionalLocation");
                if( value instanceof Map ) {
                    if( toFunctionalLocation == null ) {
                        toFunctionalLocation = new FunctionalLocation();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toFunctionalLocation.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> FunctionalLocationWarrantyField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new FunctionalLocationWarrantyField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FunctionalLocationWarrantyField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FunctionalLocationWarrantyField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.FunctionalLocationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toFunctionalLocation != null ) {
            (values).put("to_FunctionalLocation", toFunctionalLocation);
        }
        return values;
    }

    /**
     * Fetches the <b>FunctionalLocation</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_FunctionalLocation</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>FunctionalLocation</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FunctionalLocation fetchFunctionalLocation()
    {
        return fetchFieldAsSingle("to_FunctionalLocation", FunctionalLocation.class);
    }

    /**
     * Retrieval of associated <b>FunctionalLocation</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_FunctionalLocation</b>.
     * <p>
     * If the navigation property <b>to_FunctionalLocation</b> of a queried <b>FunctionalLocationWarranty</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FunctionalLocation</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FunctionalLocation getFunctionalLocationOrFetch()
    {
        if( toFunctionalLocation == null ) {
            toFunctionalLocation = fetchFunctionalLocation();
        }
        return toFunctionalLocation;
    }

    /**
     * Retrieval of associated <b>FunctionalLocation</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_FunctionalLocation</b>.
     * <p>
     * If the navigation property for an entity <b>FunctionalLocationWarranty</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_FunctionalLocation</b> is already loaded, the result
     *         will contain the <b>FunctionalLocation</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<FunctionalLocation> getFunctionalLocationIfPresent()
    {
        return Option.of(toFunctionalLocation);
    }

    /**
     * Overwrites the associated <b>FunctionalLocation</b> entity for the loaded navigation property
     * <b>to_FunctionalLocation</b>.
     *
     * @param value
     *            New <b>FunctionalLocation</b> entity.
     */
    public void setFunctionalLocation( final FunctionalLocation value )
    {
        toFunctionalLocation = value;
    }

    /**
     * Helper class to allow for fluent creation of FunctionalLocationWarranty instances.
     *
     */
    public final static class FunctionalLocationWarrantyBuilder
    {

        private FunctionalLocation toFunctionalLocation;
        private String functionalLocation = null;

        private FunctionalLocationWarranty.FunctionalLocationWarrantyBuilder toFunctionalLocation(
            final FunctionalLocation value )
        {
            toFunctionalLocation = value;
            return this;
        }

        /**
         * Navigation property <b>to_FunctionalLocation</b> for <b>FunctionalLocationWarranty</b> to single
         * <b>FunctionalLocation</b>.
         *
         * @param value
         *            The FunctionalLocation to build this FunctionalLocationWarranty with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FunctionalLocationWarranty.FunctionalLocationWarrantyBuilder functionalLocation(
            final FunctionalLocation value )
        {
            return toFunctionalLocation(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 30
         * <p>
         * Original property name from the Odata EDM: <b>FunctionalLocation</b>
         * </p>
         *
         * @param value
         *            The functionalLocation to build this FunctionalLocationWarranty with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FunctionalLocationWarranty.FunctionalLocationWarrantyBuilder functionalLocation( final String value )
        {
            functionalLocation = value;
            return this;
        }

    }

}
