/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link FunctionalLocationServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.FunctionalLocationService FunctionalLocationService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultFunctionalLocationServiceBatch
    extends
    BatchFluentHelperBasic<FunctionalLocationServiceBatch, FunctionalLocationServiceBatchChangeSet>
    implements
    FunctionalLocationServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.FunctionalLocationService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultFunctionalLocationServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultFunctionalLocationServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.FunctionalLocationService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.FunctionalLocationService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultFunctionalLocationServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultFunctionalLocationServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.FunctionalLocationService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultFunctionalLocationServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public FunctionalLocationServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultFunctionalLocationServiceBatchChangeSet(this, service);
    }

}
