/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Characteristic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarranty;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Value;

/**
 * Implementation of the {@link FunctionalLocationServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.FunctionalLocationService FunctionalLocationService}.
 *
 */
public class DefaultFunctionalLocationServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<FunctionalLocationServiceBatch, FunctionalLocationServiceBatchChangeSet>
    implements
    FunctionalLocationServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.FunctionalLocationService service;

    @SuppressWarnings( "deprecation" )
    DefaultFunctionalLocationServiceBatchChangeSet(
        @Nonnull final DefaultFunctionalLocationServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.FunctionalLocationService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultFunctionalLocationServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public FunctionalLocationServiceBatchChangeSet createValue( @Nonnull final Value value )
    {
        return addRequestCreate(service::createValue, value);
    }

    @Nonnull
    @Override
    public FunctionalLocationServiceBatchChangeSet updateValue( @Nonnull final Value value )
    {
        return addRequestUpdate(service::updateValue, value);
    }

    @Nonnull
    @Override
    public FunctionalLocationServiceBatchChangeSet createFunctionalLocationClass(
        @Nonnull final FunctionalLocationClass functionalLocationClass )
    {
        return addRequestCreate(service::createFunctionalLocationClass, functionalLocationClass);
    }

    @Nonnull
    @Override
    public FunctionalLocationServiceBatchChangeSet updateFunctionalLocationClass(
        @Nonnull final FunctionalLocationClass functionalLocationClass )
    {
        return addRequestUpdate(service::updateFunctionalLocationClass, functionalLocationClass);
    }

    @Nonnull
    @Override
    public FunctionalLocationServiceBatchChangeSet deleteFunctionalLocationClass(
        @Nonnull final FunctionalLocationClass functionalLocationClass )
    {
        return addRequestDelete(service::deleteFunctionalLocationClass, functionalLocationClass);
    }

    @Nonnull
    @Override
    public FunctionalLocationServiceBatchChangeSet createCharacteristic( @Nonnull final Characteristic characteristic )
    {
        return addRequestCreate(service::createCharacteristic, characteristic);
    }

    @Nonnull
    @Override
    public FunctionalLocationServiceBatchChangeSet createFunctionalLocationWarranty(
        @Nonnull final FunctionalLocationWarranty functionalLocationWarranty )
    {
        return addRequestCreate(service::createFunctionalLocationWarranty, functionalLocationWarranty);
    }

    @Nonnull
    @Override
    public FunctionalLocationServiceBatchChangeSet updateFunctionalLocationWarranty(
        @Nonnull final FunctionalLocationWarranty functionalLocationWarranty )
    {
        return addRequestUpdate(service::updateFunctionalLocationWarranty, functionalLocationWarranty);
    }

    @Nonnull
    @Override
    public FunctionalLocationServiceBatchChangeSet createFunctionalLocation(
        @Nonnull final FunctionalLocation functionalLocation )
    {
        return addRequestCreate(service::createFunctionalLocation, functionalLocation);
    }

    @Nonnull
    @Override
    public FunctionalLocationServiceBatchChangeSet updateFunctionalLocation(
        @Nonnull final FunctionalLocation functionalLocation )
    {
        return addRequestUpdate(service::updateFunctionalLocation, functionalLocation);
    }

    @Nonnull
    @Override
    public FunctionalLocationServiceBatchChangeSet createFunctionalLocationLongText(
        @Nonnull final FunctionalLocationLongText functionalLocationLongText )
    {
        return addRequestCreate(service::createFunctionalLocationLongText, functionalLocationLongText);
    }

    @Nonnull
    @Override
    public FunctionalLocationServiceBatchChangeSet updateFunctionalLocationLongText(
        @Nonnull final FunctionalLocationLongText functionalLocationLongText )
    {
        return addRequestUpdate(service::updateFunctionalLocationLongText, functionalLocationLongText);
    }

    @Nonnull
    @Override
    public FunctionalLocationServiceBatchChangeSet createFunctionalLocationPartner(
        @Nonnull final FunctionalLocationPartner functionalLocationPartner )
    {
        return addRequestCreate(service::createFunctionalLocationPartner, functionalLocationPartner);
    }

    @Nonnull
    @Override
    public FunctionalLocationServiceBatchChangeSet updateFunctionalLocationPartner(
        @Nonnull final FunctionalLocationPartner functionalLocationPartner )
    {
        return addRequestUpdate(service::updateFunctionalLocationPartner, functionalLocationPartner);
    }

}
