/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Characteristic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarranty;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Value;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.FunctionalLocationService
 * FunctionalLocationService}.
 *
 */
public interface FunctionalLocationServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<FunctionalLocationServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<FunctionalLocationServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Value Value} entity
     * and save it to the S/4HANA system.
     *
     * @param value
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Value Value} entity
     *            object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    FunctionalLocationServiceBatchChangeSet createValue( @Nonnull final Value value );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Value Value}
     * entity and save it to the S/4HANA system.
     *
     * @param value
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Value Value} entity
     *            object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    FunctionalLocationServiceBatchChangeSet updateValue( @Nonnull final Value value );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass
     * FunctionalLocationClass} entity and save it to the S/4HANA system.
     *
     * @param functionalLocationClass
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass
     *            FunctionalLocationClass} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    FunctionalLocationServiceBatchChangeSet
        createFunctionalLocationClass( @Nonnull final FunctionalLocationClass functionalLocationClass );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass
     * FunctionalLocationClass} entity and save it to the S/4HANA system.
     *
     * @param functionalLocationClass
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass
     *            FunctionalLocationClass} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    FunctionalLocationServiceBatchChangeSet
        updateFunctionalLocationClass( @Nonnull final FunctionalLocationClass functionalLocationClass );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass
     * FunctionalLocationClass} entity in the S/4HANA system.
     *
     * @param functionalLocationClass
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass
     *            FunctionalLocationClass} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    FunctionalLocationServiceBatchChangeSet
        deleteFunctionalLocationClass( @Nonnull final FunctionalLocationClass functionalLocationClass );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Characteristic
     * Characteristic} entity and save it to the S/4HANA system.
     *
     * @param characteristic
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.Characteristic
     *            Characteristic} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    FunctionalLocationServiceBatchChangeSet createCharacteristic( @Nonnull final Characteristic characteristic );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarranty
     * FunctionalLocationWarranty} entity and save it to the S/4HANA system.
     *
     * @param functionalLocationWarranty
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarranty
     *            FunctionalLocationWarranty} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    FunctionalLocationServiceBatchChangeSet
        createFunctionalLocationWarranty( @Nonnull final FunctionalLocationWarranty functionalLocationWarranty );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarranty
     * FunctionalLocationWarranty} entity and save it to the S/4HANA system.
     *
     * @param functionalLocationWarranty
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarranty
     *            FunctionalLocationWarranty} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    FunctionalLocationServiceBatchChangeSet
        updateFunctionalLocationWarranty( @Nonnull final FunctionalLocationWarranty functionalLocationWarranty );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation
     * FunctionalLocation} entity and save it to the S/4HANA system.
     *
     * @param functionalLocation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation
     *            FunctionalLocation} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    FunctionalLocationServiceBatchChangeSet
        createFunctionalLocation( @Nonnull final FunctionalLocation functionalLocation );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation
     * FunctionalLocation} entity and save it to the S/4HANA system.
     *
     * @param functionalLocation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation
     *            FunctionalLocation} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    FunctionalLocationServiceBatchChangeSet
        updateFunctionalLocation( @Nonnull final FunctionalLocation functionalLocation );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongText
     * FunctionalLocationLongText} entity and save it to the S/4HANA system.
     *
     * @param functionalLocationLongText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongText
     *            FunctionalLocationLongText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    FunctionalLocationServiceBatchChangeSet
        createFunctionalLocationLongText( @Nonnull final FunctionalLocationLongText functionalLocationLongText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongText
     * FunctionalLocationLongText} entity and save it to the S/4HANA system.
     *
     * @param functionalLocationLongText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongText
     *            FunctionalLocationLongText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    FunctionalLocationServiceBatchChangeSet
        updateFunctionalLocationLongText( @Nonnull final FunctionalLocationLongText functionalLocationLongText );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationPartner
     * FunctionalLocationPartner} entity and save it to the S/4HANA system.
     *
     * @param functionalLocationPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationPartner
     *            FunctionalLocationPartner} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    FunctionalLocationServiceBatchChangeSet
        createFunctionalLocationPartner( @Nonnull final FunctionalLocationPartner functionalLocationPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationPartner
     * FunctionalLocationPartner} entity and save it to the S/4HANA system.
     *
     * @param functionalLocationPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationPartner
     *            FunctionalLocationPartner} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    FunctionalLocationServiceBatchChangeSet
        updateFunctionalLocationPartner( @Nonnull final FunctionalLocationPartner functionalLocationPartner );

}
