/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass
 * FunctionalLocationClass}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.field.FunctionalLocationClassField
 * FunctionalLocationClassField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.link.FunctionalLocationClassLink
 * FunctionalLocationClassLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass#FUNCTIONAL_LOCATION
 * FUNCTIONAL_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass#CLASS_INTERNAL_ID
 * CLASS_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass#CLASS_TYPE
 * CLASS_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass#FUNCTIONAL_LOCATION_LABEL_NAME
 * FUNCTIONAL_LOCATION_LABEL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass#KEY_DATE
 * KEY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass#CLASS_PROPERTY
 * CLASS_PROPERTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass#CLFN_STATUS
 * CLFN_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass#CLASS_POSITION_NUMBER
 * CLASS_POSITION_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass#CLASS_IS_STANDARD_CLASS
 * CLASS_IS_STANDARD_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass#CLFN_OBJECT_INTERNAL_ID
 * CLFN_OBJECT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass#TO_CHARACTERISTIC
 * TO_CHARACTERISTIC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationClass#TO_FUNCTIONAL_LOCATION
 * TO_FUNCTIONAL_LOCATION}</li>
 * </ul>
 *
 */
public interface FunctionalLocationClassSelectable extends EntitySelectable<FunctionalLocationClass>
{

}
