/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongText
 * FunctionalLocationLongText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.field.FunctionalLocationLongTextField
 * FunctionalLocationLongTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.link.FunctionalLocationLongTextLink
 * FunctionalLocationLongTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongText#FUNCTIONAL_LOCATION
 * FUNCTIONAL_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongText#FUNCTIONAL_LOCATION_LABEL_NAME
 * FUNCTIONAL_LOCATION_LABEL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongText#TEXT_OBJECT_KEY
 * TEXT_OBJECT_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongText#FUNCNL_LOC_LONG_TEXT
 * FUNCNL_LOC_LONG_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationLongText#TO_FUNCTIONAL_LOCATION
 * TO_FUNCTIONAL_LOCATION}</li>
 * </ul>
 *
 */
public interface FunctionalLocationLongTextSelectable extends EntitySelectable<FunctionalLocationLongText>
{

}
