/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation FunctionalLocation}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.field.FunctionalLocationField
 * FunctionalLocationField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.link.FunctionalLocationLink
 * FunctionalLocationLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#FUNCTIONAL_LOCATION
 * FUNCTIONAL_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#FUNCTIONAL_LOCATION_OID
 * FUNCTIONAL_LOCATION_OID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#FUNCTIONAL_LOCATION_LABEL_NAME
 * FUNCTIONAL_LOCATION_LABEL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#FUNCTIONAL_LOCATION_NAME
 * FUNCTIONAL_LOCATION_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#FUNC_LOCATION_STRUCTURE
 * FUNC_LOCATION_STRUCTURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#FUNCTIONAL_LOCATION_CATEGORY
 * FUNCTIONAL_LOCATION_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#SUPERIOR_FUNCTIONAL_LOCATION
 * SUPERIOR_FUNCTIONAL_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#SUPERIOR_FUNCNL_LOC_LABEL_NAME
 * SUPERIOR_FUNCNL_LOC_LABEL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#FUNCNL_LOC_POS_IN_SUPERIOR_TECH_OBJ
 * FUNCNL_LOC_POS_IN_SUPERIOR_TECH_OBJ}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#TECHNICAL_OBJECT_TYPE
 * TECHNICAL_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#AUTHORIZATION_GROUP
 * AUTHORIZATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#GROSS_WEIGHT
 * GROSS_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#GROSS_WEIGHT_UNIT
 * GROSS_WEIGHT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#OPERATION_START_DATE
 * OPERATION_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#INVENTORY_NUMBER
 * INVENTORY_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#ACQUISITION_VALUE
 * ACQUISITION_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#CURRENCY
 * CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#ACQUISITION_DATE
 * ACQUISITION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#ASSET_MANUFACTURER_NAME
 * ASSET_MANUFACTURER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#MANUFACTURER_PART_NMBR
 * MANUFACTURER_PART_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#MANUFACTURER_COUNTRY
 * MANUFACTURER_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#MANUFACTURER_PART_TYPE_NAME
 * MANUFACTURER_PART_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#CONSTRUCTION_MONTH
 * CONSTRUCTION_MONTH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#CONSTRUCTION_YEAR
 * CONSTRUCTION_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#MANUFACTURER_SERIAL_NUMBER
 * MANUFACTURER_SERIAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#MAINTENANCE_PLANT
 * MAINTENANCE_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#ASSET_LOCATION
 * ASSET_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#ASSET_ROOM
 * ASSET_ROOM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#PLANT_SECTION
 * PLANT_SECTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#WORK_CENTER
 * WORK_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#WORK_CENTER_INTERNAL_ID
 * WORK_CENTER_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#WORK_CENTER_PLANT
 * WORK_CENTER_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#ABC_INDICATOR
 * ABC_INDICATOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#MAINT_OBJECT_FREE_DEFINED_ATTRIB
 * MAINT_OBJECT_FREE_DEFINED_ATTRIB}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#FORM_OF_ADDRESS
 * FORM_OF_ADDRESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#BUSINESS_PARTNER_NAME1
 * BUSINESS_PARTNER_NAME1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#BUSINESS_PARTNER_NAME2
 * BUSINESS_PARTNER_NAME2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#CITY_NAME
 * CITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#HOUSE_NUMBER
 * HOUSE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#HOUSE_NUMBER_SUPPLEMENT_TEXT
 * HOUSE_NUMBER_SUPPLEMENT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#BUILDING
 * BUILDING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#FLOOR
 * FLOOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#ROOM_NUMBER
 * ROOM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#POSTAL_CODE
 * POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#STREET_NAME
 * STREET_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#REGION
 * REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#COUNTRY
 * COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#PHONE_NUMBER
 * PHONE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#FAX_NUMBER
 * FAX_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#MASTER_FIXED_ASSET
 * MASTER_FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#FIXED_ASSET
 * FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#WBS_ELEMENT_EXTERNAL_ID
 * WBS_ELEMENT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#SETTLEMENT_ORDER
 * SETTLEMENT_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#CONSTRUCTION_MATERIAL
 * CONSTRUCTION_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#MAINTENANCE_PLANNER_GROUP
 * MAINTENANCE_PLANNER_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#MAINTENANCE_PLANNING_PLANT
 * MAINTENANCE_PLANNING_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#MAIN_WORK_CENTER_PLANT
 * MAIN_WORK_CENTER_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#MAIN_WORK_CENTER
 * MAIN_WORK_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#MAIN_WORK_CENTER_INTERNAL_ID
 * MAIN_WORK_CENTER_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#CATALOG_PROFILE
 * CATALOG_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#EQUIPMENT_INSTALLATION_IS_ALLOWED
 * EQUIPMENT_INSTALLATION_IS_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#ONE_PIECE_OF_EQUIPMENT_IS_ALLOWED
 * ONE_PIECE_OF_EQUIPMENT_IS_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#SALES_ORGANIZATION
 * SALES_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#DISTRIBUTION_CHANNEL
 * DISTRIBUTION_CHANNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#SALES_OFFICE
 * SALES_OFFICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#ORGANIZATION_DIVISION
 * ORGANIZATION_DIVISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#SALES_GROUP
 * SALES_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#FUNCTIONAL_LOCATION_HAS_EQUIPMENT
 * FUNCTIONAL_LOCATION_HAS_EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#FUNCNL_LOC_HAS_SUB_ORDINATE_FUNC_LOC
 * FUNCNL_LOC_HAS_SUB_ORDINATE_FUNC_LOC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#FUNCNL_LOC_IS_MARKED_FOR_DELETION
 * FUNCNL_LOC_IS_MARKED_FOR_DELETION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#FUNCNL_LOC_IS_DELETED
 * FUNCNL_LOC_IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#FUNCTIONAL_LOCATION_IS_ACTIVE
 * FUNCTIONAL_LOCATION_IS_ACTIVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#FUNCNL_LOC_IS_DEACTIVATED
 * FUNCNL_LOC_IS_DEACTIVATED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#TO_CLASSIFICATION
 * TO_CLASSIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#TO_LONG_TEXT
 * TO_LONG_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#TO_PARTNER
 * TO_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocation#TO_WARRANTY
 * TO_WARRANTY}</li>
 * </ul>
 *
 */
public interface FunctionalLocationSelectable extends EntitySelectable<FunctionalLocation>
{

}
