/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarranty;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarranty
 * FunctionalLocationWarranty}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.field.FunctionalLocationWarrantyField
 * FunctionalLocationWarrantyField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.link.FunctionalLocationWarrantyLink
 * FunctionalLocationWarrantyLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarranty#FUNCTIONAL_LOCATION
 * FUNCTIONAL_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarranty#WARRANTY_TYPE
 * WARRANTY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarranty#FUNCTIONAL_LOCATION_LABEL_NAME
 * FUNCTIONAL_LOCATION_LABEL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarranty#MASTER_WARRANTY
 * MASTER_WARRANTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarranty#WARRANTY_START_DATE
 * WARRANTY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarranty#WARRANTY_END_DATE
 * WARRANTY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarranty#WRNTY_IS_INHTD_FROM_SUPERIOR_OBJECT
 * WRNTY_IS_INHTD_FROM_SUPERIOR_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarranty#WRNTY_IS_PASSED_ON_TO_CHILD_OBJECT
 * WRNTY_IS_PASSED_ON_TO_CHILD_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.functionallocation.FunctionalLocationWarranty#TO_FUNCTIONAL_LOCATION
 * TO_FUNCTIONAL_LOCATION}</li>
 * </ul>
 *
 */
public interface FunctionalLocationWarrantySelectable extends EntitySelectable<FunctionalLocationWarranty>
{

}
