/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.field.FundCoreField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.link.FundCoreLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.selectable.FundCoreSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Fund
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FundCore_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FundCore extends VdmEntity<FundCore>
{

    /**
     * Selector for all available fields of FundCore.
     *
     */
    public final static FundCoreSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FinancialManagementArea</b>
     * </p>
     *
     * @return Financial Management Area
     */
    @Key
    @SerializedName( "FinancialManagementArea" )
    @JsonProperty( "FinancialManagementArea" )
    @Nullable
    @ODataField( odataName = "FinancialManagementArea" )
    private String financialManagementArea;
    /**
     * Use with available fluent helpers to apply the <b>FinancialManagementArea</b> field to query operations.
     *
     */
    public final static FundCoreField<String> FINANCIAL_MANAGEMENT_AREA =
        new FundCoreField<String>("FinancialManagementArea");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @return Fund
     */
    @Key
    @SerializedName( "Fund" )
    @JsonProperty( "Fund" )
    @Nullable
    @ODataField( odataName = "Fund" )
    private String fund;
    /**
     * Use with available fluent helpers to apply the <b>Fund</b> field to query operations.
     *
     */
    public final static FundCoreField<String> FUND = new FundCoreField<String>("Fund");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>FundType</b>
     * </p>
     *
     * @return Fund Type
     */
    @SerializedName( "FundType" )
    @JsonProperty( "FundType" )
    @Nullable
    @ODataField( odataName = "FundType" )
    private String fundType;
    /**
     * Use with available fluent helpers to apply the <b>FundType</b> field to query operations.
     *
     */
    public final static FundCoreField<String> FUND_TYPE = new FundCoreField<String>("FundType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FundPeriodicity</b>
     * </p>
     *
     * @return Fund Frequency
     */
    @SerializedName( "FundPeriodicity" )
    @JsonProperty( "FundPeriodicity" )
    @Nullable
    @ODataField( odataName = "FundPeriodicity" )
    private String fundPeriodicity;
    /**
     * Use with available fluent helpers to apply the <b>FundPeriodicity</b> field to query operations.
     *
     */
    public final static FundCoreField<String> FUND_PERIODICITY = new FundCoreField<String>("FundPeriodicity");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FundAuthznGrp</b>
     * </p>
     *
     * @return Fund Authorization Group
     */
    @SerializedName( "FundAuthznGrp" )
    @JsonProperty( "FundAuthznGrp" )
    @Nullable
    @ODataField( odataName = "FundAuthznGrp" )
    private String fundAuthznGrp;
    /**
     * Use with available fluent helpers to apply the <b>FundAuthznGrp</b> field to query operations.
     *
     */
    public final static FundCoreField<String> FUND_AUTHZN_GRP = new FundCoreField<String>("FundAuthznGrp");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Fund Valid From
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static FundCoreField<LocalDateTime> VALIDITY_START_DATE =
        new FundCoreField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Fund Valid To
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static FundCoreField<LocalDateTime> VALIDITY_END_DATE =
        new FundCoreField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>FundName</b>
     * </p>
     *
     * @return Fund Name
     */
    @SerializedName( "FundName" )
    @JsonProperty( "FundName" )
    @Nullable
    @ODataField( odataName = "FundName" )
    private String fundName;
    /**
     * Use with available fluent helpers to apply the <b>FundName</b> field to query operations.
     *
     */
    public final static FundCoreField<String> FUND_NAME = new FundCoreField<String>("FundName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FundDescription</b>
     * </p>
     *
     * @return Fund Description
     */
    @SerializedName( "FundDescription" )
    @JsonProperty( "FundDescription" )
    @Nullable
    @ODataField( odataName = "FundDescription" )
    private String fundDescription;
    /**
     * Use with available fluent helpers to apply the <b>FundDescription</b> field to query operations.
     *
     */
    public final static FundCoreField<String> FUND_DESCRIPTION = new FundCoreField<String>("FundDescription");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FundFinMgmtAreaForAuthzn</b>
     * </p>
     *
     * @return Financial Management Area
     */
    @SerializedName( "FundFinMgmtAreaForAuthzn" )
    @JsonProperty( "FundFinMgmtAreaForAuthzn" )
    @Nullable
    @ODataField( odataName = "FundFinMgmtAreaForAuthzn" )
    private String fundFinMgmtAreaForAuthzn;
    /**
     * Use with available fluent helpers to apply the <b>FundFinMgmtAreaForAuthzn</b> field to query operations.
     *
     */
    public final static FundCoreField<String> FUND_FIN_MGMT_AREA_FOR_AUTHZN =
        new FundCoreField<String>("FundFinMgmtAreaForAuthzn");
    /**
     * Navigation property <b>to_Text</b> for <b>FundCore</b> to multiple <b>FundText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<FundText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static FundCoreLink<FundText> TO_TEXT = new FundCoreLink<FundText>("to_Text");

    @Nonnull
    @Override
    public Class<FundCore> getType()
    {
        return FundCore.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FinancialManagementArea</b>
     * </p>
     *
     * @param financialManagementArea
     *            Financial Management Area
     */
    public void setFinancialManagementArea( @Nullable final String financialManagementArea )
    {
        rememberChangedField("FinancialManagementArea", this.financialManagementArea);
        this.financialManagementArea = financialManagementArea;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @param fund
     *            Fund
     */
    public void setFund( @Nullable final String fund )
    {
        rememberChangedField("Fund", this.fund);
        this.fund = fund;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>FundType</b>
     * </p>
     *
     * @param fundType
     *            Fund Type
     */
    public void setFundType( @Nullable final String fundType )
    {
        rememberChangedField("FundType", this.fundType);
        this.fundType = fundType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FundPeriodicity</b>
     * </p>
     *
     * @param fundPeriodicity
     *            Fund Frequency
     */
    public void setFundPeriodicity( @Nullable final String fundPeriodicity )
    {
        rememberChangedField("FundPeriodicity", this.fundPeriodicity);
        this.fundPeriodicity = fundPeriodicity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FundAuthznGrp</b>
     * </p>
     *
     * @param fundAuthznGrp
     *            Fund Authorization Group
     */
    public void setFundAuthznGrp( @Nullable final String fundAuthznGrp )
    {
        rememberChangedField("FundAuthznGrp", this.fundAuthznGrp);
        this.fundAuthznGrp = fundAuthznGrp;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Fund Valid From
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Fund Valid To
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>FundName</b>
     * </p>
     *
     * @param fundName
     *            Fund Name
     */
    public void setFundName( @Nullable final String fundName )
    {
        rememberChangedField("FundName", this.fundName);
        this.fundName = fundName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FundDescription</b>
     * </p>
     *
     * @param fundDescription
     *            Fund Description
     */
    public void setFundDescription( @Nullable final String fundDescription )
    {
        rememberChangedField("FundDescription", this.fundDescription);
        this.fundDescription = fundDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FundFinMgmtAreaForAuthzn</b>
     * </p>
     *
     * @param fundFinMgmtAreaForAuthzn
     *            Financial Management Area
     */
    public void setFundFinMgmtAreaForAuthzn( @Nullable final String fundFinMgmtAreaForAuthzn )
    {
        rememberChangedField("FundFinMgmtAreaForAuthzn", this.fundFinMgmtAreaForAuthzn);
        this.fundFinMgmtAreaForAuthzn = fundFinMgmtAreaForAuthzn;
    }

    @Override
    protected String getEntityCollection()
    {
        return "Fund";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("FinancialManagementArea", getFinancialManagementArea());
        result.put("Fund", getFund());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("FinancialManagementArea", getFinancialManagementArea());
        values.put("Fund", getFund());
        values.put("FundType", getFundType());
        values.put("FundPeriodicity", getFundPeriodicity());
        values.put("FundAuthznGrp", getFundAuthznGrp());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("FundName", getFundName());
        values.put("FundDescription", getFundDescription());
        values.put("FundFinMgmtAreaForAuthzn", getFundFinMgmtAreaForAuthzn());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("FinancialManagementArea") ) {
                final Object value = values.remove("FinancialManagementArea");
                if( (value == null) || (!value.equals(getFinancialManagementArea())) ) {
                    setFinancialManagementArea(((String) value));
                }
            }
            if( values.containsKey("Fund") ) {
                final Object value = values.remove("Fund");
                if( (value == null) || (!value.equals(getFund())) ) {
                    setFund(((String) value));
                }
            }
            if( values.containsKey("FundType") ) {
                final Object value = values.remove("FundType");
                if( (value == null) || (!value.equals(getFundType())) ) {
                    setFundType(((String) value));
                }
            }
            if( values.containsKey("FundPeriodicity") ) {
                final Object value = values.remove("FundPeriodicity");
                if( (value == null) || (!value.equals(getFundPeriodicity())) ) {
                    setFundPeriodicity(((String) value));
                }
            }
            if( values.containsKey("FundAuthznGrp") ) {
                final Object value = values.remove("FundAuthznGrp");
                if( (value == null) || (!value.equals(getFundAuthznGrp())) ) {
                    setFundAuthznGrp(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("FundName") ) {
                final Object value = values.remove("FundName");
                if( (value == null) || (!value.equals(getFundName())) ) {
                    setFundName(((String) value));
                }
            }
            if( values.containsKey("FundDescription") ) {
                final Object value = values.remove("FundDescription");
                if( (value == null) || (!value.equals(getFundDescription())) ) {
                    setFundDescription(((String) value));
                }
            }
            if( values.containsKey("FundFinMgmtAreaForAuthzn") ) {
                final Object value = values.remove("FundFinMgmtAreaForAuthzn");
                if( (value == null) || (!value.equals(getFundFinMgmtAreaForAuthzn())) ) {
                    setFundFinMgmtAreaForAuthzn(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        FundText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new FundText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> FundCoreField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FundCoreField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FundCoreField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FundCoreField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.FundService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>FundText</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>FundText</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FundText> fetchText()
    {
        return fetchFieldAsList("to_Text", FundText.class);
    }

    /**
     * Retrieval of associated <b>FundText</b> entities (one to many). This corresponds to the OData navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>FundCore</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FundText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<FundText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>FundText</b> entities (one to many). This corresponds to the OData navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>FundCore</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>FundText</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<List<FundText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>FundText</b> entities for the loaded navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>FundCore</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>FundText</b> entities.
     */
    public void setText( @Nonnull final List<FundText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>FundText</b> entities. This corresponds to the OData navigation
     * property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>FundCore</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>FundText</b> entities.
     */
    public void addText( FundText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of FundCore instances.
     *
     */
    public final static class FundCoreBuilder
    {

        private List<FundText> toText = Lists.newArrayList();

        private FundCore.FundCoreBuilder toText( final List<FundText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>FundCore</b> to multiple <b>FundText</b>.
         *
         * @param value
         *            The FundTexts to build this FundCore with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FundCore.FundCoreBuilder text( FundText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
