/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.field.FundTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.link.FundTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.fund.selectable.FundTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Fund Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FundText_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class FundText extends VdmEntity<FundText>
{

    /**
     * Selector for all available fields of FundText.
     *
     */
    public final static FundTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FinancialManagementArea</b>
     * </p>
     *
     * @return Financial Management Area
     */
    @Key
    @SerializedName( "FinancialManagementArea" )
    @JsonProperty( "FinancialManagementArea" )
    @Nullable
    @ODataField( odataName = "FinancialManagementArea" )
    private String financialManagementArea;
    /**
     * Use with available fluent helpers to apply the <b>FinancialManagementArea</b> field to query operations.
     *
     */
    public final static FundTextField<String> FINANCIAL_MANAGEMENT_AREA =
        new FundTextField<String>("FinancialManagementArea");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @return Fund
     */
    @Key
    @SerializedName( "Fund" )
    @JsonProperty( "Fund" )
    @Nullable
    @ODataField( odataName = "Fund" )
    private String fund;
    /**
     * Use with available fluent helpers to apply the <b>Fund</b> field to query operations.
     *
     */
    public final static FundTextField<String> FUND = new FundTextField<String>("Fund");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static FundTextField<String> LANGUAGE = new FundTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>FundName</b>
     * </p>
     *
     * @return Fund Name
     */
    @SerializedName( "FundName" )
    @JsonProperty( "FundName" )
    @Nullable
    @ODataField( odataName = "FundName" )
    private String fundName;
    /**
     * Use with available fluent helpers to apply the <b>FundName</b> field to query operations.
     *
     */
    public final static FundTextField<String> FUND_NAME = new FundTextField<String>("FundName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FundDescription</b>
     * </p>
     *
     * @return Fund Description
     */
    @SerializedName( "FundDescription" )
    @JsonProperty( "FundDescription" )
    @Nullable
    @ODataField( odataName = "FundDescription" )
    private String fundDescription;
    /**
     * Use with available fluent helpers to apply the <b>FundDescription</b> field to query operations.
     *
     */
    public final static FundTextField<String> FUND_DESCRIPTION = new FundTextField<String>("FundDescription");
    /**
     * Navigation property <b>to_Fund</b> for <b>FundText</b> to single <b>FundCore</b>.
     *
     */
    @SerializedName( "to_Fund" )
    @JsonProperty( "to_Fund" )
    @ODataField( odataName = "to_Fund" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private FundCore toFund;
    /**
     * Use with available fluent helpers to apply the <b>to_Fund</b> navigation property to query operations.
     *
     */
    public final static FundTextOneToOneLink<FundCore> TO_FUND = new FundTextOneToOneLink<FundCore>("to_Fund");

    @Nonnull
    @Override
    public Class<FundText> getType()
    {
        return FundText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FinancialManagementArea</b>
     * </p>
     *
     * @param financialManagementArea
     *            Financial Management Area
     */
    public void setFinancialManagementArea( @Nullable final String financialManagementArea )
    {
        rememberChangedField("FinancialManagementArea", this.financialManagementArea);
        this.financialManagementArea = financialManagementArea;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @param fund
     *            Fund
     */
    public void setFund( @Nullable final String fund )
    {
        rememberChangedField("Fund", this.fund);
        this.fund = fund;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>FundName</b>
     * </p>
     *
     * @param fundName
     *            Fund Name
     */
    public void setFundName( @Nullable final String fundName )
    {
        rememberChangedField("FundName", this.fundName);
        this.fundName = fundName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FundDescription</b>
     * </p>
     *
     * @param fundDescription
     *            Fund Description
     */
    public void setFundDescription( @Nullable final String fundDescription )
    {
        rememberChangedField("FundDescription", this.fundDescription);
        this.fundDescription = fundDescription;
    }

    @Override
    protected String getEntityCollection()
    {
        return "FundText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("FinancialManagementArea", getFinancialManagementArea());
        result.put("Fund", getFund());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("FinancialManagementArea", getFinancialManagementArea());
        values.put("Fund", getFund());
        values.put("Language", getLanguage());
        values.put("FundName", getFundName());
        values.put("FundDescription", getFundDescription());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("FinancialManagementArea") ) {
                final Object value = values.remove("FinancialManagementArea");
                if( (value == null) || (!value.equals(getFinancialManagementArea())) ) {
                    setFinancialManagementArea(((String) value));
                }
            }
            if( values.containsKey("Fund") ) {
                final Object value = values.remove("Fund");
                if( (value == null) || (!value.equals(getFund())) ) {
                    setFund(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("FundName") ) {
                final Object value = values.remove("FundName");
                if( (value == null) || (!value.equals(getFundName())) ) {
                    setFundName(((String) value));
                }
            }
            if( values.containsKey("FundDescription") ) {
                final Object value = values.remove("FundDescription");
                if( (value == null) || (!value.equals(getFundDescription())) ) {
                    setFundDescription(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Fund") ) {
                final Object value = (values).remove("to_Fund");
                if( value instanceof Map ) {
                    if( toFund == null ) {
                        toFund = new FundCore();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toFund.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> FundTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new FundTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> FundTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new FundTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.FundService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toFund != null ) {
            (values).put("to_Fund", toFund);
        }
        return values;
    }

    /**
     * Fetches the <b>FundCore</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Fund</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>FundCore</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FundCore fetchFund()
    {
        return fetchFieldAsSingle("to_Fund", FundCore.class);
    }

    /**
     * Retrieval of associated <b>FundCore</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Fund</b>.
     * <p>
     * If the navigation property <b>to_Fund</b> of a queried <b>FundText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>FundCore</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public FundCore getFundOrFetch()
    {
        if( toFund == null ) {
            toFund = fetchFund();
        }
        return toFund;
    }

    /**
     * Retrieval of associated <b>FundCore</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Fund</b>.
     * <p>
     * If the navigation property for an entity <b>FundText</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Fund</b> is already loaded, the result will contain the
     *         <b>FundCore</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<FundCore> getFundIfPresent()
    {
        return Option.of(toFund);
    }

    /**
     * Overwrites the associated <b>FundCore</b> entity for the loaded navigation property <b>to_Fund</b>.
     *
     * @param value
     *            New <b>FundCore</b> entity.
     */
    public void setFund( final FundCore value )
    {
        toFund = value;
    }

    /**
     * Helper class to allow for fluent creation of FundText instances.
     *
     */
    public final static class FundTextBuilder
    {

        private FundCore toFund;
        private String fund = null;

        private FundText.FundTextBuilder toFund( final FundCore value )
        {
            toFund = value;
            return this;
        }

        /**
         * Navigation property <b>to_Fund</b> for <b>FundText</b> to single <b>FundCore</b>.
         *
         * @param value
         *            The FundCore to build this FundText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FundText.FundTextBuilder fund( final FundCore value )
        {
            return toFund(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>Fund</b>
         * </p>
         *
         * @param value
         *            The fund to build this FundText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FundText.FundTextBuilder fund( final String value )
        {
            fund = value;
            return this;
        }

    }

}
